/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.utils.MutationUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class DeleteBindingFix
implements LocalQuickFix {
    private static final Logger LOGGER = Logger.getInstance((String)"RedundantToProviderBindingInspection");

    DeleteBindingFix() {
    }

    @NotNull
    public String getName() {
        String string = GuiceBundle.message("delete.binding", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/DeleteBindingFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/DeleteBindingFix", "getFamilyName"));
        }
        return "";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/guice/inspections/DeleteBindingFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/guice/inspections/DeleteBindingFix", "applyFix"));
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethodCallExpression.class);
        assert (call != null);
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        try {
            assert (qualifier != null);
            MutationUtils.replaceExpression(qualifier.getText(), (PsiExpression)call);
        }
        catch (IncorrectOperationException e) {
            LOGGER.error((Throwable)e);
        }
    }
}

