/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.project;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.ExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryLevel;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemDebugEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.idea.IdeaModule;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.DefaultExternalDependencyId;
import org.jetbrains.plugins.gradle.ExternalDependencyId;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.BuildScriptClasspathModel;
import org.jetbrains.plugins.gradle.model.DefaultExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.data.GradleSourceSetData;
import org.jetbrains.plugins.gradle.service.project.GradleProjectResolver;
import org.jetbrains.plugins.gradle.service.project.ProjectResolverContext;
import org.jetbrains.plugins.gradle.settings.GradleExecutionWorkspace;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleProjectResolverUtil {
    private static final Logger LOG = Logger.getInstance(GradleProjectResolverUtil.class);
    @NotNull
    private static final Key<Object> CONTAINER_KEY = Key.create(Object.class, (int)1000);

    @NotNull
    public static DataNode<ModuleData> createMainModule(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull DataNode<ProjectData> projectDataNode) {
        String mainModuleFileDirectoryPath;
        if (resolverCtx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolverCtx", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "createMainModule"));
        }
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "createMainModule"));
        }
        if (projectDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDataNode", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "createMainModule"));
        }
        String moduleName = gradleModule.getName();
        if (moduleName == null) {
            throw new IllegalStateException("Module with undefined name detected: " + gradleModule);
        }
        ProjectData projectData = (ProjectData)projectDataNode.getData();
        String mainModuleConfigPath = GradleProjectResolverUtil.getModuleConfigPath(resolverCtx, gradleModule, projectData.getLinkedExternalProjectPath());
        String ideProjectPath = resolverCtx.getIdeProjectPath();
        String relativePath = FileUtil.isAncestor((String)projectData.getLinkedExternalProjectPath(), (String)mainModuleConfigPath, (boolean)false) ? FileUtil.getRelativePath((String)projectData.getLinkedExternalProjectPath(), (String)mainModuleConfigPath, (char)'/') : String.valueOf(FileUtil.pathHashCode((String)mainModuleConfigPath));
        String string = ideProjectPath == null ? mainModuleConfigPath : (mainModuleFileDirectoryPath = ideProjectPath + '/' + (relativePath == null || relativePath.equals(".") ? "" : relativePath));
        if (ExternalSystemDebugEnvironment.DEBUG_ORPHAN_MODULES_PROCESSING) {
            LOG.info(String.format("Creating module data ('%s') with the external config path: '%s'", gradleModule.getGradleProject().getPath(), mainModuleConfigPath));
        }
        String mainModuleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule);
        ModuleData moduleData = new ModuleData(mainModuleId, GradleConstants.SYSTEM_ID, StdModuleTypes.JAVA.getId(), moduleName, mainModuleFileDirectoryPath, mainModuleConfigPath);
        ExternalProject externalProject = resolverCtx.getExtraProject(gradleModule, ExternalProject.class);
        if (externalProject != null) {
            moduleData.setGroup(externalProject.getGroup());
            moduleData.setVersion(externalProject.getVersion());
            moduleData.setDescription(externalProject.getDescription());
            if (!resolverCtx.isResolveModulePerSourceSet()) {
                moduleData.setArtifacts(externalProject.getArtifacts());
            }
        }
        DataNode dataNode = projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
        if (dataNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "createMainModule"));
        }
        return dataNode;
    }

    @NotNull
    public static String getModuleConfigPath(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull String rootProjectPath) {
        if (resolverCtx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolverCtx", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleConfigPath"));
        }
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleConfigPath"));
        }
        if (rootProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootProjectPath", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleConfigPath"));
        }
        GradleBuild build = resolverCtx.getExtraProject(gradleModule, GradleBuild.class);
        if (build != null) {
            String string;
            String gradlePath = gradleModule.getGradleProject().getPath();
            File moduleDirPath = GradleProjectResolverUtil.getModuleDirPath(build, gradlePath);
            if (moduleDirPath == null) {
                throw new IllegalStateException(String.format("Unable to find root directory for module '%s'", gradleModule.getName()));
            }
            try {
                string = ExternalSystemApiUtil.toCanonicalPath((String)moduleDirPath.getCanonicalPath());
            }
            catch (IOException e) {
                LOG.warn("construction of the canonical path for the module fails", (Throwable)e);
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleConfigPath"));
            }
            return string;
        }
        String string = GradleUtil.getConfigPath(gradleModule.getGradleProject(), rootProjectPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleConfigPath"));
        }
        return string;
    }

    @Nullable
    public static File getModuleDirPath(@NotNull GradleBuild build, @NotNull String path) {
        if (build == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "build", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleDirPath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleDirPath"));
        }
        for (BasicGradleProject project : build.getProjects()) {
            if (!project.getPath().equals(path)) continue;
            return project.getProjectDirectory();
        }
        return null;
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule) {
        if (resolverCtx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolverCtx", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        GradleProject gradleProject = gradleModule.getGradleProject();
        String gradlePath = gradleProject.getPath();
        String compositePrefix = "";
        if (gradleModule.getProject() != resolverCtx.getModels().getIdeaProject() && !StringUtil.isEmpty((String)gradlePath) && !":".equals(gradlePath)) {
            compositePrefix = gradleModule.getProject().getName();
        }
        String string = compositePrefix + GradleProjectResolverUtil.getModuleId(gradlePath, gradleModule.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        return string;
    }

    @NotNull
    public static String getModuleId(String gradlePath, String moduleName) {
        String string = StringUtil.isEmpty((String)gradlePath) || ":".equals(gradlePath) ? moduleName : gradlePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ExternalProject externalProject) {
        if (externalProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProject", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        String string = externalProject.getId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ExternalProject externalProject, @NotNull ExternalSourceSet sourceSet) {
        if (externalProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProject", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        if (sourceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSet", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        String mainModuleId = GradleProjectResolverUtil.getModuleId(externalProject);
        String string = mainModuleId + ":" + sourceSet.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ProjectResolverContext resolverCtx, @NotNull IdeaModule gradleModule, @NotNull ExternalSourceSet sourceSet) {
        if (resolverCtx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolverCtx", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        if (sourceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSet", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        String mainModuleId = GradleProjectResolverUtil.getModuleId(resolverCtx, gradleModule);
        String string = mainModuleId + ":" + sourceSet.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        return string;
    }

    @NotNull
    public static String getModuleId(@NotNull ExternalProjectDependency projectDependency) {
        String moduleId;
        if (projectDependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDependency", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        DependencyScope dependencyScope = GradleProjectResolverUtil.getDependencyScope(projectDependency.getScope());
        String projectPath = projectDependency.getProjectPath();
        String string = moduleId = StringUtil.isEmpty((String)projectPath) || ":".equals(projectPath) ? projectDependency.getName() : projectPath;
        moduleId = "default".equals(projectDependency.getConfigurationName()) ? moduleId + (dependencyScope == DependencyScope.TEST ? ":test" : ":main") : moduleId + ':' + projectDependency.getConfigurationName();
        String string2 = moduleId;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getModuleId"));
        }
        return string2;
    }

    @Nullable
    public static String getSourceSetName(Module module) {
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        if (!"sourceSet".equals(ExternalSystemApiUtil.getExternalModuleType((Module)module))) {
            return null;
        }
        String externalProjectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (externalProjectId == null) {
            return null;
        }
        int i = externalProjectId.lastIndexOf(58);
        if (i == -1 || externalProjectId.length() < i + 1) {
            return null;
        }
        return externalProjectId.substring(i + 1);
    }

    @Nullable
    public static String getGradlePath(Module module) {
        String gradlePath;
        if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)GradleConstants.SYSTEM_ID, (Module)module)) {
            return null;
        }
        String projectId = ExternalSystemApiUtil.getExternalProjectId((Module)module);
        if (projectId == null) {
            return null;
        }
        String moduleType = ExternalSystemApiUtil.getExternalModuleType((Module)module);
        if ("sourceSet".equals(moduleType)) {
            int lastColonIndex = projectId.lastIndexOf(58);
            assert (lastColonIndex != -1);
            int firstColonIndex = projectId.indexOf(58);
            gradlePath = firstColonIndex == lastColonIndex ? ":" : projectId.substring(firstColonIndex, lastColonIndex);
        } else {
            gradlePath = projectId.charAt(0) == ':' ? projectId : ":";
        }
        return gradlePath;
    }

    @NotNull
    public static DependencyScope getDependencyScope(@Nullable String scope) {
        DependencyScope dependencyScope = scope != null ? DependencyScope.valueOf((String)scope) : DependencyScope.COMPILE;
        if (dependencyScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getDependencyScope"));
        }
        return dependencyScope;
    }

    public static void attachGradleSdkSources(@NotNull IdeaModule gradleModule, @Nullable File libFile, @NotNull LibraryData library, @NotNull ProjectResolverContext resolverCtx) {
        if (gradleModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleModule", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "attachGradleSdkSources"));
        }
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "attachGradleSdkSources"));
        }
        if (resolverCtx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolverCtx", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "attachGradleSdkSources"));
        }
        BuildScriptClasspathModel buildScriptClasspathModel = resolverCtx.getExtraProject(gradleModule, BuildScriptClasspathModel.class);
        if (buildScriptClasspathModel == null) {
            return;
        }
        File gradleHomeDir = buildScriptClasspathModel.getGradleHomeDir();
        if (gradleHomeDir == null) {
            return;
        }
        GradleVersion gradleVersion = GradleVersion.version((String)buildScriptClasspathModel.getGradleVersion());
        GradleProjectResolverUtil.attachGradleSdkSources(libFile, library, gradleHomeDir, gradleVersion);
    }

    public static void attachGradleSdkSources(@Nullable File libFile, @NotNull LibraryData library, @NotNull File gradleHomeDir, @NotNull GradleVersion gradleVersion) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "attachGradleSdkSources"));
        }
        if (gradleHomeDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleHomeDir", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "attachGradleSdkSources"));
        }
        if (gradleVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleVersion", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "attachGradleSdkSources"));
        }
        if (libFile == null || !libFile.getName().startsWith("gradle-")) {
            return;
        }
        if (!FileUtil.isAncestor((File)gradleHomeDir, (File)libFile, (boolean)true)) {
            return;
        }
        File libOrPluginsFile = libFile.getParentFile();
        if (libOrPluginsFile != null && "plugins".equals(libOrPluginsFile.getName())) {
            libOrPluginsFile = libOrPluginsFile.getParentFile();
        }
        if (libOrPluginsFile != null && "lib".equals(libOrPluginsFile.getName()) && libOrPluginsFile.getParentFile() != null) {
            int endIndex;
            File srcDir = new File(libOrPluginsFile.getParentFile(), "src");
            if (gradleVersion.compareTo(GradleVersion.version((String)"1.9")) >= 0 && (endIndex = libFile.getName().indexOf(gradleVersion.getVersion())) != -1) {
                String srcDirChild = libFile.getName().substring("gradle-".length(), endIndex - 1);
                srcDir = new File(srcDir, srcDirChild);
            }
            if (srcDir.isDirectory()) {
                library.addPath(LibraryPathType.SOURCE, srcDir.getAbsolutePath());
            }
        }
    }

    public static Collection<DependencyData> getIdeDependencies(@NotNull ProjectResolverContext resolverCtx, @NotNull DataNode<? extends ModuleData> moduleDataNode, @NotNull Collection<ExternalDependency> dependencies) throws IllegalStateException {
        if (resolverCtx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolverCtx", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getIdeDependencies"));
        }
        if (moduleDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleDataNode", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getIdeDependencies"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "getIdeDependencies"));
        }
        DataNode ideProject = ExternalSystemApiUtil.findParent(moduleDataNode, (Key)ProjectKeys.PROJECT);
        assert (ideProject != null);
        Map sourceSetMap = (Map)ideProject.getUserData(GradleProjectResolver.RESOLVED_SOURCE_SETS);
        assert (sourceSetMap != null);
        Map artifactsMap = (Map)ideProject.getUserData(GradleProjectResolver.CONFIGURATION_ARTIFACTS);
        assert (artifactsMap != null);
        DataNode fakeNode = new DataNode(CONTAINER_KEY, moduleDataNode.getData(), null);
        GradleProjectResolverUtil.buildDependencies(resolverCtx, sourceSetMap, artifactsMap, (DataNode<? extends ExternalEntityData>)fakeNode, dependencies, null);
        Collection dataNodes = ExternalSystemApiUtil.findAllRecursively((DataNode)fakeNode, node -> node.getData() instanceof DependencyData);
        return ContainerUtil.map((Collection)dataNodes, node -> (DependencyData)node.getData());
    }

    public static void buildDependencies(@NotNull ProjectResolverContext resolverCtx, @NotNull Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap, @NotNull Map<String, String> artifactsMap, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, @NotNull Collection<ExternalDependency> dependencies, @Nullable DataNode<ProjectData> ideProject) throws IllegalStateException {
        if (resolverCtx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolverCtx", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "buildDependencies"));
        }
        if (sourceSetMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSetMap", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "buildDependencies"));
        }
        if (artifactsMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactsMap", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "buildDependencies"));
        }
        if (ownerDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerDataNode", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "buildDependencies"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "buildDependencies"));
        }
        HashMap dependencyMap = ContainerUtil.newHashMap();
        LinkedList queue = ContainerUtil.newLinkedList(dependencies);
        while (!queue.isEmpty()) {
            ExternalDependency dependency = (ExternalDependency)queue.remove();
            ExternalDependency seenDependency = (ExternalDependency)dependencyMap.get(dependency.getId());
            if (seenDependency != null) {
                DependencyScope currentScope;
                if (dependency instanceof ExternalLibraryDependency) {
                    DefaultExternalMultiLibraryDependency mergedDependency;
                    if (seenDependency instanceof ExternalLibraryDependency && !FileUtil.filesEqual((File)((ExternalLibraryDependency)seenDependency).getFile(), (File)((ExternalLibraryDependency)dependency).getFile())) {
                        mergedDependency = new DefaultExternalMultiLibraryDependency();
                        mergedDependency.setName(dependency.getId().getName());
                        mergedDependency.setGroup(dependency.getId().getGroup());
                        mergedDependency.setVersion(dependency.getId().getVersion());
                        mergedDependency.setPackaging(dependency.getId().getPackaging());
                        mergedDependency.setClassifier(dependency.getId().getClassifier());
                        mergedDependency.setScope(dependency.getScope());
                        mergedDependency.setClasspathOrder(dependency.getClasspathOrder());
                        mergedDependency.getDependencies().addAll(dependency.getDependencies());
                        mergedDependency.getFiles().addAll(ContainerUtil.packNullables((Object[])new File[]{((ExternalLibraryDependency)seenDependency).getFile(), ((ExternalLibraryDependency)dependency).getFile()}));
                        mergedDependency.getSources().addAll(ContainerUtil.packNullables((Object[])new File[]{((ExternalLibraryDependency)seenDependency).getSource(), ((ExternalLibraryDependency)dependency).getSource()}));
                        mergedDependency.getJavadoc().addAll(ContainerUtil.packNullables((Object[])new File[]{((ExternalLibraryDependency)seenDependency).getJavadoc(), ((ExternalLibraryDependency)dependency).getJavadoc()}));
                        dependencyMap.put(dependency.getId(), mergedDependency);
                        continue;
                    }
                    if (seenDependency instanceof DefaultExternalMultiLibraryDependency) {
                        mergedDependency = (DefaultExternalMultiLibraryDependency)seenDependency;
                        mergedDependency.getFiles().addAll(ContainerUtil.packNullables((Object[])new File[]{((ExternalLibraryDependency)dependency).getFile()}));
                        mergedDependency.getSources().addAll(ContainerUtil.packNullables((Object[])new File[]{((ExternalLibraryDependency)dependency).getSource()}));
                        mergedDependency.getJavadoc().addAll(ContainerUtil.packNullables((Object[])new File[]{((ExternalLibraryDependency)dependency).getJavadoc()}));
                        continue;
                    }
                }
                DependencyScope prevScope = seenDependency.getScope() == null ? DependencyScope.COMPILE : DependencyScope.valueOf((String)seenDependency.getScope());
                DependencyScope dependencyScope = currentScope = dependency.getScope() == null ? DependencyScope.COMPILE : DependencyScope.valueOf((String)dependency.getScope());
                if (prevScope.isForProductionCompile() || prevScope.isForProductionRuntime() && currentScope.isForProductionRuntime()) continue;
            }
            dependencyMap.put(new DefaultExternalDependencyId(dependency.getId()), dependency);
            queue.addAll(dependency.getDependencies());
        }
        GradleProjectResolverUtil.doBuildDependencies(resolverCtx, sourceSetMap, artifactsMap, dependencyMap, ownerDataNode, dependencies, ideProject);
    }

    private static void doBuildDependencies(@NotNull ProjectResolverContext resolverCtx, @NotNull Map<String, Pair<DataNode<GradleSourceSetData>, ExternalSourceSet>> sourceSetMap, @NotNull Map<String, String> artifactsMap, @NotNull Map<ExternalDependencyId, ExternalDependency> mergedDependencyMap, @NotNull DataNode<? extends ExternalEntityData> ownerDataNode, @NotNull Collection<ExternalDependency> dependencies, @Nullable DataNode<ProjectData> ideProject) throws IllegalStateException {
        if (resolverCtx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolverCtx", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "doBuildDependencies"));
        }
        if (sourceSetMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSetMap", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "doBuildDependencies"));
        }
        if (artifactsMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactsMap", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "doBuildDependencies"));
        }
        if (mergedDependencyMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedDependencyMap", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "doBuildDependencies"));
        }
        if (ownerDataNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerDataNode", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "doBuildDependencies"));
        }
        if (dependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependencies", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "doBuildDependencies"));
        }
        LinkedHashMap dependencyMap = ContainerUtil.newLinkedHashMap();
        for (ExternalDependency dependency : dependencies) {
            ExternalDependency dep = (ExternalDependency)dependencyMap.get(dependency.getId());
            if (dep instanceof AbstractExternalDependency) {
                dep.getDependencies().addAll(ContainerUtil.subtract((Collection)dependency.getDependencies(), (Collection)dep.getDependencies()));
                continue;
            }
            dependencyMap.put(dependency.getId(), dependency);
        }
        for (ExternalDependency dependency : dependencyMap.values()) {
            String libraryName;
            LibraryLevel level;
            LibraryDependencyData libraryDependencyData;
            LibraryData library;
            ExternalDependency mergedDependency = (ExternalDependency)ContainerUtil.getOrElse(mergedDependencyMap, (Object)dependency.getId(), (Object)dependency);
            DependencyScope dependencyScope = GradleProjectResolverUtil.getDependencyScope(mergedDependency.getScope());
            ModuleData ownerModule = null;
            if (ownerDataNode.getData() instanceof ModuleData) {
                ownerModule = (ModuleData)ownerDataNode.getData();
            } else if (ownerDataNode.getData() instanceof DependencyData) {
                ownerModule = ((DependencyData)ownerDataNode.getData()).getOwnerModule();
            }
            assert (ownerModule != null);
            DataNode depOwnerDataNode = null;
            if (mergedDependency instanceof ExternalProjectDependency) {
                class ProjectDependencyInfo {
                    @NotNull
                    ModuleData myModuleData;
                    @Nullable
                    ExternalSourceSet mySourceSet;
                    Collection<File> dependencyArtifacts;

                    public ProjectDependencyInfo(@NotNull ModuleData moduleData, @Nullable ExternalSourceSet sourceSet, Collection<File> dependencyArtifacts) {
                        if (moduleData == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleData", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil$1ProjectDependencyInfo", "<init>"));
                        }
                        this.myModuleData = moduleData;
                        this.mySourceSet = sourceSet;
                        this.dependencyArtifacts = dependencyArtifacts;
                    }
                }
                ExternalProjectDependency projectDependency = (ExternalProjectDependency)mergedDependency;
                ArrayList projectDependencyInfos = ContainerUtil.newArrayList();
                String selectionReason = projectDependency.getSelectionReason();
                if ("composite build substitution".equals(selectionReason) && resolverCtx.getSettings() != null) {
                    GradleExecutionWorkspace executionWorkspace = resolverCtx.getSettings().getExecutionWorkspace();
                    ModuleData moduleData = executionWorkspace.findModuleDataByArtifacts(projectDependency.getProjectDependencyArtifacts());
                    if (moduleData != null) {
                        projectDependencyInfos.add(new ProjectDependencyInfo(moduleData, null, projectDependency.getProjectDependencyArtifacts()));
                    }
                } else {
                    String moduleId = GradleProjectResolverUtil.getModuleId(projectDependency);
                    Pair<DataNode<GradleSourceSetData>, ExternalSourceSet> projectPair = sourceSetMap.get(moduleId);
                    if (projectPair == null) {
                        for (File file : projectDependency.getProjectDependencyArtifacts()) {
                            moduleId = artifactsMap.get(ExternalSystemApiUtil.toCanonicalPath((String)file.getAbsolutePath()));
                            if (moduleId == null || (projectPair = sourceSetMap.get(moduleId)) == null) continue;
                            projectDependencyInfos.add(new ProjectDependencyInfo((ModuleData)((DataNode)projectPair.first).getData(), (ExternalSourceSet)projectPair.second, Collections.singleton(file)));
                        }
                    } else {
                        projectDependencyInfos.add(new ProjectDependencyInfo((ModuleData)((DataNode)projectPair.first).getData(), (ExternalSourceSet)projectPair.second, projectDependency.getProjectDependencyArtifacts()));
                    }
                }
                if (projectDependencyInfos.isEmpty()) {
                    LibraryLevel level2 = LibraryLevel.MODULE;
                    LibraryData library2 = new LibraryData(GradleConstants.SYSTEM_ID, "");
                    LibraryDependencyData libraryDependencyData2 = new LibraryDependencyData(ownerModule, library2, level2);
                    libraryDependencyData2.setScope(dependencyScope);
                    libraryDependencyData2.setOrder(mergedDependency.getClasspathOrder());
                    libraryDependencyData2.setExported(mergedDependency.getExported());
                    if (!projectDependency.getProjectDependencyArtifacts().isEmpty()) {
                        for (File artifact : projectDependency.getProjectDependencyArtifacts()) {
                            library2.addPath(LibraryPathType.BINARY, artifact.getPath());
                        }
                        depOwnerDataNode = ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData2);
                    } else {
                        depOwnerDataNode = ownerDataNode;
                    }
                } else {
                    for (ProjectDependencyInfo projectDependencyInfo : projectDependencyInfos) {
                        ModuleDependencyData moduleDependencyData = new ModuleDependencyData(ownerModule, projectDependencyInfo.myModuleData);
                        moduleDependencyData.setScope(dependencyScope);
                        if (projectDependencyInfo.mySourceSet != null && "test".equals(projectDependencyInfo.mySourceSet.getName())) {
                            moduleDependencyData.setProductionOnTestDependency(true);
                        }
                        moduleDependencyData.setOrder(mergedDependency.getClasspathOrder());
                        moduleDependencyData.setExported(mergedDependency.getExported());
                        moduleDependencyData.setModuleDependencyArtifacts((Collection)ContainerUtil.map(projectDependencyInfo.dependencyArtifacts, File::getPath));
                        depOwnerDataNode = ownerDataNode.createChild(ProjectKeys.MODULE_DEPENDENCY, (Object)moduleDependencyData);
                    }
                    if (projectDependencyInfos.size() > 1) {
                        depOwnerDataNode = ownerDataNode;
                    }
                }
            } else if (mergedDependency instanceof ExternalLibraryDependency) {
                File javaDocPath;
                String libraryName2 = mergedDependency.getId().getPresentableName();
                LibraryLevel level3 = StringUtil.isNotEmpty((String)libraryName2) ? LibraryLevel.PROJECT : LibraryLevel.MODULE;
                library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName2);
                libraryDependencyData = new LibraryDependencyData(ownerModule, library, level3);
                libraryDependencyData.setScope(dependencyScope);
                libraryDependencyData.setOrder(mergedDependency.getClasspathOrder());
                libraryDependencyData.setExported(mergedDependency.getExported());
                library.addPath(LibraryPathType.BINARY, ((ExternalLibraryDependency)mergedDependency).getFile().getAbsolutePath());
                Iterator sourcePath = ((ExternalLibraryDependency)mergedDependency).getSource();
                if (sourcePath != null) {
                    library.addPath(LibraryPathType.SOURCE, ((File)((Object)sourcePath)).getAbsolutePath());
                }
                if ((javaDocPath = ((ExternalLibraryDependency)mergedDependency).getJavadoc()) != null) {
                    library.addPath(LibraryPathType.DOC, javaDocPath.getAbsolutePath());
                }
                depOwnerDataNode = ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
                if (StringUtil.isNotEmpty((String)libraryName2)) {
                    GradleProjectResolverUtil.linkProjectLibrary(ideProject, library);
                }
            } else if (mergedDependency instanceof ExternalMultiLibraryDependency) {
                level = LibraryLevel.MODULE;
                libraryName = mergedDependency.getId().getPresentableName();
                library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName);
                libraryDependencyData = new LibraryDependencyData(ownerModule, library, level);
                libraryDependencyData.setScope(dependencyScope);
                libraryDependencyData.setOrder(mergedDependency.getClasspathOrder());
                libraryDependencyData.setExported(mergedDependency.getExported());
                for (File file : ((ExternalMultiLibraryDependency)mergedDependency).getFiles()) {
                    library.addPath(LibraryPathType.BINARY, file.getAbsolutePath());
                }
                for (File file : ((ExternalMultiLibraryDependency)mergedDependency).getSources()) {
                    library.addPath(LibraryPathType.SOURCE, file.getAbsolutePath());
                }
                for (File file : ((ExternalMultiLibraryDependency)mergedDependency).getJavadoc()) {
                    library.addPath(LibraryPathType.DOC, file.getAbsolutePath());
                }
                depOwnerDataNode = ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
            } else if (mergedDependency instanceof FileCollectionDependency) {
                level = LibraryLevel.MODULE;
                libraryName = "";
                library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName);
                libraryDependencyData = new LibraryDependencyData(ownerModule, library, level);
                libraryDependencyData.setScope(dependencyScope);
                libraryDependencyData.setOrder(mergedDependency.getClasspathOrder());
                libraryDependencyData.setExported(mergedDependency.getExported());
                for (File file : ((FileCollectionDependency)mergedDependency).getFiles()) {
                    library.addPath(LibraryPathType.BINARY, file.getAbsolutePath());
                }
                ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
            } else if (mergedDependency instanceof UnresolvedExternalDependency) {
                level = LibraryLevel.PROJECT;
                libraryName = mergedDependency.getId().getPresentableName();
                library = new LibraryData(GradleConstants.SYSTEM_ID, libraryName, true);
                libraryDependencyData = new LibraryDependencyData(ownerModule, library, level);
                libraryDependencyData.setScope(dependencyScope);
                String failureMessage = ((UnresolvedExternalDependency)mergedDependency).getFailureMessage();
                if (failureMessage != null) {
                    library.addPath(LibraryPathType.BINARY, failureMessage);
                }
                ownerDataNode.createChild(ProjectKeys.LIBRARY_DEPENDENCY, (Object)libraryDependencyData);
                GradleProjectResolverUtil.linkProjectLibrary(ideProject, library);
            }
            if (depOwnerDataNode == null) continue;
            GradleProjectResolverUtil.doBuildDependencies(resolverCtx, sourceSetMap, artifactsMap, mergedDependencyMap, depOwnerDataNode, dependency.getDependencies(), ideProject);
        }
    }

    public static void linkProjectLibrary(@Nullable DataNode<ProjectData> ideProject, @NotNull LibraryData library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "linkProjectLibrary"));
        }
        if (ideProject == null) {
            return;
        }
        DataNode libraryData = ExternalSystemApiUtil.find(ideProject, (Key)ProjectKeys.LIBRARY, node -> {
            if (library == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "lambda$linkProjectLibrary$2"));
            }
            return library.equals(node.getData());
        });
        if (libraryData == null) {
            ideProject.createChild(ProjectKeys.LIBRARY, (Object)library);
        }
    }

    public static boolean isIdeaTask(String taskName, @Nullable String group) {
        if ((group == null || "ide".equalsIgnoreCase(group)) && StringUtil.containsIgnoreCase((String)taskName, (String)"idea")) {
            return true;
        }
        return "other".equalsIgnoreCase(group) && StringUtil.containsIgnoreCase((String)taskName, (String)"idea");
    }

    @Nullable
    public static DataNode<ModuleData> findModule(@Nullable DataNode<ProjectData> projectNode, @NotNull String modulePath) {
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "findModule"));
        }
        if (projectNode == null) {
            return null;
        }
        return ExternalSystemApiUtil.find(projectNode, (Key)ProjectKeys.MODULE, node -> {
            if (modulePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "lambda$findModule$3"));
            }
            return ((ModuleData)node.getData()).getLinkedExternalProjectPath().equals(modulePath);
        });
    }

    @Nullable
    public static DataNode<ModuleData> findModuleById(@Nullable DataNode<ProjectData> projectNode, @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "findModuleById"));
        }
        if (projectNode == null) {
            return null;
        }
        return ExternalSystemApiUtil.find(projectNode, (Key)ProjectKeys.MODULE, node -> {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "lambda$findModuleById$4"));
            }
            return ((ModuleData)node.getData()).getId().equals(path);
        });
    }

    @Nullable
    public static DataNode<TaskData> findTask(@Nullable DataNode<ProjectData> projectNode, @NotNull String modulePath, @NotNull String taskPath) {
        String taskName;
        DataNode<ModuleData> moduleNode;
        if (modulePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulePath", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "findTask"));
        }
        if (taskPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskPath", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "findTask"));
        }
        if (StringUtil.startsWith((CharSequence)taskPath, (CharSequence)":")) {
            int i = taskPath.lastIndexOf(58);
            String path = taskPath.substring(0, i);
            moduleNode = GradleProjectResolverUtil.findModuleById(projectNode, path);
            if (moduleNode == null || !FileUtil.isAncestor((String)((ModuleData)moduleNode.getData()).getLinkedExternalProjectPath(), (String)modulePath, (boolean)false)) {
                moduleNode = GradleProjectResolverUtil.findModule(projectNode, modulePath);
            }
            taskName = i + 1 <= taskPath.length() ? taskPath.substring(i + 1) : taskPath;
        } else {
            moduleNode = GradleProjectResolverUtil.findModule(projectNode, modulePath);
            taskName = taskPath;
        }
        if (moduleNode == null) {
            return null;
        }
        return ExternalSystemApiUtil.find(moduleNode, (Key)ProjectKeys.TASK, node -> {
            if (taskPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskPath", "org/jetbrains/plugins/gradle/service/project/GradleProjectResolverUtil", "lambda$findTask$5"));
            }
            String name = ((TaskData)node.getData()).getName();
            return name.equals(taskName) || name.equals(taskPath);
        });
    }
}

