/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.flows;

import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.flows.beans.AnnotatedFlowDefinition;
import com.intellij.jsf.flows.beans.AnnotatedFlowDefinitionRenameable;
import com.intellij.jsf.flows.beans.AnnotatedNodeDefinition;
import com.intellij.jsf.flows.beans.AnnotatedNodeDefinitionRenameable;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.flows.FlowDefinition;
import com.intellij.jsf.model.xml.flows.FlowNode;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowsCommonUtils {
    public static final Key<FakePsiElement> FLOW_FAKE_PSI_ELEMENT_KEY = Key.create((String)"FLOW_FAKE_PSI_ELEMENT_KEY");
    public static final Key<FakePsiElement> NODE_FAKE_PSI_ELEMENT_KEY = Key.create((String)"FLOW_NODE_FAKE_PSI_ELEMENT_KEY");
    private static Collection EXCLUDE_FLOWS = Arrays.asList("WEB-INF", "resources");
    public static String[] VIEW_CREATE_METHODS = new String[]{"viewNode", "switchNode", "returnNode", "flowCallNode", "methodCallNode"};

    @Nullable
    public static Pair<PsiElement, String> findFlowDefinitionByName(@NotNull Module module, @NotNull String value) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "findFlowDefinitionByName"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jsf/flows/FlowsCommonUtils", "findFlowDefinitionByName"));
        }
        Ref resolve = Ref.create(null);
        FlowsCommonUtils.processAllFlows((Processor<Pair<PsiElement, String>>)((Processor)pair -> {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/jsf/flows/FlowsCommonUtils", "lambda$findFlowDefinitionByName$0"));
            }
            if (value.equals(pair.second)) {
                resolve.set(pair);
                return false;
            }
            return true;
        }), module);
        return (Pair)resolve.get();
    }

    public static boolean processAllFlows(@NotNull Processor<Pair<PsiElement, String>> processor, @NotNull Module module) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/jsf/flows/FlowsCommonUtils", "processAllFlows"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "processAllFlows"));
        }
        if (!FlowsCommonUtils.processAnnotatedFlowDefinitions(processor, module)) {
            return false;
        }
        if (!FlowsCommonUtils.processDirectoryFlowDefinitions(processor, module)) {
            return false;
        }
        return FlowsCommonUtils.processFacesConfigFlowDefinitions(processor, module);
    }

    public static boolean processAnnotatedFlowDefinitions(@NotNull Processor<Pair<PsiElement, String>> processor, @NotNull Module module) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/jsf/flows/FlowsCommonUtils", "processAnnotatedFlowDefinitions"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "processAnnotatedFlowDefinitions"));
        }
        Set<CdiProduces.Method> producers = FlowsCommonUtils.getFlowDefinitionProducers(module);
        for (CdiProduces.Method producer : producers) {
            for (Pair<PsiElement, String> flow : FlowsCommonUtils.getFlowIds((PsiMethod)producer.getPsiElement(), module)) {
                if (processor.process(flow)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processDirectoryFlowDefinitions(@NotNull Processor<Pair<PsiElement, String>> processor, @NotNull Module module) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/jsf/flows/FlowsCommonUtils", "processDirectoryFlowDefinitions"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "processDirectoryFlowDefinitions"));
        }
        for (PsiDirectory psiDirectory : FlowsCommonUtils.getFlowsDirectories(module)) {
            FlowDefinition definition = FlowsCommonUtils.getExplicitFlowDefinition(psiDirectory);
            if (!(definition != null ? !FlowsCommonUtils.processFlowDefinition(processor, definition) : !processor.process((Object)Pair.create((Object)psiDirectory, (Object)psiDirectory.getName())))) continue;
            return false;
        }
        return true;
    }

    public static boolean processFacesConfigFlowDefinitions(@NotNull Processor<Pair<PsiElement, String>> processor, @NotNull Module module) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/jsf/flows/FlowsCommonUtils", "processFacesConfigFlowDefinitions"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "processFacesConfigFlowDefinitions"));
        }
        for (FacesDomModel facesDomModel : JsfCommonUtils.getAllFacesModels(module)) {
            for (FlowDefinition flowDefinition : facesDomModel.getFacesConfig().getFlowDefinitions()) {
                if (FlowsCommonUtils.processFlowDefinition(processor, flowDefinition)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processFlowDefinition(@NotNull Processor<Pair<PsiElement, String>> processor, @NotNull FlowDefinition definition) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/jsf/flows/FlowsCommonUtils", "processFlowDefinition"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/jsf/flows/FlowsCommonUtils", "processFlowDefinition"));
        }
        XmlElement element = definition.getXmlElement();
        String value = definition.getId().getStringValue();
        return element == null || StringUtil.isEmptyOrSpaces((String)value) || processor.process((Object)Pair.create((Object)element, (Object)value));
    }

    @NotNull
    public static Set<CdiProduces.Method> getFlowDefinitionProducers(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "getFlowDefinitionProducers"));
        }
        HashSet flowDefinitionProduces = new HashSet();
        for (CdiProduces produce : CdiJamModel.getModel((Module)module).getProduces(true, false)) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)produce.getPsiElement(), Collections.singleton("javax.faces.flow.builder.FlowDefinition"))) continue;
            PsiMethod psiMethod = (PsiMethod)produce.getPsiElement();
            for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
                PsiType parameterType;
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)parameter, Collections.singleton("javax.faces.flow.builder.FlowBuilderParameter")) || !((parameterType = parameter.getType()) instanceof PsiClassType) || !InheritanceUtil.isInheritor((PsiType)parameterType, (String)"javax.faces.flow.builder.FlowBuilder")) continue;
                flowDefinitionProduces.add((CdiProduces.Method)produce);
            }
        }
        HashSet hashSet = flowDefinitionProduces;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/flows/FlowsCommonUtils", "getFlowDefinitionProducers"));
        }
        return hashSet;
    }

    public static Set<Pair<PsiElement, String>> getViewIds(@NotNull PsiMethod produceMethod, @NotNull Module module) {
        if (produceMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "produceMethod", "com/intellij/jsf/flows/FlowsCommonUtils", "getViewIds"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "getViewIds"));
        }
        HashSet pairs = new HashSet();
        PsiClass flowBuilderClass = JavaPsiFacade.getInstance((Project)produceMethod.getProject()).findClass("javax.faces.flow.builder.FlowBuilder", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (flowBuilderClass != null) {
            LocalSearchScope scope = new LocalSearchScope((PsiElement)produceMethod);
            for (String viewCreateMethodName : VIEW_CREATE_METHODS) {
                for (PsiMethod method : flowBuilderClass.findMethodsByName(viewCreateMethodName, true)) {
                    pairs.addAll(StringExpressionHelper.searchStringExpressions((PsiMethod)method, (SearchScope)scope, (int)0));
                }
            }
        }
        return pairs;
    }

    public static Set<Pair<PsiElement, String>> getFlowIds(@NotNull PsiMethod produceMethod, @NotNull Module module) {
        PsiMethod[] flowIdMethods;
        if (produceMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "produceMethod", "com/intellij/jsf/flows/FlowsCommonUtils", "getFlowIds"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "getFlowIds"));
        }
        PsiClass flowBuilderClass = JavaPsiFacade.getInstance((Project)produceMethod.getProject()).findClass("javax.faces.flow.builder.FlowBuilder", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        if (flowBuilderClass != null && (flowIdMethods = flowBuilderClass.findMethodsByName("id", true)).length == 1) {
            return StringExpressionHelper.searchStringExpressions((PsiMethod)flowIdMethods[0], (SearchScope)new LocalSearchScope((PsiElement)produceMethod), (int)1);
        }
        return Collections.emptySet();
    }

    public static FakePsiElement getOrCreateFlowFakeElement(@NotNull Pair<PsiElement, String> definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/jsf/flows/FlowsCommonUtils", "getOrCreateFlowFakeElement"));
        }
        PsiElement psiElement = (PsiElement)definition.first;
        Object data = (FakePsiElement)psiElement.getUserData(FLOW_FAKE_PSI_ELEMENT_KEY);
        if (data == null) {
            data = psiElement instanceof PsiLiteralExpression ? new AnnotatedFlowDefinitionRenameable((PsiLiteralExpression)psiElement) : new AnnotatedFlowDefinition(psiElement, (String)definition.second);
            psiElement.putUserData(FLOW_FAKE_PSI_ELEMENT_KEY, data);
        }
        return data;
    }

    public static FakePsiElement getOrCreateNodeFakeElement(@NotNull Pair<PsiElement, String> definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/jsf/flows/FlowsCommonUtils", "getOrCreateNodeFakeElement"));
        }
        PsiElement psiElement = (PsiElement)definition.first;
        Object data = (FakePsiElement)psiElement.getUserData(NODE_FAKE_PSI_ELEMENT_KEY);
        if (data == null) {
            data = psiElement instanceof PsiLiteralExpression ? new AnnotatedNodeDefinitionRenameable((PsiLiteralExpression)psiElement) : new AnnotatedNodeDefinition(psiElement, (String)definition.second);
            psiElement.putUserData(NODE_FAKE_PSI_ELEMENT_KEY, data);
        }
        return data;
    }

    public static FakePsiElement getOrCreateFlowFakeElement(@NotNull PsiLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/jsf/flows/FlowsCommonUtils", "getOrCreateFlowFakeElement"));
        }
        Object data = (FakePsiElement)expression.getUserData(FLOW_FAKE_PSI_ELEMENT_KEY);
        if (data == null) {
            data = new AnnotatedFlowDefinitionRenameable(expression);
            expression.putUserData(FLOW_FAKE_PSI_ELEMENT_KEY, data);
        }
        return data;
    }

    public static FakePsiElement getOrCreateNodeFakeElement(@NotNull PsiLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/jsf/flows/FlowsCommonUtils", "getOrCreateNodeFakeElement"));
        }
        Object data = (FakePsiElement)expression.getUserData(NODE_FAKE_PSI_ELEMENT_KEY);
        if (data == null) {
            data = new AnnotatedNodeDefinitionRenameable(expression);
            expression.putUserData(NODE_FAKE_PSI_ELEMENT_KEY, data);
        }
        return data;
    }

    @Nullable
    public static PsiDirectory findFlowDirectory(@NotNull String flowId, @NotNull Module module) {
        if (flowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowId", "com/intellij/jsf/flows/FlowsCommonUtils", "findFlowDirectory"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "findFlowDirectory"));
        }
        for (PsiDirectory directory : FlowsCommonUtils.getFlowsDirectories(module)) {
            if (!flowId.equals(directory.getName())) continue;
            return directory;
        }
        return null;
    }

    @NotNull
    public static List<FlowNode> getFlowNodes(@NotNull FlowDefinition flow) {
        if (flow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flow", "com/intellij/jsf/flows/FlowsCommonUtils", "getFlowNodes"));
        }
        List list = DomUtil.getChildrenOfType((DomElement)flow, FlowNode.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/flows/FlowsCommonUtils", "getFlowNodes"));
        }
        return list;
    }

    public static boolean isFlowDirectoryCandidate(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/flows/FlowsCommonUtils", "isFlowDirectoryCandidate"));
        }
        return !EXCLUDE_FLOWS.contains(file.getName());
    }

    @NotNull
    public static Set<PsiDirectory> getFlowsDirectories(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "getFlowsDirectories"));
        }
        HashSet directories = new HashSet();
        FlowsCommonUtils.collectWebAppTopLevelFlowsDirectories((Set<PsiDirectory>)directories, module);
        FlowsCommonUtils.collectMetaInfFlowsDirectories((Set<PsiDirectory>)directories, module);
        HashSet hashSet = directories;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/flows/FlowsCommonUtils", "getFlowsDirectories"));
        }
        return hashSet;
    }

    private static void collectWebAppTopLevelFlowsDirectories(@NotNull Set<PsiDirectory> dirs, @NotNull Module module) {
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "com/intellij/jsf/flows/FlowsCommonUtils", "collectWebAppTopLevelFlowsDirectories"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "collectWebAppTopLevelFlowsDirectories"));
        }
        Collection webFacets = WebFacet.getInstances((Module)module);
        for (WebFacet webFacet : webFacets) {
            List roots = webFacet.getWebRoots();
            for (WebRoot root : roots) {
                VirtualFile file = root.getFile();
                if (file == null || !file.isDirectory()) continue;
                for (VirtualFile virtualFile : file.getChildren()) {
                    PsiDirectory directory;
                    if (!virtualFile.isDirectory() || !FlowsCommonUtils.isFlowDirectoryCandidate(virtualFile) || (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(virtualFile)) == null) continue;
                    dirs.add(directory);
                }
            }
        }
    }

    public static void collectMetaInfFlowsDirectories(@NotNull Set<PsiDirectory> dirs, @NotNull Module module) {
        if (dirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirs", "com/intellij/jsf/flows/FlowsCommonUtils", "collectMetaInfFlowsDirectories"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "collectMetaInfFlowsDirectories"));
        }
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            VirtualFile flows;
            VirtualFile metaInf = root.findChild("META-INF");
            if (metaInf == null || (flows = metaInf.findChild("flows")) == null) continue;
            for (VirtualFile flowsDir : flows.getChildren()) {
                PsiDirectory directory;
                if (!flowsDir.isDirectory() || (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(flowsDir)) == null) continue;
                dirs.add(directory);
            }
        }
    }

    @Nullable
    public static FlowNode findFlowNode(@NotNull String nodeId, @NotNull PsiFile file, @NotNull Module module) {
        if (nodeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeId", "com/intellij/jsf/flows/FlowsCommonUtils", "findFlowNode"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/flows/FlowsCommonUtils", "findFlowNode"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/flows/FlowsCommonUtils", "findFlowNode"));
        }
        FlowNode flowNode = FlowsCommonUtils.findNodeById(nodeId, FlowsCommonUtils.getFlowByFile(file));
        if (flowNode != null) {
            return flowNode;
        }
        for (FacesDomModel facesDomModel : JsfCommonUtils.getAllFacesModels(module)) {
            for (FlowDefinition flowDefinition : facesDomModel.getFacesConfig().getFlowDefinitions()) {
                flowNode = FlowsCommonUtils.findNodeById(nodeId, flowDefinition);
                if (flowNode == null) continue;
                return flowNode;
            }
        }
        return null;
    }

    @Nullable
    private static FlowNode findNodeById(@NotNull String flowId, @Nullable FlowDefinition flow) {
        if (flowId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flowId", "com/intellij/jsf/flows/FlowsCommonUtils", "findNodeById"));
        }
        if (flow == null || !DomUtil.hasXml((DomElement)flow)) {
            return null;
        }
        for (FlowNode flowNode : FlowsCommonUtils.getFlowNodes(flow)) {
            if (!flowId.equals(flowNode.getId().getStringValue())) continue;
            return flowNode;
        }
        return null;
    }

    @Nullable
    public static FlowDefinition getFlowByFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/flows/FlowsCommonUtils", "getFlowByFile"));
        }
        PsiDirectory directory = file.getContainingDirectory();
        if (directory != null) {
            return FlowsCommonUtils.getExplicitFlowDefinition(directory);
        }
        return null;
    }

    @Nullable
    public static FlowDefinition getExplicitFlowDefinition(@NotNull PsiDirectory directory) {
        DomFileElement facesConfigDomFileElement;
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "com/intellij/jsf/flows/FlowsCommonUtils", "getExplicitFlowDefinition"));
        }
        PsiFile flowConfig = directory.findFile(directory.getName() + "-flow.xml");
        if (flowConfig instanceof XmlFile && (facesConfigDomFileElement = DomManager.getDomManager((Project)flowConfig.getProject()).getFileElement((XmlFile)flowConfig, FacesConfig.class)) != null) {
            for (FlowDefinition flowDefinition : ((FacesConfig)facesConfigDomFileElement.getRootElement()).getFlowDefinitions()) {
                if (!DomUtil.hasXml((DomElement)flowDefinition)) continue;
                return flowDefinition;
            }
        }
        return null;
    }
}

