/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph.renderer;

import com.intellij.icons.AllIcons;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.renderer.AbstractColoredNodeCellRenderer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.JBColor;
import com.intellij.util.PlatformIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicFacesNodeCellRenderer
extends AbstractColoredNodeCellRenderer
implements Disposable {
    private final FacesConfig myFacesConfig;
    private final GraphBuilder<String, NavigationCase> myGraphBuilder;
    private final Graph2D myGraph;

    public BasicFacesNodeCellRenderer(FacesConfig facesConfig, GraphBuilder<String, NavigationCase> graphBuilder) {
        super((ModificationTracker)facesConfig.getManager());
        this.myFacesConfig = facesConfig;
        this.myGraphBuilder = graphBuilder;
        this.myGraph = graphBuilder.getGraph();
        VirtualFileAdapter myListener = new VirtualFileAdapter(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/jsf/yfilesGraph/renderer/BasicFacesNodeCellRenderer$1", "fileDeleted"));
                }
                BasicFacesNodeCellRenderer.this.clearCache();
                BasicFacesNodeCellRenderer.this.myGraph.updateViews();
            }

            public void fileCreated(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/jsf/yfilesGraph/renderer/BasicFacesNodeCellRenderer$1", "fileCreated"));
                }
                BasicFacesNodeCellRenderer.this.clearCache();
                BasicFacesNodeCellRenderer.this.myGraph.updateViews();
            }
        };
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)myListener, (Disposable)this);
    }

    public void tuneNode(NodeRealizer nodeRealizer, JPanel wrapper) {
        wrapper.removeAll();
        wrapper.setLayout(new BorderLayout());
        wrapper.add((Component)this.getIconLabel(nodeRealizer), "West");
        wrapper.add((Component)this.getLabelPanel(nodeRealizer), "Center");
    }

    private JComponent getLabelPanel(NodeRealizer nodeRealizer) {
        String nodeName = this.getNodeName(nodeRealizer.getNode());
        boolean isEmptyNode = "EMPTY_NODE".equals(nodeName);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(JBColor.background());
        jPanel.setLayout(new BorderLayout());
        JLabel comp = new JLabel(isEmptyNode ? BasicFacesNodeCellRenderer.getEmptyNodeText() : this.getNodeName(nodeRealizer.getNode()) + " ");
        comp.setForeground(isEmptyNode || "*".equals(nodeName) || this.getFileForNode(nodeRealizer) != null ? JBColor.foreground() : JBColor.RED);
        comp.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        jPanel.add((Component)comp, "West");
        return jPanel;
    }

    private static String getEmptyNodeText() {
        return FacesBundle.message("faces.graph.empty.node.text", new Object[0]);
    }

    private JComponent getIconLabel(NodeRealizer nodeRealizer) {
        Icon icon = AllIcons.FileTypes.Unknown;
        VirtualFile virtualFile = this.getFileForNode(nodeRealizer);
        if (virtualFile != null) {
            if (virtualFile.isDirectory()) {
                icon = PlatformIcons.DIRECTORY_CLOSED_ICON;
            } else {
                PsiFile psiFile = PsiManager.getInstance((Project)this.myFacesConfig.getManager().getProject()).findFile(virtualFile);
                if (psiFile != null) {
                    icon = psiFile.getIcon(0);
                }
            }
        }
        JLabel jLabel = new JLabel(icon);
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return jLabel;
    }

    @Nullable
    private VirtualFile getFileForNode(NodeRealizer nodeRealizer) {
        String name = this.getNodeName(nodeRealizer.getNode());
        boolean isEmptyNode = "EMPTY_NODE".equals(name);
        String string = name = isEmptyNode ? "*" : name;
        if (name != null) {
            return JsfCommonUtils.getFileByRelativePath(this.myFacesConfig, name);
        }
        return null;
    }

    @NotNull
    private String getNodeName(Node node) {
        String nodeName = this.myGraphBuilder.getNodeName(this.myGraphBuilder.getNodeObject(node));
        String string = nodeName == null ? "" : nodeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/yfilesGraph/renderer/BasicFacesNodeCellRenderer", "getNodeName"));
        }
        return string;
    }

    public void dispose() {
    }
}

