/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph.renderer;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.jsf.yfilesGraph.renderer.DesigntimeIncludeNode;
import com.intellij.jsf.yfilesGraph.renderer.ManagedBeanNode;
import com.intellij.jsf.yfilesGraph.renderer.RuntimeIncludeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.StatusBarProgress;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.tree.TreeUtil;
import icons.J2EEIcons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacesPageNodeCellRenderer
implements NodeCellRenderer {
    @NonNls
    public static final String SIMPLE_TREE_KEY = "SIMPLE_TREE_KEY";
    private JLabel myLabel;
    private JPanel myRootPanel;
    private JPanel myTreePanel;
    private SimpleTree myTree;
    private SimpleTreeBuilder myBuilder;
    private final GraphBuilder<String, NavigationCase> myGraphBuilder;
    private final FacesConfig myFacesConfig;
    private final String myViewId;
    private final Node myNode;

    public FacesPageNodeCellRenderer(GraphBuilder<String, NavigationCase> garphBuilder, FacesConfig facesConfig, String viewId, Node node, Disposable disposable) {
        this.myGraphBuilder = garphBuilder;
        this.myFacesConfig = facesConfig;
        this.myViewId = viewId;
        this.myNode = node;
        this.$$$setupUI$$$();
        this.myTreePanel.setLayout(new BorderLayout());
        this.myRootPanel.setPreferredSize(new Dimension(300, 500));
        this.myTreePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.createTree()), "Center");
        Disposer.register((Disposable)disposable, (Disposable)this.myBuilder);
    }

    public JComponent getNodeCellRendererComponent(Graph2DView view, NodeRealizer nodeRealizer, Object userObject, boolean selected) {
        this.myLabel.setText(this.getNodeName(nodeRealizer));
        this.myBuilder.updateFromRoot();
        return this.myRootPanel;
    }

    @NotNull
    private String getNodeName(NodeRealizer nodeRealizer) {
        Node node = nodeRealizer.getNode();
        String nodeName = this.myGraphBuilder.getNodeName(this.myGraphBuilder.getNodeObject(node));
        String string = nodeName == null ? "" : nodeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/yfilesGraph/renderer/FacesPageNodeCellRenderer", "getNodeName"));
        }
        return string;
    }

    private Component createTree() {
        this.myTree = new MySimpleTree();
        this.myTree.setPopupGroup(FacesPageNodeCellRenderer.getPopupActions(), "unknown");
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        TreeUtil.installActions((JTree)this.myTree);
        this.myBuilder = new SimpleTreeBuilder((JTree)this.myTree, (DefaultTreeModel)this.myTree.getModel(), (AbstractTreeStructure)new MyStructure(), (Comparator)WeightBasedComparator.INSTANCE){

            @NotNull
            protected ProgressIndicator createProgressIndicator() {
                StatusBarProgress statusBarProgress = new StatusBarProgress();
                if (statusBarProgress == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/yfilesGraph/renderer/FacesPageNodeCellRenderer$1", "createProgressIndicator"));
                }
                return statusBarProgress;
            }
        };
        this.myBuilder.initRoot();
        return this.myTree;
    }

    private static ActionGroup getPopupActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("Faces.MainPageTreePopup"));
        return group;
    }

    public SimpleTree getTree() {
        return this.myTree;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), null, 0, 0, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLabel = jLabel = new JLabel();
        jLabel.setText("Unknown Page");
        ((Component)jLabel).setFont(new Font("Tahoma", 1, 14));
        jLabel.setFocusTraversalPolicyProvider(true);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 3, null, null, null));
        this.myTreePanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private class ManagedBeansSimpleNode
    extends SimpleNode {
        @NonNls
        private static final String MANAGED_BEANS_NODE_NAME = "Managed Beans";

        protected ManagedBeansSimpleNode() {
            this.setPlainText(MANAGED_BEANS_NODE_NAME);
            this.setUniformIcon(J2EEIcons.ManagedBean);
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        public SimpleNode[] getChildren() {
            ArrayList<ManagedBeanNode> nodes = new ArrayList<ManagedBeanNode>();
            Set<XmlTag> managedBeansForPage = JsfCommonUtils.getManagedBeansForPage(FacesPageNodeCellRenderer.this.myFacesConfig, FacesPageNodeCellRenderer.this.myViewId);
            for (XmlTag xmlTag : managedBeansForPage) {
                nodes.add(new ManagedBeanNode(xmlTag));
            }
            return nodes.toArray(new SimpleNode[nodes.size()]);
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (NONE == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/yfilesGraph/renderer/FacesPageNodeCellRenderer$ManagedBeansSimpleNode", "getEqualityObjects"));
            }
            return NONE;
        }
    }

    private class MySimpleTree
    extends SimpleTree
    implements DataProvider {
        public MySimpleTree() {
            super((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        }

        protected void invokeContextMenu(MouseEvent e) {
            SwingUtilities.invokeLater(() -> {
                ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("unknown", this.getPopupGroup());
                Graph2D graph2D = (Graph2D)FacesPageNodeCellRenderer.this.myNode.getGraph();
                Point viewPoint = ((Graph2DView)graph2D.getCurrentView()).getViewPoint();
                NodeRealizer nodeRealizer = graph2D.getRealizer(FacesPageNodeCellRenderer.this.myNode);
                int x1 = (int)nodeRealizer.getX();
                int y1 = (int)nodeRealizer.getY();
                menu.getComponent().show(e.getComponent(), e.getPoint().x + x1 - viewPoint.x, e.getPoint().y + y1 - viewPoint.y);
            });
        }

        @Nullable
        public Object getData(String dataId) {
            if (dataId.equals(FacesPageNodeCellRenderer.SIMPLE_TREE_KEY)) {
                return this;
            }
            return null;
        }
    }

    private class MyStructure
    extends SimpleTreeStructure {
        private final IncludesSimpleNode myIncludesNode = new IncludesSimpleNode();
        private final ManagedBeansSimpleNode myManagedBeansNode = new ManagedBeansSimpleNode();
        private final SimpleNode myRoot = new SimpleNode(){

            public SimpleNode[] getChildren() {
                return new SimpleNode[]{MyStructure.this.myIncludesNode, MyStructure.this.myManagedBeansNode};
            }

            @NotNull
            public Object[] getEqualityObjects() {
                if (NONE == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/yfilesGraph/renderer/FacesPageNodeCellRenderer$MyStructure$1", "getEqualityObjects"));
                }
                return NONE;
            }

            public boolean isAutoExpandNode() {
                return true;
            }
        };

        private MyStructure() {
        }

        public Object getRootElement() {
            return this.myRoot;
        }

        private class IncludesSimpleNode
        extends SimpleNode {
            @NonNls
            private static final String INCLUDES_NODE_NAME = "Includes";

            protected IncludesSimpleNode() {
                this.setPlainText(INCLUDES_NODE_NAME);
                this.setUniformIcon(AllIcons.Actions.Get);
            }

            public boolean isAutoExpandNode() {
                return true;
            }

            public SimpleNode[] getChildren() {
                ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
                Collection<JspFile> includes = JsfCommonUtils.getIncludes(FacesPageNodeCellRenderer.this.myFacesConfig, FacesPageNodeCellRenderer.this.myViewId);
                List<XmlAttributeValue> runtimeIncludes = JsfCommonUtils.getRuntimeIncludes(FacesPageNodeCellRenderer.this.myFacesConfig, FacesPageNodeCellRenderer.this.myViewId);
                for (JspFile jspFile : includes) {
                    nodes.add(new DesigntimeIncludeNode(jspFile));
                }
                for (XmlAttributeValue xmlAttributeValue : runtimeIncludes) {
                    nodes.add(new RuntimeIncludeNode(xmlAttributeValue));
                }
                return nodes.toArray(new SimpleNode[nodes.size()]);
            }

            @NotNull
            public Object[] getEqualityObjects() {
                if (NONE == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/yfilesGraph/renderer/FacesPageNodeCellRenderer$MyStructure$IncludesSimpleNode", "getEqualityObjects"));
                }
                return NONE;
            }
        }
    }
}

