/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.rpc.GwtGenericsUtil;
import com.intellij.gwt.rpc.GwtSerializableUtil;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtNonSerializableRemoteServiceMethodParametersInspection
extends BaseGwtInspection {
    private final GwtSerializableInspectionState myGwtSerializableInspectionState = new GwtSerializableInspectionState();
    @NonNls
    private static final String SETTINGS_ELEMENT = "settings";

    @Nullable
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/inspections/GwtNonSerializableRemoteServiceMethodParametersInspection", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/gwt/inspections/GwtNonSerializableRemoteServiceMethodParametersInspection", "checkClass"));
        }
        GwtFacet gwtFacet = GwtNonSerializableRemoteServiceMethodParametersInspection.getFacet((PsiElement)aClass);
        if (gwtFacet == null) {
            return null;
        }
        if (RemoteServiceUtil.isRemoteServiceInterface(aClass)) {
            return this.checkRemoteService(gwtFacet, aClass, manager, isOnTheFly, isOnTheFly);
        }
        return null;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/gwt/inspections/GwtNonSerializableRemoteServiceMethodParametersInspection", "readSettings"));
        }
        Element settings = node.getChild(SETTINGS_ELEMENT);
        if (settings != null) {
            XmlSerializer.deserializeInto((Object)this.myGwtSerializableInspectionState, (Element)settings);
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/gwt/inspections/GwtNonSerializableRemoteServiceMethodParametersInspection", "writeSettings"));
        }
        Element settings = new Element(SETTINGS_ELEMENT);
        XmlSerializer.serializeInto((Object)this.myGwtSerializableInspectionState, (Element)settings, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        if (!settings.getContent().isEmpty()) {
            node.addContent(settings);
        }
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        final JCheckBox reportInterfacesCheckbox = new JCheckBox(GwtBundle.message("checkbox.text.report.interfaces", new Object[0]));
        reportInterfacesCheckbox.setSelected(this.myGwtSerializableInspectionState.isReportInterfaces());
        reportInterfacesCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GwtNonSerializableRemoteServiceMethodParametersInspection.this.myGwtSerializableInspectionState.setReportInterfaces(reportInterfacesCheckbox.isSelected());
            }
        });
        panel.add((Component)reportInterfacesCheckbox, "North");
        return panel;
    }

    private ProblemDescriptor[] checkRemoteService(GwtFacet gwtFacet, PsiClass aClass, InspectionManager manager, boolean onTheFly, boolean isOnTheFly) {
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>(0);
        GwtSerializableUtil.SerializableChecker serializableChecker = GwtSerializableUtil.createSerializableChecker(gwtFacet, this.myGwtSerializableInspectionState.isReportInterfaces());
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)manager.getProject());
        for (PsiMethod method : aClass.getMethods()) {
            PsiJavaCodeReferenceElement[] thrown;
            for (PsiParameter param : method.getParameterList().getParameters()) {
                String typeParametersString = GwtGenericsUtil.getTypeParametersString(method, param.getName());
                GwtNonSerializableRemoteServiceMethodParametersInspection.checkTypeSerial(param.getTypeElement(), typeParametersString, serializableChecker, manager, result, isOnTheFly);
            }
            PsiTypeElement returnTypeElement = method.getReturnTypeElement();
            if (returnTypeElement != null) {
                String typeParameters = GwtGenericsUtil.getReturnTypeParametersString(method);
                GwtNonSerializableRemoteServiceMethodParametersInspection.checkTypeSerial(returnTypeElement, typeParameters, serializableChecker, manager, result, isOnTheFly);
            }
            for (PsiJavaCodeReferenceElement referenceElement : thrown = method.getThrowsList().getReferenceElements()) {
                PsiClassType classType = psiFacade.getElementFactory().createType(referenceElement);
                PsiClass psiClass = classType.resolve();
                if (psiClass != null && !InheritanceUtil.isInheritor((PsiClass)psiClass, (boolean)false, (String)"java.lang.Exception")) {
                    String message = GwtBundle.message("problem.description.0.is.not.a.checked.exception", psiClass.getQualifiedName());
                    result.add(manager.createProblemDescriptor((PsiElement)referenceElement, message, onTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
                    continue;
                }
                GwtNonSerializableRemoteServiceMethodParametersInspection.checkTypeSerial((PsiType)classType, (PsiElement)referenceElement, null, serializableChecker, manager, result, isOnTheFly);
            }
        }
        return result.toArray(new ProblemDescriptor[result.size()]);
    }

    private static void checkTypeSerial(PsiTypeElement typeElement, @Nullable String typeParameterStrings, GwtSerializableUtil.SerializableChecker serializableChecker, InspectionManager manager, List<ProblemDescriptor> result, boolean isOnTheFly) {
        PsiType type = typeElement.getType();
        GwtNonSerializableRemoteServiceMethodParametersInspection.checkTypeSerial(type, (PsiElement)typeElement, typeParameterStrings, serializableChecker, manager, result, isOnTheFly);
    }

    private static void checkTypeSerial(PsiType type, PsiElement typeElement, @Nullable String typeParameterStrings, GwtSerializableUtil.SerializableChecker serializableChecker, InspectionManager manager, List<ProblemDescriptor> result, boolean onTheFly) {
        if (!type.isValid()) {
            return;
        }
        List<PsiType> typeParameters = GwtGenericsUtil.getTypeParameters(typeElement, typeParameterStrings);
        if (serializableChecker.isSerializable(type, typeParameters)) {
            return;
        }
        while (type instanceof PsiArrayType) {
            type = ((PsiArrayType)type).getComponentType();
        }
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClassType classType = (PsiClassType)type;
        if (!serializableChecker.getVersion().isGenericsSupported() && classType.getParameters().length > 0) {
            String description = GwtBundle.message("problem.description.generics.isnt.supported.in.gwt.before.1.5.version", new Object[0]);
            result.add(manager.createProblemDescriptor(typeElement, description, onTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
            return;
        }
        PsiClass aClass = classType.resolve();
        if (aClass != null) {
            LocalQuickFix[] quickFixes;
            String description;
            boolean haveGenericParameters = serializableChecker.getVersion().isGenericsSupported() && classType.getParameters().length > 0;
            String typeString = type.getCanonicalText();
            if (typeParameterStrings == null && !haveGenericParameters && GwtSerializableUtil.isCollection(type)) {
                description = GwtBundle.message("problem.description.type.of.collection.elements.is.not.specified", typeString);
                quickFixes = LocalQuickFix.EMPTY_ARRAY;
            } else {
                if (typeParameterStrings != null && !haveGenericParameters) {
                    typeString = typeString + typeParameterStrings;
                }
                if (!GwtNonSerializableRemoteServiceMethodParametersInspection.isInSources(aClass)) {
                    quickFixes = LocalQuickFix.EMPTY_ARRAY;
                    description = GwtBundle.message("problem.description.type.is.not.serializable", typeString);
                } else {
                    List<PsiClass> list = serializableChecker.getSerializableMarkerInterfaces();
                    PsiElementFactory psiFactory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
                    quickFixes = new LocalQuickFix[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        quickFixes[i] = IntentionManager.getInstance().convertToFix((IntentionAction)QuickFixFactory.getInstance().createExtendsListFix(aClass, psiFactory.createType(list.get(i)), true));
                    }
                    description = GwtBundle.message("problem.description.gwt.serializable.type.0.should.implements.marker.interface.1", typeString, serializableChecker.getPresentableSerializableClassesString());
                }
            }
            result.add(manager.createProblemDescriptor(typeElement, description, onTheFly, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING));
        }
    }

    private static boolean isInSources(PsiClass aClass) {
        VirtualFile file = aClass.getContainingFile().getVirtualFile();
        if (file == null) {
            return false;
        }
        Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)aClass.getProject());
        return module != null && ModuleRootManager.getInstance((Module)module).getFileIndex().isInSourceContent(file);
    }

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.non.serializable.service.method.parameters", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtNonSerializableRemoteServiceMethodParametersInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("NonSerializableServiceParameters" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/inspections/GwtNonSerializableRemoteServiceMethodParametersInspection", "getShortName"));
        }
        return "NonSerializableServiceParameters";
    }

    public static class GwtSerializableInspectionState {
        private boolean myReportInterfaces = true;

        @Tag(value="report-interfaces")
        public boolean isReportInterfaces() {
            return this.myReportInterfaces;
        }

        public void setReportInterfaces(boolean reportInterfaces) {
            this.myReportInterfaces = reportInterfaces;
        }
    }
}

