/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.psi;

import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.psi.GwtSourcePathsRefresherProjectComponent;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.JavaLanguageLevelPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtLanguageLevelPusher
extends JavaLanguageLevelPusher {
    public static void pushGwtLanguageLevel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/psi/GwtLanguageLevelPusher", "pushGwtLanguageLevel"));
        }
        PushedFilePropertiesUpdater.getInstance((Project)project).pushAll(new FilePropertyPusher[]{new GwtLanguageLevelPusher()});
    }

    public static void updateConfigurationAndPush(Project project, boolean forcePush) {
        GwtSourcePathsRefresherProjectComponent.getInstance(project).enqueueRefreshSourcePathsTask(forcePush);
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/psi/GwtLanguageLevelPusher", "acceptsDirectory"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/psi/GwtLanguageLevelPusher", "acceptsDirectory"));
        }
        return GwtFacet.isInModuleWithGwtFacet(project, file) && super.acceptsDirectory(file, project);
    }

    public LanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        GwtFacet gwtFacet;
        Module module;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/psi/GwtLanguageLevelPusher", "getImmediateValue"));
        }
        if (file != null && (module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project)) != null && (gwtFacet = GwtFacet.getInstance(module)) != null) {
            GwtSourcePathsRefresherProjectComponent component;
            LanguageLevel clientLanguageLevel;
            GwtFacetConfiguration configuration = (GwtFacetConfiguration)gwtFacet.getConfiguration();
            LanguageLevel moduleLanguageLevel = EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)module);
            if (moduleLanguageLevel != (clientLanguageLevel = configuration.getClientLanguageLevel()) && ((component = GwtSourcePathsRefresherProjectComponent.getInstance(project)).isSourceFile(file) || component.isSuperSourceFile(file))) {
                return clientLanguageLevel;
            }
        }
        return super.getImmediateValue(project, file);
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/psi/GwtLanguageLevelPusher", "afterRootsChanged"));
        }
        super.afterRootsChanged(project);
        GwtLanguageLevelPusher.updateConfigurationAndPush(project, false);
    }

    @Nullable
    public String getInconsistencyLanguageLevelMessage(@NotNull String message, @NotNull PsiElement element, @NotNull LanguageLevel level, @NotNull PsiFile file) {
        GwtSourcePathsRefresherProjectComponent sourcePathsComponent;
        VirtualFile virtualFile;
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/gwt/psi/GwtLanguageLevelPusher", "getInconsistencyLanguageLevelMessage"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/psi/GwtLanguageLevelPusher", "getInconsistencyLanguageLevelMessage"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/gwt/psi/GwtLanguageLevelPusher", "getInconsistencyLanguageLevelMessage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/gwt/psi/GwtLanguageLevelPusher", "getInconsistencyLanguageLevelMessage"));
        }
        Project project = file.getProject();
        if (GwtFacet.isInModuleWithGwtFacet(project, virtualFile = file.getVirtualFile()) && ((sourcePathsComponent = GwtSourcePathsRefresherProjectComponent.getInstance(project)).isSourceFile(virtualFile) || sourcePathsComponent.isSuperSourceFile(virtualFile))) {
            return GwtBundle.message("gwt.insufficient.language.level", message, level.getCompilerComplianceDefaultOption());
        }
        return null;
    }
}

