/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.references;

import com.intellij.gwt.references.GwtModuleInStringLiteralReference;
import com.intellij.gwt.references.GwtModuleInXmlAttributeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class GwtModuleReferencesProvider
extends PsiReferenceProvider {
    private boolean myOutputName;

    public GwtModuleReferencesProvider(boolean outputName) {
        this.myOutputName = outputName;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/gwt/references/GwtModuleReferencesProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/gwt/references/GwtModuleReferencesProvider", "getReferencesByElement"));
        }
        if (element instanceof XmlAttributeValue) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new GwtModuleInXmlAttributeReference((XmlAttributeValue)element, this.myOutputName)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/references/GwtModuleReferencesProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (element instanceof PsiLiteralExpression) {
            PsiReference[] psiReferenceArray = new PsiReference[]{new GwtModuleInStringLiteralReference((PsiLiteralExpression)element, this.myOutputName)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/references/GwtModuleReferencesProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/references/GwtModuleReferencesProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

