/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.run.remoteUi;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.gwt.run.GwtClasspathUtil;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class GwtErrorFilter
implements Filter {
    private static final Pattern FILE_NAME_EXTRACTOR = Pattern.compile("^\\[ERROR] Errors in '(.*)'$");
    private static final Pattern LINE_NUMBER_EXTRACTOR = Pattern.compile("^\\[ERROR] (Line (\\d+):.+)$");
    private static final Pattern BINDER_NAME_EXTRACTOR = Pattern.compile("^Computing all possible rebind results for '(.*)'$");
    private static final Pattern BINDER_LINE_EXTRACTOR = Pattern.compile("^\\[ERROR] (.*[(]:(\\d+)[)])$");
    private final Module myModule;
    private final Project myProject;
    private int myContextLeadingSpacesCount;
    private VirtualFile myCurrentVirtualFile;

    public GwtErrorFilter(Module module) {
        this.myModule = module;
        this.myProject = module.getProject();
        this.myContextLeadingSpacesCount = -1;
    }

    @Nullable
    public Filter.Result applyFilter(String line, int entireLength) {
        String trimmedLine = line.trim();
        int leadingSpacesCount = GwtErrorFilter.spacesCount(line);
        if (leadingSpacesCount <= this.myContextLeadingSpacesCount || this.myContextLeadingSpacesCount == -1) {
            Matcher matcher;
            String currentFilePath = null;
            if (this.myContextLeadingSpacesCount != -1) {
                this.myContextLeadingSpacesCount = -1;
                this.myCurrentVirtualFile = null;
            }
            if ((matcher = FILE_NAME_EXTRACTOR.matcher(trimmedLine)).matches()) {
                currentFilePath = matcher.group(1);
            } else {
                matcher = BINDER_NAME_EXTRACTOR.matcher(trimmedLine);
                if (matcher.matches()) {
                    JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
                    PsiClass binderClass = psiFacade.findClass(matcher.group(1), GlobalSearchScope.moduleScope((Module)this.myModule));
                    String string = currentFilePath = binderClass == null ? null : UiBinderMappingService.deduceTemplateFileUrl(binderClass);
                }
            }
            if (currentFilePath != null) {
                this.myCurrentVirtualFile = this.findVirtualFile(currentFilePath);
                if (this.myCurrentVirtualFile != null) {
                    this.myContextLeadingSpacesCount = leadingSpacesCount;
                }
            }
            return null;
        }
        if (this.myCurrentVirtualFile == null || !this.myCurrentVirtualFile.isValid()) {
            return null;
        }
        Matcher matcher = LINE_NUMBER_EXTRACTOR.matcher(trimmedLine);
        if (!matcher.find() && !(matcher = BINDER_LINE_EXTRACTOR.matcher(trimmedLine)).find()) {
            return null;
        }
        int startIndex = entireLength + leadingSpacesCount - line.length() + matcher.start(1);
        int endIndex = entireLength + leadingSpacesCount - line.length() + matcher.end(1);
        int lineNumber = Integer.parseInt(matcher.group(2)) - 1;
        OpenFileHyperlinkInfo hyperlinkInfo = new OpenFileHyperlinkInfo(this.myProject, this.myCurrentVirtualFile, lineNumber, 0);
        return new Filter.Result(startIndex, endIndex, (HyperlinkInfo)hyperlinkInfo);
    }

    private VirtualFile findVirtualFile(String currentFilePath) {
        if (currentFilePath.startsWith("file:")) {
            try {
                return VfsUtil.findFileByURL((URL)new URL(currentFilePath));
            }
            catch (MalformedURLException malformedURLException) {
            }
        } else {
            for (VirtualFile root : GwtClasspathUtil.getSourceRootsOfGwtModules(this.myModule, false).getRootDirs()) {
                VirtualFile file = root.findFileByRelativePath(currentFilePath);
                if (file == null) continue;
                return file;
            }
        }
        return null;
    }

    private static int spacesCount(String line) {
        int count;
        int length = line.length();
        for (count = 0; count < length && line.charAt(count) <= ' '; ++count) {
        }
        return count;
    }
}

