/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.uiBinder.mapping;

import com.intellij.gwt.uiBinder.UiRendererUtil;
import com.intellij.gwt.uiBinder.mapping.UiBinderMappingService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.BidirectionalMultiMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiBinderMappingServiceImpl
extends UiBinderMappingService {
    private final Module myModule;
    private final CachedValue<CachedEntry> myCachedEntry;

    public UiBinderMappingServiceImpl(Module module) {
        this.myModule = module;
        this.myCachedEntry = CachedValuesManager.getManager((Project)this.myModule.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.computeMapping(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}), false);
    }

    private CachedEntry computeMapping() {
        PsiMethod[] abstractCellRenderMethods;
        PsiClass abstractCellClass;
        final CachedEntry result = new CachedEntry();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
        GlobalSearchScope moduleOnlySearchScope = GlobalSearchScope.moduleScope((Module)this.myModule);
        PsiClass uiBinderInterface = psiFacade.findClass("com.google.gwt.uibinder.client.UiBinder", searchScope);
        final PsiClass uiRendererInterface = psiFacade.findClass("com.google.gwt.uibinder.client.UiRenderer", searchScope);
        if (uiBinderInterface != null && uiBinderInterface.getTypeParameters().length == 2) {
            PsiTypeParameter ownerParameter = uiBinderInterface.getTypeParameters()[1];
            ClassInheritorsSearch.search((PsiClass)uiBinderInterface, (SearchScope)moduleOnlySearchScope, (boolean)true).forEach(aClass -> {
                String className = aClass.getQualifiedName();
                if (className == null) {
                    return true;
                }
                PsiType ownerType = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)uiBinderInterface, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).substitute(ownerParameter);
                if (ownerType == null) {
                    return true;
                }
                PsiClass ownerClass = PsiTypesUtil.getPsiClass((PsiType)ownerType);
                if (ownerClass == null) {
                    return true;
                }
                String ownerClassName = ownerClass.getQualifiedName();
                if (ownerClassName == null) {
                    return true;
                }
                String uiTemplateXmlFileUrl = UiBinderMappingServiceImpl.deduceTemplateFileUrl(aClass);
                if (uiTemplateXmlFileUrl == null) {
                    return true;
                }
                result.myClassNameToUiXmlUrl.put((Object)ownerClassName, (Object)uiTemplateXmlFileUrl);
                result.myUiBinderToUiXmlUrl.put((Object)className, (Object)uiTemplateXmlFileUrl);
                return true;
            });
        }
        if (uiRendererInterface != null && uiRendererInterface.getTypeParameters().length == 0 && (abstractCellClass = psiFacade.findClass("com.google.gwt.cell.client.AbstractCell", searchScope)) != null && abstractCellClass.getTypeParameters().length == 1 && (abstractCellRenderMethods = abstractCellClass.findMethodsByName("render", false)).length == 1) {
            ClassInheritorsSearch.search((PsiClass)abstractCellClass, (SearchScope)moduleOnlySearchScope, (boolean)true).forEach((Processor)new Processor<PsiClass>(){

                public boolean process(PsiClass abstractCellInheritor) {
                    final String className = abstractCellInheritor.getQualifiedName();
                    if (className == null) {
                        return true;
                    }
                    PsiMethod renderMethod = UiRendererUtil.findRenderMethodImplementation(abstractCellInheritor);
                    if (renderMethod == null) {
                        return true;
                    }
                    PsiCodeBlock renderMethodBody = renderMethod.getBody();
                    if (renderMethodBody == null) {
                        return true;
                    }
                    renderMethodBody.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                        public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
                            super.visitMethodCallExpression(methodCallExpression);
                            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
                            String methodName = methodExpression.getReferenceName();
                            if (!"render".equals(methodName)) {
                                return;
                            }
                            PsiMethod renderMethod = methodCallExpression.resolveMethod();
                            if (renderMethod == null) {
                                return;
                            }
                            PsiClass uiRendererInheritor = renderMethod.getContainingClass();
                            if (uiRendererInheritor == null) {
                                return;
                            }
                            if (!uiRendererInheritor.isInterface()) {
                                return;
                            }
                            if (!uiRendererInheritor.isInheritor(uiRendererInterface, false)) {
                                return;
                            }
                            String uiTemplateXmlFileUrl = UiBinderMappingService.deduceTemplateFileUrl(uiRendererInheritor);
                            if (uiTemplateXmlFileUrl == null) {
                                return;
                            }
                            result.myClassNameToUiXmlUrl.put((Object)className, (Object)uiTemplateXmlFileUrl);
                            result.myUiRendererComponents.add(className);
                        }
                    });
                    return true;
                }
            });
        }
        return result;
    }

    @Override
    @NotNull
    public List<PsiClass> getBoundClasses(@NotNull PsiFile uiXmlFile) {
        if (uiXmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiXmlFile", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getBoundClasses"));
        }
        VirtualFile virtualFile = uiXmlFile.getVirtualFile();
        if (virtualFile != null) {
            Set classNames = ((CachedEntry)this.myCachedEntry.getValue()).myClassNameToUiXmlUrl.getKeys((Object)virtualFile.getUrl());
            GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)this.myModule);
            JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myModule.getProject());
            SmartList result = new SmartList();
            for (String className : classNames) {
                ContainerUtil.addIfNotNull((Collection)result, (Object)psiFacade.findClass(className, scope));
            }
            SmartList smartList = result;
            if (smartList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getBoundClasses"));
            }
            return smartList;
        }
        List<PsiClass> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getBoundClasses"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<XmlFile> getUiXmlFiles(@NotNull PsiClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getUiXmlFiles"));
        }
        String className = aClass.getQualifiedName();
        if (className != null) {
            Set urls = ((CachedEntry)this.myCachedEntry.getValue()).myClassNameToUiXmlUrl.getValues((Object)className);
            ArrayList<XmlFile> result = new ArrayList<XmlFile>();
            for (String url : urls) {
                ContainerUtil.addIfNotNull(result, (Object)this.resolveUrlToUiXmlFile(url));
            }
            ArrayList<XmlFile> arrayList = result;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getUiXmlFiles"));
            }
            return arrayList;
        }
        List<XmlFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getUiXmlFiles"));
        }
        return list;
    }

    @Override
    @Nullable
    public XmlFile getUiXmlFile(@NotNull PsiClass uiBinderInheritor) {
        Set urls;
        if (uiBinderInheritor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiBinderInheritor", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "getUiXmlFile"));
        }
        String className = uiBinderInheritor.getQualifiedName();
        if (className != null && !(urls = ((CachedEntry)this.myCachedEntry.getValue()).myUiBinderToUiXmlUrl.getValues((Object)className)).isEmpty()) {
            String url = (String)ContainerUtil.getFirstItem((Collection)urls);
            return this.resolveUrlToUiXmlFile(url);
        }
        return null;
    }

    @Override
    public boolean isUiRendererComponent(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/gwt/uiBinder/mapping/UiBinderMappingServiceImpl", "isUiRendererComponent"));
        }
        String className = psiClass.getQualifiedName();
        if (className != null) {
            return ((CachedEntry)this.myCachedEntry.getValue()).myUiRendererComponents.contains(className);
        }
        return false;
    }

    @Nullable
    private XmlFile resolveUrlToUiXmlFile(String url) {
        PsiFile psiFile;
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file != null && (psiFile = PsiManager.getInstance((Project)this.myModule.getProject()).findFile(file)) instanceof XmlFile) {
            return (XmlFile)psiFile;
        }
        return null;
    }

    private static class CachedEntry {
        public final BidirectionalMultiMap<String, String> myClassNameToUiXmlUrl = new BidirectionalMultiMap();
        public final BidirectionalMultiMap<String, String> myUiBinderToUiXmlUrl = new BidirectionalMultiMap();
        public final Set<String> myUiRendererComponents = ContainerUtil.newHashSet();

        private CachedEntry() {
        }
    }
}

