/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseNotifications;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.DatabaseInputType;
import com.intellij.database.dbimport.ImportDialog;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ReaderTask;
import com.intellij.database.dbimport.csv.CsvInputType;
import com.intellij.database.dbimport.ui.ImportPanel;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportAction
extends DumbAwareAction {
    private static final int CHAR_COUNT = 0x100000;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ImportAction", "update"));
        }
        Set<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
        DbElement element = (DbElement)ContainerUtil.getFirstItem(elements);
        boolean isOneElement = elements.size() == 1;
        e.getPresentation().setEnabledAndVisible(isOneElement && ImportUtil.canBeConsumer(element));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ImportAction", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        DbElement element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
        if (element == null) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, true, true, true, false);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null, file -> ImportAction.showDialog(project, element, file));
    }

    public static void showDialog(@NotNull Project project, @NotNull DbElement element, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        VirtualFile realFile = ImportAction.getFile(file);
        ImportAction.showDialog(project, element, realFile.getName(), new CsvInputType(realFile, 0x100000));
    }

    public static void showDialog(@NotNull Project project, @NotNull DbElement element, @NotNull String name, @NotNull InputType type) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        ImportAction.showDialog(project, new ImportInfo.Builder().producerName(name).inputType(type), element);
    }

    public static void showDialog(@NotNull Project project, @NotNull ImportInfo.Builder builder, @NotNull DbElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction", "showDialog"));
        }
        ErrorHandler handler = new ErrorHandler();
        DatabaseDialectEx dialect = DbImplUtil.getDatabaseDialect(element);
        try {
            ImportAction.showPreviewDialog(builder, dialect, element);
        }
        catch (Exception ex) {
            handler.addError(null, ex);
            DatabaseNotifications.DATABASE_VIEW_GROUP.createNotification("Import", handler.getSummary(), NotificationType.ERROR, null).notify(project);
        }
    }

    public static void showPreviewDialog(@NotNull ImportInfo.Builder builder, @NotNull DatabaseDialectEx dialect, @NotNull DbElement consumer) throws Exception {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/actions/ImportAction", "showPreviewDialog"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/actions/ImportAction", "showPreviewDialog"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/actions/ImportAction", "showPreviewDialog"));
        }
        Disposable disposable = Disposer.newDisposable();
        ImportType type = ImportType.of(consumer);
        DatabaseEditorContext editorContext = DbRefactoringHelper.createContext((DasObject)consumer, null);
        if (editorContext == null) {
            return;
        }
        DeModel model = AbstractDbRefactoringDialog.createModel(editorContext);
        DbNamespaceImpl namespace = DatabaseView.getLowestSchema(consumer);
        DasModel dasModel = consumer.getDataSource().getModel();
        DeNamespace deNamespace = ImportAction.getNamespace(model, dasModel, (DasNamespace)(namespace == null ? dasModel.getCurrentRootNamespace() : namespace));
        boolean created = ((ImportType)((Object)ObjectUtils.assertNotNull((Object)((Object)type)))).isTableCreated();
        DatabaseEditorCapabilities.TableEditorCaps caps = dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(created);
        builder.importType((ImportType)((Object)ObjectUtils.assertNotNull((Object)((Object)type))));
        ImportEditorContext context = new ImportEditorContext(editorContext, caps, builder, consumer, model, disposable, deNamespace);
        ImportPanel panel = builder.getInputType().getImportPanel(context);
        ImportDialog dialog = new ImportDialog(context, panel);
        Disposer.register((Disposable)disposable, (Disposable)dialog.getDisposable());
        dialog.show();
    }

    @NotNull
    private static VirtualFile getFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/actions/ImportAction", "getFile"));
        }
        VirtualFile root2 = JarFileSystem.getInstance().getJarRootForLocalFile(file);
        if (root2 == null) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "getFile"));
            }
            return virtualFile;
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{root2});
        VirtualFile realFile = ImportAction.find(root2.getChildren(), "csv", "txt");
        VirtualFile virtualFile = realFile == null ? file : realFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "getFile"));
        }
        return virtualFile;
    }

    @Nullable
    private static VirtualFile find(VirtualFile[] files, String ... extensions) {
        if (extensions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensions", "com/intellij/database/actions/ImportAction", "find"));
        }
        if (files == null) {
            return null;
        }
        for (String extension : extensions) {
            VirtualFile fileWithExtension = (VirtualFile)ContainerUtil.find((Object[])files, file -> StringUtil.equalsIgnoreCase((CharSequence)file.getExtension(), (CharSequence)extension));
            if (fileWithExtension == null || fileWithExtension.isDirectory()) continue;
            return fileWithExtension;
        }
        return (VirtualFile)ContainerUtil.find((Object[])files, file -> !file.isDirectory());
    }

    @Nullable
    private static DeNamespace getNamespace(@NotNull DeModel model, @NotNull DasModel dasModel, @Nullable DasNamespace namespace) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/actions/ImportAction", "getNamespace"));
        }
        if (dasModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dasModel", "com/intellij/database/actions/ImportAction", "getNamespace"));
        }
        return namespace == null ? null : (DeNamespace)model.getExportHelper().exportDeep(dasModel, (DasObject)namespace, false);
    }

    public static class CopyTable
    extends DumbAwareAction {
        public void update(AnActionEvent e) {
            Set<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
            DbElement item = (DbElement)ContainerUtil.getFirstItem(elements);
            e.getPresentation().setEnabledAndVisible(elements.size() == 1 && ImportUtil.canBeProducer(item));
        }

        public void actionPerformed(AnActionEvent e) {
            Set<DbElement> elements = DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class);
            DbElement item = (DbElement)ContainerUtil.getFirstItem(elements);
            if (item == null) {
                return;
            }
            DbTable element = (DbTable)item;
            DbDataSource source = element.getDataSource();
            LocalDataSource delegate = (LocalDataSource)source.getDelegate();
            ImportInfo.Builder builder = new ImportInfo.Builder().producerName(element.getName()).inputType(new DatabaseInputType(delegate, source, (DasTable)element, element.getProject()));
            ImportUtil.showTargetChooser(element.getProject(), builder, (DbElement)element);
        }
    }

    public static class ImportTable
    extends DumbAwareAction {
        public void update(AnActionEvent e) {
            DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
            String name = grid == null ? null : ImportTable.getProducerName(e);
            InputType type = grid == null ? null : ImportTable.getInputType(e);
            boolean hasFormatIfNeeded = !(type instanceof CsvInputType) || ImportTable.getFormat(grid) != null;
            e.getPresentation().setEnabled(name != null && type != null && hasFormatIfNeeded);
            e.getPresentation().setVisible(true);
        }

        public void actionPerformed(AnActionEvent e) {
            DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
            if (grid == null) {
                return;
            }
            List<DataConsumer.Column> cols3 = ImportUtil.getColumns(grid);
            String name = ImportTable.getProducerName(e);
            InputType type = ImportTable.getInputType(e);
            if (name == null || type == null) {
                return;
            }
            ImportInfo.Builder builder = new ImportInfo.Builder().producers(cols3).visibleProducers(ImportUtil.getVisibleColumns(grid)).rows(ImportUtil.getRows(grid)).inputType(type).producerName(name).csvFormat(ImportTable.getFormat(grid));
            DasTable table = DataGridUtil.getDatabaseTable(grid);
            ImportUtil.showTargetChooser((Project)ObjectUtils.assertNotNull((Object)e.getProject()), builder, (DbElement)ObjectUtils.tryCast((Object)table, DbElement.class));
        }

        @Nullable
        private static CsvFormat getFormat(@NotNull DataGrid grid) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/actions/ImportAction$ImportTable", "getFormat"));
            }
            CsvDocumentDataHookUp hookup = (CsvDocumentDataHookUp)ObjectUtils.tryCast(grid.getDataHookup(), CsvDocumentDataHookUp.class);
            return hookup == null ? null : hookup.getFormat();
        }

        @Nullable
        private static InputType getInputType(final @NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ImportAction$ImportTable", "getInputType"));
            }
            return ImportTable.compute(e, new Computable<InputType>(){

                @Override
                public InputType csv(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/actions/ImportAction$ImportTable$1", "csv"));
                    }
                    return new CsvInputType(file, 0x100000);
                }

                @Override
                @Nullable
                public InputType database(@Nullable DbTable table, @NotNull DataGrid grid, @Nullable JdbcConsole console) {
                    if (grid == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/actions/ImportAction$ImportTable$1", "database"));
                    }
                    DbDataSource source = DataGridUtil.getDatabaseSystem(grid);
                    if (source == null || !(source.getDelegate() instanceof LocalDataSource)) {
                        return null;
                    }
                    LocalDataSource delegate = (LocalDataSource)source.getDelegate();
                    GridDataHookUp hookup = grid.getDataHookup();
                    DatabaseGridDataHookUp databaseHookUp = (DatabaseGridDataHookUp)hookup;
                    String text = databaseHookUp.getUnlimitedQueryText();
                    SearchPath path = console == null ? null : console.getSearchPath();
                    String name = DataGridUtil.getResultSetName(e);
                    return text == null || name == null ? null : new DatabaseInputType(delegate, source, name, text, source.getProject(), path, (DasTable)table);
                }
            });
        }

        @Nullable
        private static String getProducerName(final @NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ImportAction$ImportTable", "getProducerName"));
            }
            return ImportTable.compute(e, new Computable<String>(){

                @Override
                public String csv(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/actions/ImportAction$ImportTable$2", "csv"));
                    }
                    return file.getName();
                }

                @Override
                public String database(@Nullable DbTable table, @NotNull DataGrid grid, @Nullable JdbcConsole console) {
                    if (grid == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/actions/ImportAction$ImportTable$2", "database"));
                    }
                    return DataGridUtil.getResultSetName(e);
                }
            });
        }

        @Nullable
        private static <T> T compute(@NotNull AnActionEvent e, @NotNull Computable<T> computable) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ImportAction$ImportTable", "compute"));
            }
            if (computable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/database/actions/ImportAction$ImportTable", "compute"));
            }
            DataGrid grid = DataGridUtil.getDataGrid(e.getDataContext());
            if (grid == null || !grid.isReady()) {
                return null;
            }
            GridDataHookUp hookup = grid.getDataHookup();
            if (hookup instanceof CsvDocumentDataHookUp) {
                Document document = ((CsvDocumentDataHookUp)hookup).getDocument();
                VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                return file == null ? null : (T)computable.csv(file);
            }
            if (!(hookup instanceof DatabaseGridDataHookUp)) {
                return null;
            }
            DbTable table = (DbTable)ObjectUtils.tryCast((Object)DataGridUtil.getDatabaseTable(grid), DbTable.class);
            JdbcConsole console = JdbcConsole.findConsole(e);
            return console == null && table == null ? null : (T)computable.database(table, grid, console);
        }

        private static interface Computable<T> {
            @Nullable
            public T csv(@NotNull VirtualFile var1);

            @Nullable
            public T database(@Nullable DbTable var1, @NotNull DataGrid var2, @Nullable JdbcConsole var3);
        }
    }

    public static class ImportEditorContext
    extends DatabaseEditorContext {
        private final DatabaseEditorCapabilities.TableEditorCaps myCaps;
        private final ImportManager myManager;
        private final ImportInfo.Builder myBuilder;
        private final DbElement myElement;
        private final DeModel myModel;
        private final Disposable myDisposable;
        private final DeNamespace myNamespace;
        private final List<DbTable> myTables;
        private String myTableName;

        public ImportEditorContext(@NotNull DatabaseEditorContext context, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull ImportInfo.Builder builder, @NotNull DbElement element, @NotNull DeModel model, @NotNull Disposable disposable, @Nullable DeNamespace namespace) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (caps == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/actions/ImportAction$ImportEditorContext", "<init>"));
            }
            super(context.getProject(), context.getDialect(), context.getModel(), context.getDataSource(), context.getVirtualFile());
            this.myCaps = caps;
            this.myManager = ImportManager.of(context.getDialect(), this.getDataSource() == null ? null : this.getDataSource().getDatabaseProductVersion());
            this.myBuilder = builder;
            this.myElement = element;
            this.myModel = model;
            this.myDisposable = disposable;
            this.myNamespace = namespace;
            this.myTables = this.getContextTables();
            builder.editorContext(this);
        }

        @NotNull
        public ImportInfo.Builder getBuilder() {
            ImportInfo.Builder builder = this.myBuilder;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getBuilder"));
            }
            return builder;
        }

        @NotNull
        public DbElement getElement() {
            DbElement dbElement = this.myElement;
            if (dbElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getElement"));
            }
            return dbElement;
        }

        @Override
        @NotNull
        public DeModel getModel() {
            DeModel deModel = this.myModel;
            if (deModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getModel"));
            }
            return deModel;
        }

        @Nullable
        public DeNamespace getNamespace() {
            return this.myNamespace;
        }

        @NotNull
        public Disposable getDisposable() {
            Disposable disposable = this.myDisposable;
            if (disposable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getDisposable"));
            }
            return disposable;
        }

        @NotNull
        public ImportManager getManager() {
            ImportManager importManager = this.myManager;
            if (importManager == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getManager"));
            }
            return importManager;
        }

        @NotNull
        public DatabaseEditorCapabilities.TableEditorCaps getCaps() {
            DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = this.myCaps;
            if (tableEditorCaps == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getCaps"));
            }
            return tableEditorCaps;
        }

        @NotNull
        public String getTableName() {
            String string = this.myTableName == null ? (this.myTableName = this.getTableNameInternal()) : this.myTableName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getTableName"));
            }
            return string;
        }

        public boolean isTableExists(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/actions/ImportAction$ImportEditorContext", "isTableExists"));
            }
            return ContainerUtil.exists(this.myTables, (Condition)DasUtil.byName((String)name));
        }

        @NotNull
        private String getTableNameInternal() {
            String name;
            if (this.myBuilder.getImportType().isTableCreated()) {
                String string = this.myElement.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getTableNameInternal"));
                }
                return string;
            }
            String result = name = FileUtil.getNameWithoutExtension((String)this.myBuilder.getProducerName());
            int index = 1;
            while (this.isTableExists(result)) {
                result = name + "_" + index++;
            }
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getTableNameInternal"));
            }
            return string;
        }

        @NotNull
        private List<DbTable> getContextTables() {
            DbNamespaceImpl namespace = DatabaseView.getLowestSchema(this.myElement);
            if (namespace == null || this.myElement instanceof DbTable) {
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getContextTables"));
                }
                return list;
            }
            List list = ((JBTreeTraverser)DasUtil.dasTraverser().withRoot((Object)namespace)).filter(DbTable.class).toList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$ImportEditorContext", "getContextTables"));
            }
            return list;
        }
    }

    public static interface InputType {
        @NotNull
        public ReaderTask.Input createInput(@NotNull ImportInfo var1) throws IOException;

        @NotNull
        default public ImportPanel getImportPanel(@NotNull ImportEditorContext context) throws Exception {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/ImportAction$InputType", "getImportPanel"));
            }
            ImportInfo.Builder builder = context.getBuilder();
            List components = ContainerUtil.filter(this.getComponents(context), component -> component.isVisible(builder));
            ImportPanel importPanel = new ImportPanel(components, context);
            if (importPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction$InputType", "getImportPanel"));
            }
            return importPanel;
        }

        @NotNull
        public List<ImportComponent<?, ?>> getComponents(@NotNull ImportEditorContext var1) throws Exception;

        @Nullable
        public DatabaseSystem getProducerSystem();

        @NotNull
        public String getDialogTitle();

        @NotNull
        public DatabaseDialectEx getDialect();

        @NotNull
        public DeTable createNewTable(@NotNull ImportEditorContext var1, @NotNull List<? extends ColumnDescriptor> var2, @Nullable List<DataConsumer.Row> var3);
    }
}

