/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.console;

import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.execution.console.ConsoleRootType;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.DatabaseIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbConsoleRootType
extends ConsoleRootType {
    private static final String FILE_PREFIX = "console";

    DbConsoleRootType() {
        super("db", "DB Consoles");
    }

    @NotNull
    public static DbConsoleRootType getInstance() {
        DbConsoleRootType dbConsoleRootType = (DbConsoleRootType)DbConsoleRootType.findByClass(DbConsoleRootType.class);
        if (dbConsoleRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DbConsoleRootType", "getInstance"));
        }
        return dbConsoleRootType;
    }

    @Nullable
    public Language substituteLanguage(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/DbConsoleRootType", "substituteLanguage"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/DbConsoleRootType", "substituteLanguage"));
        }
        DbDataSource dataSource = DbConsoleRootType.getDataSource(project, file);
        return dataSource != null ? DbImplUtil.getSqlDialect(project, (DatabaseSystem)dataSource) : null;
    }

    @Nullable
    public Icon substituteIcon(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/DbConsoleRootType", "substituteIcon"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/DbConsoleRootType", "substituteIcon"));
        }
        DbDataSource dataSource = DbConsoleRootType.getDataSource(project, file);
        if (dataSource == null) {
            return DatabaseIcons.Sql;
        }
        return dataSource.getIcon();
    }

    @Nullable
    public String substituteName(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/DbConsoleRootType", "substituteName"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/DbConsoleRootType", "substituteName"));
        }
        String name = file.getName();
        DbDataSource dataSource = DbConsoleRootType.getDataSource(project, file);
        if (dataSource == null) {
            return null;
        }
        if (name.startsWith(dataSource.getUniqueId())) {
            return StringUtil.replace((String)name, (String)dataSource.getUniqueId(), (String)dataSource.getName());
        }
        if (name.startsWith(FILE_PREFIX)) {
            return StringUtil.replace((String)name, (String)FILE_PREFIX, (String)dataSource.getName());
        }
        return file.isDirectory() ? name : dataSource.getName() + "-" + name;
    }

    public void fileOpened(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/DbConsoleRootType", "fileOpened"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/DbConsoleRootType", "fileOpened"));
        }
        DatabaseEditorHelper.configureConsole(file, source);
    }

    public void fileClosed(@NotNull VirtualFile file, @NotNull FileEditorManager source) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/console/DbConsoleRootType", "fileClosed"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/console/DbConsoleRootType", "fileClosed"));
        }
        DatabaseEditorHelper.disposeConsoleIfSafe(file, source);
    }

    public boolean isIgnored(@NotNull Project project, @NotNull VirtualFile element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/DbConsoleRootType", "isIgnored"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/console/DbConsoleRootType", "isIgnored"));
        }
        return DbConsoleRootType.getDataSource(project, element) == null;
    }

    public void registerTreeUpdater(@NotNull Project project, final @NotNull AbstractTreeBuilder builder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/DbConsoleRootType", "registerTreeUpdater"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/console/DbConsoleRootType", "registerTreeUpdater"));
        }
        DbPsiFacade.getInstance((Project)project).addModificationTrackerListener((ModificationTrackerListener)new ModificationTrackerListener<DbPsiFacade>(){

            public void modificationCountChanged(DbPsiFacade source) {
                builder.queueUpdate();
            }
        }, (Disposable)builder);
    }

    @NotNull
    public String getEntrySeparator() {
        if ("\n;-- -. . -..- - / . -. - .-. -.--\n" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DbConsoleRootType", "getEntrySeparator"));
        }
        return "\n;-- -. . -..- - / . -. - .-. -.--\n";
    }

    @NotNull
    public String getContentPathName(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/console/DbConsoleRootType", "getContentPathName"));
        }
        String string = id + "/" + FILE_PREFIX;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DbConsoleRootType", "getContentPathName"));
        }
        return string;
    }

    @NotNull
    public String getHistoryPathName(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/database/console/DbConsoleRootType", "getHistoryPathName"));
        }
        String string = id;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DbConsoleRootType", "getHistoryPathName"));
        }
        return string;
    }

    @NotNull
    public String getDefaultFileExtension() {
        if ("sql" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/console/DbConsoleRootType", "getDefaultFileExtension"));
        }
        return "sql";
    }

    @Nullable
    public static DbDataSource getDataSource(@NotNull Project project, @NotNull VirtualFile original) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/console/DbConsoleRootType", "getDataSource"));
        }
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/database/console/DbConsoleRootType", "getDataSource"));
        }
        ScratchFileService service = ScratchFileService.getInstance();
        DbConsoleRootType rootType = DbConsoleRootType.getInstance();
        for (VirtualFile file = original; file != null && service.getRootType(file) == rootType; file = file.getParent()) {
            String name = file.getNameWithoutExtension();
            String uuid = name.substring(0, Math.min(36, name.length()));
            DbDataSource dataSource = DbPsiFacade.getInstance((Project)project).findDataSource(uuid);
            if (dataSource == null) continue;
            return dataSource;
        }
        return null;
    }

    public static boolean isConsoleFile(@Nullable VirtualFile file) {
        return file != null && ScratchFileService.getInstance().getRootType(file) == DbConsoleRootType.getInstance();
    }
}

