/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.csv.ui;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvFormatsListComponent;
import com.intellij.database.csv.ui.CsvFormatsSettingsUI;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvFormatsSelectionUI
extends CsvFormatsSettingsUI {
    private SaveActionSupport mySaveActionSupport;

    public CsvFormatsSelectionUI(@NotNull Disposable parent, @Nullable SaveActionSupport support, @NotNull CsvFormatUISettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/CsvFormatsSelectionUI", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/csv/ui/CsvFormatsSelectionUI", "<init>"));
        }
        super(false, parent, settings);
        this.mySaveActionSupport = support;
    }

    public void notifySaved(@NotNull CsvFormat format) {
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/CsvFormatsSelectionUI", "notifySaved"));
        }
        this.getFormatsListComponent().markUnmodified(format);
    }

    @Override
    @NotNull
    protected ToolbarDecorator createFormatListDecorator() {
        AnActionButton action = new AnActionButton("", AllIcons.Actions.Menu_saveall){
            ActionGroup group;
            {
                this.group = CsvFormatsSelectionUI.this.getSaveActionsGroup();
            }

            public void actionPerformed(AnActionEvent e) {
                Component component = e.getInputEvent().getComponent();
                if (component == null) {
                    return;
                }
                ActionManager.getInstance().createActionPopupMenu("ProjectViewToolbar", this.group).getComponent().show(component, 0, component.getHeight());
            }
        };
        action.addCustomUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return CsvFormatsSelectionUI.this.hasChanges();
            }
        });
        ToolbarDecorator toolbarDecorator = super.createFormatListDecorator().disableUpDownActions().addExtraAction(action);
        if (toolbarDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsSelectionUI", "createFormatListDecorator"));
        }
        return toolbarDecorator;
    }

    @NotNull
    private ActionGroup getSaveActionsGroup() {
        abstract class SaveAction
        extends AnAction {
            public SaveAction(String text) {
                super(text);
            }

            public void update(AnActionEvent e) {
                CsvFormat selectedFormat = CsvFormatsSelectionUI.this.getSelectedFormat();
                e.getPresentation().setEnabled(CsvFormatsSelectionUI.this.mySaveActionSupport != null && selectedFormat != null && CsvFormatsSelectionUI.this.getFormatsListComponent().isModified(selectedFormat));
            }
        }
        DefaultActionGroup saveActionsGroup = new DefaultActionGroup(new AnAction[]{new SaveAction("Save"){
            {
                super(text);
            }

            public void actionPerformed(AnActionEvent e) {
                CsvFormatsSelectionUI.this.mySaveActionSupport.save(CsvFormatsSelectionUI.this, (CsvFormat)ObjectUtils.assertNotNull((Object)CsvFormatsSelectionUI.this.getSelectedFormat()));
            }
        }, new SaveAction("Save As..."){
            {
                super(text);
            }

            public void actionPerformed(AnActionEvent e) {
                CsvFormat toSaveAs = (CsvFormat)ObjectUtils.assertNotNull((Object)CsvFormatsSelectionUI.this.getSelectedFormat());
                CsvFormatsListComponent formatsList = CsvFormatsSelectionUI.this.getFormatsListComponent();
                formatsList.resetFormat(toSaveAs.name);
                CsvFormat newFormat = formatsList.newFormat(toSaveAs);
                formatsList.editFormatName(newFormat, (Consumer<CsvFormat>)((Consumer)format -> CsvFormatsSelectionUI.this.mySaveActionSupport.save(CsvFormatsSelectionUI.this, (CsvFormat)format)));
            }
        }, new SaveAction("Save All"){
            {
                super(text);
            }

            @Override
            public void update(AnActionEvent e) {
                e.getPresentation().setEnabled(CsvFormatsSelectionUI.this.mySaveActionSupport != null && CsvFormatsSelectionUI.this.hasChanges());
            }

            public void actionPerformed(AnActionEvent e) {
                DatabaseSettings.getSettings().setCsvFormats(CsvFormatsSelectionUI.this.getFormats());
            }
        }});
        saveActionsGroup.setPopup(true);
        DefaultActionGroup defaultActionGroup = saveActionsGroup;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsSelectionUI", "getSaveActionsGroup"));
        }
        return defaultActionGroup;
    }

    private boolean hasChanges() {
        return !this.getFormats().equals(DatabaseSettings.getSettings().getCsvFormats());
    }

    @NotNull
    public static CsvFormatsSelectionUI createDatabaseSettingsBackedForm(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/CsvFormatsSelectionUI", "createDatabaseSettingsBackedForm"));
        }
        CsvFormatsSelectionUI csvFormatsSelectionUI = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(parent, CsvFormatUISettings.DEFAULT);
        if (csvFormatsSelectionUI == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsSelectionUI", "createDatabaseSettingsBackedForm"));
        }
        return csvFormatsSelectionUI;
    }

    @NotNull
    public static CsvFormatsSelectionUI createDatabaseSettingsBackedForm(@NotNull Disposable parent, @NotNull CsvFormatUISettings settings) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/csv/ui/CsvFormatsSelectionUI", "createDatabaseSettingsBackedForm"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/csv/ui/CsvFormatsSelectionUI", "createDatabaseSettingsBackedForm"));
        }
        CsvFormatsSelectionUI form = new CsvFormatsSelectionUI(parent, new DatabaseSettingsSaveActionSupport(), settings);
        form.reset(DatabaseSettings.getSettings().getCsvFormats(), null);
        CsvFormatsSelectionUI csvFormatsSelectionUI = form;
        if (csvFormatsSelectionUI == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/csv/ui/CsvFormatsSelectionUI", "createDatabaseSettingsBackedForm"));
        }
        return csvFormatsSelectionUI;
    }

    private static class DatabaseSettingsSaveActionSupport
    implements SaveActionSupport {
        private DatabaseSettingsSaveActionSupport() {
        }

        @Override
        public void save(@NotNull CsvFormatsSelectionUI form, @NotNull CsvFormat format) {
            if (form == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "form", "com/intellij/database/csv/ui/CsvFormatsSelectionUI$DatabaseSettingsSaveActionSupport", "save"));
            }
            if (format == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/database/csv/ui/CsvFormatsSelectionUI$DatabaseSettingsSaveActionSupport", "save"));
            }
            DatabaseSettings settings = DatabaseSettings.getSettings();
            ArrayList formats = ContainerUtil.newArrayList(settings.getCsvFormats());
            int idx = CsvFormat.indexOfFormatNamed(formats, format.name);
            if (idx != -1) {
                formats.set(idx, format);
            } else {
                formats.add(format);
            }
            settings.setCsvFormats(formats);
            DatabaseSettings.fireSettingsChanged();
            form.notifySaved(format);
        }
    }

    public static interface SaveActionSupport {
        public void save(@NotNull CsvFormatsSelectionUI var1, @NotNull CsvFormat var2);
    }
}

