/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseModelModernLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicNamespaceOwner;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.remote.jdba.RemoteFacade;
import com.intellij.database.remote.jdbc.RemoteConnection;
import com.intellij.database.util.LoaderContext;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.dbm.common.IntrospectionScopes;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.rmi.RemoteException;
import java.sql.Connection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.core.BaseFacade;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.intermediate.AdaptIntermediateFacade;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateFacade;
import org.jetbrains.dekaf.intermediate.PrimeIntermediateFacade;
import org.jetbrains.dekaf.jdbc.UnknownDatabase;

public class DatabaseModelLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performIntrospection(@NotNull ModelFactory modelFactory, @NotNull LoaderContext context, @NotNull DasModel model, @NotNull Connection connection, @NotNull DBIntrospectionOptions options, @NotNull ProgressIndicator progressIndicator, @NotNull Function<IntrospectionScope, IntrospectionScope> introspectionScopeUpd) {
        if (modelFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelFactory", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (introspectionScopeUpd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "introspectionScopeUpd", "com/intellij/database/dataSource/DatabaseModelLoader", "performIntrospection"));
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            throw new AssertionError((Object)"Introspection should not be run in EDT");
        }
        Rdbms rdbms = (Rdbms)ObjectUtils.chooseNotNull((Object)DataSourceUiUtil.getRdbmsForIntrospection(context.getFamilyId()), (Object)UnknownDatabase.RDBMS);
        boolean forceLegacy = DatabaseModelLoader.whetherForcedLegacy(context);
        PrimeIntermediateFacade remoteFacade = DatabaseModelLoader.getRemoteFacade(connection, rdbms);
        AdaptIntermediateFacade intermediateFacade = null;
        try {
            intermediateFacade = new AdaptIntermediateFacade(remoteFacade);
            BaseFacade facade = new BaseFacade((IntegralIntermediateFacade)intermediateFacade);
            try {
                facade.connect();
                DatabaseModelModernLoader.performModernIntrospection(modelFactory, (DBFacade)facade, context, model, progressIndicator, options, introspectionScopeUpd, forceLegacy);
            }
            catch (Exception e) {
                context.getErrorHandler().addError(e.getMessage(), e);
            }
            finally {
                facade.disconnect();
            }
            DbSrcUtils.refresh();
        }
        finally {
            if (intermediateFacade != null) {
                intermediateFacade.disconnect();
            }
            remoteFacade.disconnect();
        }
    }

    @NotNull
    private static PrimeIntermediateFacade getRemoteFacade(@NotNull Connection connection, Rdbms rdbms) {
        PrimeIntermediateFacade remoteFacade;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dataSource/DatabaseModelLoader", "getRemoteFacade"));
        }
        RemoteConnection remoteConnection = (RemoteConnection)RemoteUtil.castToRemoteNotNull((Object)connection, RemoteConnection.class);
        try {
            RemoteFacade jpdaFacade = remoteConnection.jpdaFacade(rdbms.code);
            remoteFacade = (PrimeIntermediateFacade)RemoteUtil.castToLocal((Object)jpdaFacade, PrimeIntermediateFacade.class);
            assert (remoteFacade.rdbms().code.equals(rdbms.code));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        PrimeIntermediateFacade primeIntermediateFacade = remoteFacade;
        if (primeIntermediateFacade == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelLoader", "getRemoteFacade"));
        }
        return primeIntermediateFacade;
    }

    private static boolean whetherForcedLegacy(@NotNull LoaderContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelLoader", "whetherForcedLegacy"));
        }
        LocalDataSource dataSource = context.getDataSource();
        return dataSource != null && dataSource.useLegacyIntrospector();
    }

    public static boolean schemaMatches(@NotNull DasObject schema, @NotNull IntrospectionScope scope) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/database/dataSource/DatabaseModelLoader", "schemaMatches"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "schemaMatches"));
        }
        DasObject parent = schema.getDbParent();
        String parentName = parent == null ? "*" : parent.getName();
        return scope.containsSchema(parentName, schema.getName());
    }

    public static IntrospectionScope updateIntrospectionScope(@NotNull BasicModel model, @NotNull IntrospectionScope scope, boolean merge) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "updateIntrospectionScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "updateIntrospectionScope"));
        }
        MultiMap pairs = MultiMap.createLinkedSet();
        if (merge) {
            for (String string : scope.databases()) {
                pairs.getModifiable((Object)string).addAll(scope.schemas(string));
            }
        }
        for (BasicSchema basicSchema : model.getRoot().getAllSchemas()) {
            if (!basicSchema.isVisible()) continue;
            BasicNamespaceOwner p = basicSchema.getDbParent();
            if (p != null && p.getKind() != ObjectKind.DATABASE) {
                p = null;
            }
            boolean curDb = p instanceof BasicNamespace && ((BasicNamespace)((Object)p)).isCurrent();
            boolean curSc = basicSchema.isCurrent();
            String dbName = p == null ? "*" : p.getName();
            String scName = basicSchema.getName();
            if (merge && (scope.containsSchema(dbName, scName) || curDb && scope.containsSchema("@", scName) || curSc && scope.containsSchema(dbName, "@") || curDb && curSc && scope.containsSchema("@", "@"))) continue;
            pairs.putValue((Object)dbName, (Object)scName);
        }
        Family<? extends BasicElement> dbs = model.getRoot().familyOf(ObjectKind.DATABASE);
        if (dbs != null) {
            for (BasicNamespace db : dbs.jbi().filter(BasicNamespace.class)) {
                if (!db.isVisible()) continue;
                pairs.getModifiable((Object)db.getName());
            }
        }
        return IntrospectionScopes.scopeOf((MultiMap<String, String>)pairs);
    }

    public static void updateModelVisibility(@NotNull DasModel model, @NotNull IntrospectionScope scope) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dataSource/DatabaseModelLoader", "updateModelVisibility"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/database/dataSource/DatabaseModelLoader", "updateModelVisibility"));
        }
        if (model instanceof BasicModModel) {
            DatabaseModelModernLoader.updateModelVisibility((BasicModModel)model, scope);
        }
    }
}

