/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.coding.CompositeText;
import com.intellij.coding.SimpleCompositeText;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.srcStorage.DbDataSourceLayout;
import com.intellij.database.dataSource.srcStorage.DbSrcFileStatus;
import com.intellij.database.dataSource.srcStorage.DbSrcModificationSession;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.dataSource.srcStorage.PersistentMarkup;
import com.intellij.database.model.ModelTextStorage;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.model.impl.BlackHoleTextStorage;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcModelStorage
implements ModelTextStorage {
    private static final Logger LOG = Logger.getInstance(DbSrcModelStorage.class);
    private final DbDataSourceLayout myLayout;
    @Nullable
    private final Project myProject;
    private volatile DbSrcModificationSession myModSession;

    private DbSrcModelStorage(@Nullable Project project, @NotNull String dataSourceId) {
        if (dataSourceId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "<init>"));
        }
        DbSrcStorage storage = DbSrcStorage.getInstance(project);
        this.myLayout = storage.getLayout(dataSourceId);
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSession(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "writeSession"));
        }
        if (this.myModSession != null) {
            LOG.warn("Parallel modification is forbidden");
        }
        this.myModSession = new DbSrcModificationSession(this.myProject, this.myLayout);
        try {
            runnable.run();
        }
        finally {
            try {
                this.myModSession.waitForWriteFinished();
            }
            finally {
                this.myModSession = null;
            }
        }
    }

    @Nullable
    private DbSrcModificationSession getModSession() {
        LOG.assertTrue(this.myModSession != null, (Object)"Session not started");
        return this.myModSession;
    }

    @Override
    public void save(@NotNull BasicSourceAware object, @Nullable CompositeText text) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "save"));
        }
        DbSrcModificationSession session = this.getModSession();
        if (session != null) {
            session.save(object, text);
        }
    }

    @Override
    public void queueDelete(@NotNull BasicSourceAware object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "queueDelete"));
        }
        DbSrcModificationSession session = this.getModSession();
        if (session != null) {
            session.queueDelete(object);
        }
    }

    @Override
    public void processDeleteQueue() {
        DbSrcModificationSession session = this.myModSession;
        if (session == null) {
            return;
        }
        session.beginWrite();
        session.endWrite();
    }

    @Override
    public void beginWrite() {
        DbSrcModificationSession session = this.getModSession();
        if (session != null) {
            session.beginWrite();
        }
    }

    @Override
    public void endWrite() {
        DbSrcModificationSession session = this.getModSession();
        if (session != null) {
            session.endWrite();
        }
    }

    @Override
    @Nullable
    public CompositeText load(@NotNull BasicSourceAware object) {
        CompositeText src;
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "load"));
        }
        DbSrcModificationSession session = this.myModSession;
        CompositeText compositeText = src = session == null ? null : session.getTmpSource(object);
        if (src != null) {
            return src;
        }
        DbSrcPath srcPath = DbSrcPath.of(object);
        DbSrcStorageLayout.Item item = this.myLayout.getPath(srcPath, false);
        if (item == null) {
            return null;
        }
        String text = DbSrcFileStatus.getContent(item.getSrcFile());
        if (text == null) {
            return null;
        }
        DbSrcStorageDsMetadata.MetaData md = this.myLayout.getMetaData(srcPath);
        boolean noRanges = md == null || md.kinds == null || md.kinds.length == 0;
        return noRanges ? new SimpleCompositeText(text, CompositeText.Kind.ORIGINAL_TEXT) : new PersistentMarkup(text, md.offsets, md.kinds);
    }

    @Override
    public boolean hasExistingSources(@NotNull BasicElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "hasExistingSources"));
        }
        DbSrcPath srcPath = DbSrcPath.of(element);
        DbSrcStorageLayout.Item item = this.myLayout.getPath(srcPath, false);
        if (item == null) {
            return false;
        }
        if (item.hasChildren()) {
            return true;
        }
        if (!(element instanceof BasicSourceAware)) {
            return false;
        }
        return item.getSrcAttributes() != null;
    }

    @Override
    public Long getVersion(@NotNull BasicElement object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "getVersion"));
        }
        DbSrcPath srcPath = DbSrcPath.of(object);
        DbSrcStorageDsMetadata.MetaData data = this.myLayout.getMetaData(srcPath);
        return data == null ? null : data.srcVersion;
    }

    @Override
    public void setVersion(@NotNull BasicElement object, Long version) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "setVersion"));
        }
        DbSrcPath srcPath = DbSrcPath.of(object);
        DbSrcStorageDsMetadata.MetaData data = this.myLayout.getMetaData(srcPath);
        this.myLayout.putMetaData(srcPath, DbSrcStorageDsMetadata.MetaData.modSrcVersion(data, version));
    }

    @NotNull
    public static ModelFactory createFactory(@Nullable Project project, @NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "createFactory"));
        }
        ModelFactory modelFactory = DbSrcModelStorage.createFactory(dataSource.isGlobal() ? null : project, dataSource.getUniqueId());
        if (modelFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "createFactory"));
        }
        return modelFactory;
    }

    @NotNull
    public static ModelFactory createFactory(@Nullable Project project, @Nullable String dataSourceId) {
        ModelFactory modelFactory = new ModelFactory(DbSrcStorage.isEnabled() && dataSourceId != null ? new DbSrcModelStorage(project, dataSourceId) : BlackHoleTextStorage.INSTANCE);
        if (modelFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcModelStorage", "createFactory"));
        }
        return modelFactory;
    }
}

