/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.coding.CompositeText;
import com.intellij.coding.CompositeTextFun;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentMarkup
implements CompositeText {
    private final CharSequence myText;
    private final int[] myOffsets;
    private final char[] myKinds;

    public PersistentMarkup(@NotNull CharSequence text, @NotNull int[] offsets, @NotNull char[] kinds) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/srcStorage/PersistentMarkup", "<init>"));
        }
        if (offsets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offsets", "com/intellij/database/dataSource/srcStorage/PersistentMarkup", "<init>"));
        }
        if (kinds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kinds", "com/intellij/database/dataSource/srcStorage/PersistentMarkup", "<init>"));
        }
        assert (offsets.length == kinds.length);
        this.myText = text;
        this.myOffsets = offsets;
        this.myKinds = kinds;
    }

    @Override
    @NotNull
    public Iterable<CompositeText.Fragment> getFragments() {
        Iterable<CompositeText.Fragment> iterable = () -> new JBIterator<CompositeText.Fragment>(){
            int i = 0;

            protected CompositeText.Fragment nextImpl() {
                return this.i < PersistentMarkup.this.myOffsets.length ? PersistentMarkup.this.createFragment(this.i++) : (CompositeText.Fragment)this.stop();
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/PersistentMarkup", "getFragments"));
        }
        return iterable;
    }

    @Override
    @NotNull
    public CharSequence getText() {
        CharSequence charSequence = this.myText;
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/PersistentMarkup", "getText"));
        }
        return charSequence;
    }

    public String toString() {
        return this.getText().toString();
    }

    @Override
    @Nullable
    public CompositeText.Fragment first(@NotNull CompositeText.Kind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/dataSource/srcStorage/PersistentMarkup", "first"));
        }
        int idx = CharArrayUtil.indexOf((char[])this.myKinds, (char)PersistentMarkup.ord(kind), (int)0, (int)this.myKinds.length);
        return idx < 0 ? null : this.createFragment(idx);
    }

    @Override
    @Nullable
    public CompositeText.Fragment getContent() {
        int idx = CharArrayUtil.indexOf((char[])this.myKinds, (char)PersistentMarkup.ord(CompositeText.Kind.ORIGINAL_TEXT), (int)0, (int)this.myKinds.length);
        if (idx < 0) {
            idx = CharArrayUtil.indexOf((char[])this.myKinds, (char)PersistentMarkup.ord(CompositeText.Kind.DECOMPILED_TEXT), (int)0, (int)this.myKinds.length);
        }
        return idx < 0 ? null : this.createFragment(idx);
    }

    @NotNull
    private CompositeText.Fragment createFragment(final int idx) {
        CompositeText.Fragment fragment = new CompositeText.Fragment(){

            @Override
            @NotNull
            public CharSequence getText() {
                int from = this.getBegin();
                int to = this.getEnd();
                int len = PersistentMarkup.this.myText.length();
                CharSequence charSequence = PersistentMarkup.this.myText.subSequence(Math.min(from, len), Math.min(Math.max(to, from), len));
                if (charSequence == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/PersistentMarkup$2", "getText"));
                }
                return charSequence;
            }

            @Override
            @NotNull
            public CompositeText.Kind getKind() {
                CompositeText.Kind kind = (CompositeText.Kind)((Object)ObjectUtils.chooseNotNull((Object)((Object)CompositeTextFun.FragmentKindsByCodes.get(Character.valueOf(PersistentMarkup.this.myKinds[idx]))), (Object)((Object)CompositeText.Kind.PLAIN_TEXT)));
                if (kind == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/PersistentMarkup$2", "getKind"));
                }
                return kind;
            }

            @Override
            public int getBegin() {
                return idx == 0 ? 0 : PersistentMarkup.this.myOffsets[idx - 1];
            }

            @Override
            public int getEnd() {
                return PersistentMarkup.this.myOffsets[idx];
            }

            @Override
            public int getLength() {
                return this.getEnd() - this.getBegin();
            }
        };
        if (fragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/PersistentMarkup", "createFragment"));
        }
        return fragment;
    }

    @NotNull
    public DbSrcStorageDsMetadata.MetaData getExpectedMetaData(@Nullable DbSrcStorageDsMetadata.MetaData md) {
        if (md == null) {
            md = DbSrcStorageDsMetadata.MetaData.EMPTY;
        }
        DbSrcStorageDsMetadata.MetaData metaData = new DbSrcStorageDsMetadata.MetaData(md.srcVersion, DbSrcUtils.hashCode(this.myText), this.myOffsets, this.myKinds, md.majorContentVersion, md.minorContentVersion);
        if (metaData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/PersistentMarkup", "getExpectedMetaData"));
        }
        return metaData;
    }

    private static char ord(CompositeText.Kind k) {
        return k.getCode();
    }

    public static class Builder {
        private final StringBuilder kinds = new StringBuilder();
        private final TIntArrayList offsets = new TIntArrayList();

        public void add(CompositeText.Kind k, int o) {
            if (o == 0 || !this.offsets.isEmpty() && this.offsets.get(this.offsets.size() - 1) == o) {
                return;
            }
            int sz = this.kinds.length();
            char ord = PersistentMarkup.ord(k);
            if (k == CompositeText.Kind.PLAIN_TEXT && sz > 0 && this.kinds.charAt(sz - 1) == ord) {
                this.offsets.set(sz - 1, o);
            } else {
                this.offsets.add(o);
                this.kinds.append(ord);
            }
        }

        public void add(CompositeText.Kind k, int from, int to) {
            this.add(CompositeText.Kind.PLAIN_TEXT, from);
            this.add(k, to);
        }

        public void clear() {
            this.kinds.setLength(0);
            this.offsets.clear();
        }

        public PersistentMarkup build(CharSequence text) {
            char[] kindsArray = new char[this.kinds.length()];
            this.kinds.getChars(0, this.kinds.length(), kindsArray, 0);
            return new PersistentMarkup(text, this.offsets.toNativeArray(), kindsArray);
        }
    }
}

