/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid.mutating;

import com.intellij.database.datagrid.mutating.RowQueryData;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class QueryData
implements Iterable<RowQueryData> {
    private final List<RowQueryData> myInfos;

    public QueryData(@NotNull List<RowQueryData> infos) {
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/database/datagrid/mutating/QueryData", "<init>"));
        }
        this.myInfos = infos;
    }

    @Override
    public Iterator<RowQueryData> iterator() {
        return this.myInfos.iterator();
    }

    public int size() {
        return this.myInfos.size();
    }

    @NotNull
    public String getFullSql() {
        StringBuilder sb = new StringBuilder();
        this.myInfos.stream().map(RowQueryData::getSql).distinct().forEach(str -> sb.append((String)str).append(";").append(System.lineSeparator()));
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/mutating/QueryData", "getFullSql"));
        }
        return string;
    }
}

