/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ColumnMappingStrategy;
import com.intellij.database.dbimport.ImportEditorState;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.MappingTableColumnEditor;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseTableColumnEditor;
import com.intellij.database.view.editors.DatabaseTableColumnsEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.database.view.ui.TableEditorToolbarsDecorator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.containers.JBIterable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportColumnEditor<T extends ColumnDescriptor>
extends DatabaseTableColumnsEditor {
    public ImportColumnEditor(@NotNull ImportDatabaseTableEditor<T> tableEditor, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps, @NotNull TableEditorToolbarsDecorator decorator) {
        if (tableEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableEditor", "com/intellij/database/dbimport/ui/ImportColumnEditor", "<init>"));
        }
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/dbimport/ui/ImportColumnEditor", "<init>"));
        }
        if (decorator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decorator", "com/intellij/database/dbimport/ui/ImportColumnEditor", "<init>"));
        }
        super(tableEditor, caps, decorator);
    }

    @Override
    @NotNull
    protected DatabaseTableColumnEditor createColumnEditor(@NotNull DeColumn column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ui/ImportColumnEditor", "createColumnEditor"));
        }
        TableEditorModel model = this.getTableModel();
        ColumnEditorModel columnModel = model.modelsCache.get(column, ColumnEditorModel.class);
        DatabaseEditorCapabilities.TableColumnEditorCaps caps = this.getTableColumnCaps(column);
        List descriptors = ContainerUtil.filter(this.getState().getDescriptors(), (Condition)Conditions.not(this::isBusy));
        Object descriptor = ColumnMappingStrategy.map(column, descriptors);
        MappingTableColumnEditor<T> mappingTableColumnEditor = this.subscribeAndRegister(new MappingTableColumnEditor<T>(this.getState(), model, columnModel, caps, this, descriptor));
        if (mappingTableColumnEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportColumnEditor", "createColumnEditor"));
        }
        return mappingTableColumnEditor;
    }

    @NotNull
    public LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> getMapping() {
        LinkedHashMap map = ContainerUtilRt.newLinkedHashMap();
        List items = this.myColumnModel.getItems();
        for (DatabaseTableColumnEditor item : items) {
            MappingTableColumnEditor editor = (MappingTableColumnEditor)item;
            Object descriptor = editor.getDescriptor();
            DeColumn column = editor.getColumn();
            map.put(ImportUtil.createDescriptor(column, descriptor != null), descriptor);
        }
        LinkedHashMap linkedHashMap = map;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportColumnEditor", "getMapping"));
        }
        return linkedHashMap;
    }

    void createInitialMapping() {
        JBIterable items = JBIterable.from((Iterable)this.myColumnModel.getItems()).map(item -> (MappingTableColumnEditor)item);
        items.forEach(item -> item.setDescriptor(null));
        List columns = items.map(item -> item.getColumn()).toList();
        Map map = ColumnMappingStrategy.map(columns, this.getState().getDescriptors());
        items.forEach(item -> item.setDescriptor((ColumnDescriptor)map.get(item.getColumn())));
    }

    @NotNull
    private ImportEditorState<T> getState() {
        ImportEditorState importEditorState = (ImportEditorState)this.myTableEditor.getState();
        if (importEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/ImportColumnEditor", "getState"));
        }
        return importEditorState;
    }

    private boolean isBusy(@Nullable ColumnDescriptor descriptor) {
        return descriptor != null && ContainerUtil.exists((Iterable)this.myColumnModel.getItems(), item -> ((MappingTableColumnEditor)item).getDescriptor() == descriptor);
    }
}

