/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui;

import com.google.common.collect.Iterables;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportEditorState;
import com.intellij.database.dbimport.ui.ImportColumnEditor;
import com.intellij.database.dbimport.ui.MappingColumnEditor;
import com.intellij.database.view.editors.DatabaseColumnEditor;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.editors.DatabaseEditorUtil;
import com.intellij.database.view.editors.DatabaseTableColumnEditor;
import com.intellij.database.view.models.ColumnEditorModel;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappingTableColumnEditor<T extends ColumnDescriptor>
extends DatabaseTableColumnEditor {
    public MappingTableColumnEditor(@NotNull ImportEditorState<T> state, @NotNull TableEditorModel tableModel, @NotNull ColumnEditorModel columnModel, @NotNull DatabaseEditorCapabilities.TableColumnEditorCaps columnCaps, @NotNull ImportColumnEditor<T> importColumnEditor, @Nullable T descriptor) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ui/MappingTableColumnEditor", "<init>"));
        }
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/database/dbimport/ui/MappingTableColumnEditor", "<init>"));
        }
        if (columnModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnModel", "com/intellij/database/dbimport/ui/MappingTableColumnEditor", "<init>"));
        }
        if (columnCaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnCaps", "com/intellij/database/dbimport/ui/MappingTableColumnEditor", "<init>"));
        }
        if (importColumnEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importColumnEditor", "com/intellij/database/dbimport/ui/MappingTableColumnEditor", "<init>"));
        }
        super(state, tableModel, columnModel, columnCaps, importColumnEditor);
        this.setDescriptor(descriptor);
    }

    @Override
    @NotNull
    protected DatabaseColumnEditor createEditor(@NotNull DatabaseEditorState state, @NotNull ColumnEditorModel columnModel, @NotNull DatabaseEditorCapabilities.TableColumnEditorCaps columnCaps) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/dbimport/ui/MappingTableColumnEditor", "createEditor"));
        }
        if (columnModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnModel", "com/intellij/database/dbimport/ui/MappingTableColumnEditor", "createEditor"));
        }
        if (columnCaps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columnCaps", "com/intellij/database/dbimport/ui/MappingTableColumnEditor", "createEditor"));
        }
        MappingColumnEditor mappingColumnEditor = new MappingColumnEditor(this.getState(), columnModel, (DatabaseEditorCapabilities.ColumnEditorCaps)columnCaps);
        if (mappingColumnEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/MappingTableColumnEditor", "createEditor"));
        }
        return mappingColumnEditor;
    }

    @Override
    public ImportEditorState<T> getState() {
        return (ImportEditorState)super.getState();
    }

    @Override
    @NotNull
    public Iterable<Pair<String, TextAttributesKey>> getRowText() {
        if (this.myColumnsEditor.getActiveEditor() != null && this.myCachedText != null) {
            Iterable iterable = this.myCachedText;
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/MappingTableColumnEditor", "getRowText"));
            }
            return iterable;
        }
        Iterable<Pair<String, TextAttributesKey>> text = super.getRowText();
        DatabaseColumnEditor editor = this.getColumnEditor();
        Object descriptor = ((MappingColumnEditor)editor).getDescriptor();
        if (descriptor == null) {
            Iterable<Pair<String, TextAttributesKey>> iterable = text;
            if (iterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/MappingTableColumnEditor", "getRowText"));
            }
            return iterable;
        }
        DatabaseEditorUtil.ColoredFragmentsBuilder builder = new DatabaseEditorUtil.ColoredFragmentsBuilder();
        int length = DatabaseEditorUtil.computeLength(text);
        int maxLength = this.myColumnsEditor.getMaxLength((Function<DatabaseTableColumnEditor, Iterable<Pair<String, TextAttributesKey>>>)((Function)DatabaseTableColumnEditor::getColumnDefinition));
        DatabaseEditorUtil.padText(builder, maxLength, length);
        builder.append(String.format("mapped to %s", descriptor.getName()), DefaultLanguageHighlighterColors.LINE_COMMENT);
        this.myCachedText = Iterables.concat(text, builder.build());
        if (this.myCachedText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/MappingTableColumnEditor", "getRowText"));
        }
        return this.myCachedText;
    }

    @Override
    public MappingColumnEditor<T> getColumnEditor() {
        return (MappingColumnEditor)super.getColumnEditor();
    }

    public void setDescriptor(@Nullable T descriptor) {
        DatabaseColumnEditor editor = this.getColumnEditor();
        ((MappingColumnEditor)editor).setDescriptor(descriptor);
    }

    @Nullable
    public T getDescriptor() {
        return ((MappingColumnEditor)this.getColumnEditor()).getDescriptor();
    }
}

