/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.component;

import com.intellij.database.actions.ImportAction;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.ImportColumnEditor;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TableEditorComponent<T>
implements ImportComponent<T, ImportDatabaseTableEditor<?>> {
    private static final String MAPPING_ERROR = "Columns are not mapped";
    private static final String EMPTY_TABLE = "Table is empty";
    private static final String EMPTY_NAME = "Name of the table is empty";
    private static final String TABLE_EXISTS = "Table with this name already exists";
    protected final ImportAction.ImportEditorContext myContext;
    private final JPanel myPanel;
    private ImportDatabaseTableEditor<?> myEditor;
    private EditorModelBase.Listener myPreviewUpdater;

    public TableEditorComponent(@NotNull ImportAction.ImportEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/component/TableEditorComponent", "<init>"));
        }
        this.myContext = context;
        this.myPanel = new JPanel(new BorderLayout());
    }

    @Nullable
    public ImportDatabaseTableEditor<?> getEditor() {
        return this.myEditor;
    }

    @NotNull
    protected final ImportDatabaseTableEditor<?> createEditor(@NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows) {
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/database/dbimport/ui/component/TableEditorComponent", "createEditor"));
        }
        String tableName = this.getTableName();
        String tableComment = this.getComment();
        DeTable table = this.myContext.getBuilder().getImportType().createTable(this.myContext, descriptors, rows);
        table.name = tableName;
        table.comment = (String)ObjectUtils.chooseNotNull((Object)tableComment, (Object)table.comment);
        ImportDatabaseTableEditor<?> editor = ImportUtil.createEditor(table, descriptors, this.myContext);
        if (this.myPreviewUpdater != null) {
            editor.addListener(this.myPreviewUpdater, editor);
        }
        ImportDatabaseTableEditor<?> importDatabaseTableEditor = editor;
        if (importDatabaseTableEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/component/TableEditorComponent", "createEditor"));
        }
        return importDatabaseTableEditor;
    }

    protected final void setEditor(@NotNull ImportDatabaseTableEditor<?> editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/dbimport/ui/component/TableEditorComponent", "setEditor"));
        }
        this.myEditor = editor;
        this.myPanel.removeAll();
        this.myPanel.add((Component)this.myEditor.getComponent(), "Center");
    }

    @Nullable
    private String getComment() {
        return this.myEditor != null ? this.myEditor.getTable().comment : (this.myContext.getBuilder().getImportType().isTableCreated() ? this.myContext.getElement().getComment() : null);
    }

    @NotNull
    private String getTableName() {
        String string = this.myEditor == null ? this.myContext.getTableName() : this.myEditor.getTable().name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/component/TableEditorComponent", "getTableName"));
        }
        return string;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/component/TableEditorComponent", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void addListener(final @NotNull GraphObservable.ObserverListener<?> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/ui/component/TableEditorComponent", "addListener"));
        }
        this.myPreviewUpdater = new EditorModelBase.Listener(){

            @Override
            public void changed() {
                listener.changed(TableEditorComponent.this, TableEditorComponent.this.myEditor);
            }
        };
        if (this.myEditor != null) {
            this.myEditor.addListener(this.myPreviewUpdater, this.myEditor);
        }
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/component/TableEditorComponent", "build"));
        }
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> mapping = ((ImportColumnEditor)this.myEditor.getColumnsEditor()).getMapping();
        builder.mapping(mapping).consumer(this.myEditor.getTable()).consumers(ContainerUtil.newArrayList(mapping.keySet()));
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/component/TableEditorComponent", "isVisible"));
        }
        return builder.getMapping() == null || builder.getTable() == null;
    }

    @Override
    @Nullable
    public ValidationInfo validate() {
        if (this.myEditor == null) {
            return null;
        }
        JComponent editorComponent = this.myEditor.getPreferredFocusedComponent();
        TableEditorModel model = this.myEditor.getTableModel();
        if (model.getName().isEmpty()) {
            return new ValidationInfo(EMPTY_NAME, editorComponent);
        }
        if (this.myContext.isTableExists(this.myEditor.getTable().name)) {
            return new ValidationInfo(TABLE_EXISTS, editorComponent);
        }
        JComponent columnEditorComponent = this.myEditor.getColumnsEditor().getComponent();
        if (model.getColumnsCount() == 0) {
            return new ValidationInfo(EMPTY_TABLE, columnEditorComponent);
        }
        return this.checkMapping() ? null : new ValidationInfo(MAPPING_ERROR, columnEditorComponent);
    }

    private boolean checkMapping() {
        LinkedHashMap<AutoValueDescriptor, ColumnDescriptor> mapping = this.myEditor == null ? null : ((ImportColumnEditor)this.myEditor.getColumnsEditor()).getMapping();
        return mapping == null || !this.myContext.getBuilder().getImportType().isTableCreated() || ContainerUtil.exists(mapping.values(), (Condition)Condition.NOT_NULL);
    }
}

