/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.csv;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.csv.CsvPreviewModel;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.ImportComponent;
import com.intellij.database.dbimport.ui.csv.CsvPreviewComponent;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharsetComponent
implements ImportComponent<Object, CsvPreviewComponent.CharsetInfo> {
    private static final String ENCODING = "Encoding: ";
    private final ComboBox<Charset> myBox;
    private final JPanel myPanel;
    private final CsvPreviewModel myModel;

    public CharsetComponent(@NotNull CsvPreviewModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dbimport/ui/csv/CharsetComponent", "<init>"));
        }
        this.myModel = model;
        this.myBox = new ComboBox((Object[])CharsetToolkit.getAvailableCharsets());
        this.myBox.setSelectedItem((Object)model.getCharset());
        this.myPanel = this.createPanel();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CharsetComponent", "getComponent"));
        }
        return jPanel;
    }

    @Override
    public void build(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/csv/CharsetComponent", "build"));
        }
        this.myModel.acceptCharset();
    }

    @Override
    public boolean isVisible(@NotNull ImportInfo.Builder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dbimport/ui/csv/CharsetComponent", "isVisible"));
        }
        return true;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener<?> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/ui/csv/CharsetComponent", "addListener"));
        }
        this.myBox.addActionListener(e -> {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/ui/csv/CharsetComponent", "lambda$addListener$0"));
            }
            listener.changed(this, this.getCharsetInfo());
        });
    }

    @Override
    @NotNull
    public CompletionStage<CsvPreviewComponent.CharsetInfo> notifyChanged(@Nullable Object object) {
        CompletableFuture<CsvPreviewComponent.CharsetInfo> completableFuture = CompletableFuture.completedFuture(this.getCharsetInfo());
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CharsetComponent", "notifyChanged"));
        }
        return completableFuture;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/database/dbimport/ui/csv/CharsetComponent", "dependsOn"));
        }
        return observer instanceof CsvPreviewComponent;
    }

    @NotNull
    private CsvPreviewComponent.CharsetInfo getCharsetInfo() {
        CsvPreviewComponent.CharsetInfo charsetInfo = new CsvPreviewComponent.CharsetInfo((Charset)this.myBox.getSelectedItem());
        if (charsetInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CharsetComponent", "getCharsetInfo"));
        }
        return charsetInfo;
    }

    @NotNull
    private JPanel createPanel() {
        JPanel encodingPanel = new JPanel((LayoutManager)new HorizontalLayout(0));
        encodingPanel.add((Component)new JBLabel(ENCODING));
        encodingPanel.add((Component)this.myBox);
        JPanel jPanel = encodingPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/csv/CharsetComponent", "createPanel"));
        }
        return jPanel;
    }
}

