/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.database;

import com.intellij.database.SimpleRequestBroker;
import com.intellij.database.actions.ImportAction;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.dbimport.graph.GraphObservable;
import com.intellij.database.dbimport.ui.component.DataPreviewComponent;
import com.intellij.database.dbimport.ui.database.DatabaseTableEditorComponent;
import com.intellij.database.run.ui.DataGridRequestSource;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ObjectUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDataPreviewComponent
extends DataPreviewComponent<Object> {
    private static final int PAGE_SIZE = 500;
    private final ImportAction.ImportEditorContext myContext;
    private final LocalDataSource myProducerDataSource;
    private final String myQueryText;

    public DatabaseDataPreviewComponent(@NotNull ImportAction.ImportEditorContext context, @NotNull LocalDataSource producerDataSource, @NotNull String queryText) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent", "<init>"));
        }
        if (producerDataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "producerDataSource", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent", "<init>"));
        }
        if (queryText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryText", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent", "<init>"));
        }
        super(context.getBuilder());
        this.myContext = context;
        this.myProducerDataSource = producerDataSource;
        this.myQueryText = queryText;
    }

    @Override
    public void addListener(@NotNull GraphObservable.ObserverListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent", "addListener"));
        }
    }

    @Override
    @NotNull
    public CompletionStage<DataGrid> notifyChanged(@Nullable Object object) {
        if (this.getGrid() != null) {
            CompletableFuture<DataGrid> completableFuture = CompletableFuture.completedFuture(this.getGrid());
            if (completableFuture == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent", "notifyChanged"));
            }
            return completableFuture;
        }
        CompletableFuture<DataGrid> future = new CompletableFuture<DataGrid>();
        Project project = this.myContext.getProject();
        GridDataHookUpManager instance = GridDataHookUpManager.getInstance((Project)ObjectUtils.assertNotNull((Object)project));
        SimpleRequestBroker broker = SimpleRequestBroker.newInstance((Project)ObjectUtils.assertNotNull((Object)project), "Import preview");
        Disposable disposable = this.myContext.getDisposable();
        DatabaseGridDataHookUp hookUp = instance.createReadOnlyDatabaseHookUp(broker, disposable, this.myQueryText);
        JdbcEngine engine = new JdbcEngine((Project)ObjectUtils.assertNotNull((Object)project), broker, this.myProducerDataSource, null);
        Disposer.register((Disposable)disposable, (Disposable)engine);
        DataGrid grid = DataGridUtil.createPreviewDataGrid((Project)ObjectUtils.assertNotNull((Object)project), hookUp);
        Disposer.register((Disposable)disposable, (Disposable)grid);
        DataGridRequestSource source = new DataGridRequestSource(grid);
        hookUp.addRequestListener(new MyRequestListener(future, disposable, grid), disposable);
        hookUp.getPageModel().setPageSize(500);
        hookUp.getLoader().loadFirstPage(GridRequestSource.create(grid, (Object)source));
        this.setGrid(grid);
        CompletableFuture<DataGrid> completableFuture = future;
        if (completableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent", "notifyChanged"));
        }
        return completableFuture;
    }

    @Override
    public boolean dependsOn(@NotNull GraphObservable.GraphObserver<?, ?> observer) {
        if (observer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observer", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent", "dependsOn"));
        }
        return observer instanceof DatabaseTableEditorComponent;
    }

    private static class MyRequestListener
    implements GridDataHookUp.RequestListener<DataConsumer.Row, DataConsumer.Column> {
        private final CompletableFuture<DataGrid> myFuture;
        private final Disposable myDisposable;
        private final DataGrid myGrid;

        private MyRequestListener(@NotNull CompletableFuture<DataGrid> future, @NotNull Disposable disposable, @NotNull DataGrid grid) {
            if (future == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent$MyRequestListener", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent$MyRequestListener", "<init>"));
            }
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent$MyRequestListener", "<init>"));
            }
            this.myFuture = future;
            this.myDisposable = disposable;
            this.myGrid = grid;
        }

        @Override
        public void error(@NotNull GridRequestSource source, @Nullable String message, @Nullable Throwable th) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent$MyRequestListener", "error"));
            }
            this.complete();
        }

        @Override
        public void requestFinished(@NotNull GridRequestSource source, boolean success) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent$MyRequestListener", "requestFinished"));
            }
            this.complete();
        }

        private void complete() {
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!Disposer.isDisposed((Disposable)this.myDisposable)) {
                    this.myFuture.complete(this.myGrid);
                }
            }, ModalityState.current());
        }

        @Override
        public void updateCountReceived(@NotNull GridRequestSource source, int updateCount) {
            if (source == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/database/dbimport/ui/database/DatabaseDataPreviewComponent$MyRequestListener", "updateCountReceived"));
            }
        }
    }
}

