/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.ui.tree;

import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dbimport.ui.tree.DatabaseChooseByNamePanel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.ide.util.gotoByName.ChooseByNamePanel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTargetChooser
extends JPanel
implements Disposable {
    private final ChooseByNamePanel myPanel;

    public ImportTargetChooser(@NotNull Project project, @NotNull Consumer<Object> selectionListener, @Nullable DbElement producer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/dbimport/ui/tree/ImportTargetChooser", "<init>"));
        }
        if (selectionListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionListener", "com/intellij/database/dbimport/ui/tree/ImportTargetChooser", "<init>"));
        }
        super(new BorderLayout());
        this.myPanel = new MyPanel(project, (Consumer<JPanel>)((Consumer)c -> this.add((Component)c, "Center")), selectionListener, producer, "", false, null);
        Disposer.register((Disposable)this, (Disposable)this.myPanel);
        this.setPreferredSize((Dimension)JBUI.size((int)500, (int)300));
    }

    @NotNull
    public ChooseByNamePanel getChoseByNamePanel() {
        ChooseByNamePanel chooseByNamePanel = this.myPanel;
        if (chooseByNamePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/tree/ImportTargetChooser", "getChoseByNamePanel"));
        }
        return chooseByNamePanel;
    }

    public void dispose() {
    }

    private static class MyPanel
    extends DatabaseChooseByNamePanel {
        private final Consumer<JPanel> myConsumer;

        public MyPanel(Project project, @NotNull Consumer<JPanel> consumer, @NotNull Consumer<Object> selectionListener, @Nullable DbElement producer, String initialText, boolean isCheckboxVisible, PsiElement context) {
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dbimport/ui/tree/ImportTargetChooser$MyPanel", "<init>"));
            }
            if (selectionListener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionListener", "com/intellij/database/dbimport/ui/tree/ImportTargetChooser$MyPanel", "<init>"));
            }
            super(project, new DatabaseChooseByNamePanel.DatabaseChooseByNameModel(project, new MyContributor(producer)), initialText, isCheckboxVisible, context);
            this.myConsumer = consumer;
            this.myList.addListSelectionListener(e -> {
                if (selectionListener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selectionListener", "com/intellij/database/dbimport/ui/tree/ImportTargetChooser$MyPanel", "lambda$new$0"));
                }
                selectionListener.consume(this.getChosenElement());
            });
        }

        protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
            super.initUI(callback, modalityState, allowMultipleSelection);
            this.myConsumer.consume((Object)this.getPanel());
        }

        protected void close(boolean isOk) {
            if (isOk) {
                this.myActionListener.elementChosen(this.getChosenElement());
            }
        }

        protected void showTextFieldPanel() {
        }
    }

    private static class MyContributor
    extends DatabaseChooseByNamePanel.DatabaseChooseByNameContributor {
        private final DbElement myElement;

        private MyContributor(@Nullable DbElement element) {
            super(ObjectKind.TABLE, ObjectKind.SCHEMA, ObjectKind.DATABASE, ObjectKind.NONE);
            this.myElement = element;
        }

        @Override
        @NotNull
        protected JBTreeTraverser<DasObject> traverser(Project project) {
            JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)super.traverser(project).filter(object -> object != this.myElement && ImportUtil.canBeConsumer((DbElement)object));
            if (jBTreeTraverser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dbimport/ui/tree/ImportTargetChooser$MyContributor", "traverser"));
            }
            return jBTreeTraverser;
        }
    }
}

