/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.introspection;

import com.intellij.database.introspection.BaseIntrospector;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.basic.BasicModSingleDatabaseRoot;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.basic.BasicSingleDatabaseRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\b\b\u0002\u0010\u0005*\u00020\u0006*\b\b\u0003\u0010\u0007*\u00020\b2\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00070\tB9\b\u0014\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00030\r\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0014J!\u0010\u0018\u001a\u00020\u00122\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001a\"\u00020\u001bH\u0016\u00a2\u0006\u0002\u0010\u001cJ\u001e\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00020\u001fH$J\b\u0010 \u001a\u00020\u0012H&\u00a8\u0006!"}, d2={"Lcom/intellij/database/introspection/BaseSingleDatabaseIntrospector;", "MM", "Lcom/intellij/database/model/basic/BasicModModel;", "MR", "Lcom/intellij/database/model/basic/BasicModSingleDatabaseRoot;", "S", "Lcom/intellij/database/model/basic/BasicSchema;", "MS", "Lcom/intellij/database/model/basic/BasicModSchema;", "Lcom/intellij/database/introspection/BaseIntrospector;", "facade", "Lorg/jetbrains/dekaf/core/DBFacade;", "modModelClass", "Ljava/lang/Class;", "modRootClass", "modSchemaClass", "(Lorg/jetbrains/dekaf/core/DBFacade;Ljava/lang/Class;Ljava/lang/Class;Ljava/lang/Class;)V", "introspectAutoInTran", "", "tran", "Lorg/jetbrains/dekaf/core/DBTransaction;", "namespaces", "", "Lcom/intellij/database/model/basic/BasicNamespace;", "introspectDatabaseSchemas", "databases", "", "Lcom/intellij/database/model/basic/BasicDatabase;", "([Lcom/intellij/database/model/basic/BasicDatabase;)V", "introspectSchemasAuto", "schemas", "", "retrieveAndApplySchemas", "database-introspection"})
public abstract class BaseSingleDatabaseIntrospector<MM extends BasicModModel, MR extends BasicModSingleDatabaseRoot, S extends BasicSchema, MS extends BasicModSchema>
extends BaseIntrospector<MM, MR, S, MS> {
    @Override
    public void introspectDatabaseSchemas(BasicDatabase ... databases) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)databases, (String)"databases");
        boolean bl2 = this.getInitialized();
        if (_Assertions.ENABLED && !bl2) {
            String string = "Introspector is not initialized yet.";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object[] objectArray = databases;
        boolean bl3 = bl = objectArray.length == 0 || ((Object[])databases).length == 1 && Intrinsics.areEqual((Object)databases[0], (Object)this.getModel().getRoot());
        if (_Assertions.ENABLED && !bl) {
            String string = "Invalid or alien databases.";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.retrieveAndApplySchemas();
    }

    public abstract void retrieveAndApplySchemas();

    @Override
    protected void introspectAutoInTran(@NotNull DBTransaction tran, @Nullable Collection<? extends BasicNamespace> namespaces) {
        Intrinsics.checkParameterIsNotNull((Object)tran, (String)"tran");
        ArrayList<BasicSchema> schemas2 = new ArrayList<BasicSchema>();
        BasicRoot basicRoot = this.getModel().getRoot();
        if (basicRoot == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicSingleDatabaseRoot");
        }
        BasicSingleDatabaseRoot root2 = (BasicSingleDatabaseRoot)basicRoot;
        if (namespaces == null || namespaces.size() == 0) {
            this.introspectNamespacesInTran(tran);
            this.introspectSessionState(tran);
            for (BasicSchema basicSchema : root2.getSchemas()) {
                if (!basicSchema.isVisible()) continue;
                BasicSchema basicSchema2 = basicSchema;
                if (basicSchema2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type S");
                }
                schemas2.add(basicSchema2);
            }
        } else {
            for (BasicNamespace basicNamespace : namespaces) {
                BasicSchema schema;
                boolean bl;
                boolean bl2 = bl = basicNamespace.getModel() == this.getModel();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl = basicNamespace instanceof BasicSchema;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                BasicNamespace basicNamespace2 = basicNamespace;
                if (basicNamespace2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.database.model.basic.BasicSchema");
                }
                BasicSchema basicSchema = schema = (BasicSchema)basicNamespace2;
                if (basicSchema == null) {
                    throw new TypeCastException("null cannot be cast to non-null type S");
                }
                schemas2.add(basicSchema);
            }
        }
        if (!schemas2.isEmpty()) {
            this.introspectSchemasAuto(tran, (List)schemas2);
        }
        this.postIntrospectionProcess();
    }

    protected abstract void introspectSchemasAuto(@NotNull DBTransaction var1, @NotNull List<? extends S> var2);

    protected BaseSingleDatabaseIntrospector(@NotNull DBFacade facade, @NotNull Class<MM> modModelClass, @NotNull Class<MR> modRootClass, @NotNull Class<MS> modSchemaClass) {
        Intrinsics.checkParameterIsNotNull((Object)facade, (String)"facade");
        Intrinsics.checkParameterIsNotNull(modModelClass, (String)"modModelClass");
        Intrinsics.checkParameterIsNotNull(modRootClass, (String)"modRootClass");
        Intrinsics.checkParameterIsNotNull(modSchemaClass, (String)"modSchemaClass");
        super(facade, modModelClass, modRootClass, modSchemaClass);
    }
}

