/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.basic.BasicColumniation;
import com.intellij.database.model.basic.BasicLikeTable;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.util.DasUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicIndex
extends BasicColumniation,
BasicNamedElement,
DasIndex {
    public static final char EXP_MARK = '\u001b';

    @Override
    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getColNames"));
        }
        return list;
    }

    @NotNull
    default public Set<String> getReverseColNames() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getReverseColNames"));
        }
        return set;
    }

    @Nullable
    default public String getCondition() {
        return null;
    }

    default public boolean isUnique() {
        return false;
    }

    default public boolean isFunctionBased() {
        return false;
    }

    @Override
    @NotNull
    default public String calculateDisplayOrder() {
        char c1 = this.isUnique() ? (char)'I' : 'U';
        String string = c1 + BasicColumniation.calculateDisplayOrderByColumns(this);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "calculateDisplayOrder"));
        }
        return string;
    }

    @Deprecated
    default public MultiRef<? extends DasTypedObject> getColumnsRef() {
        return DasUtil.asRef(this.getColNames(), (Function)Functions.id(), name -> {
            BasicLikeTable table = this.getTable();
            if (table == null) {
                return null;
            }
            return table.getColumns().get((String)name);
        });
    }

    @NotNull
    default public DasIndex.Sorting getColumnSorting(@NotNull DasTypedObject column) {
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/model/basic/BasicIndex", "getColumnSorting"));
        }
        String name = column.getName();
        if (name == null || name.isEmpty()) {
            DasIndex.Sorting sorting = DasIndex.Sorting.NONE;
            if (sorting == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getColumnSorting"));
            }
            return sorting;
        }
        if (this.getReverseColNames().contains(name)) {
            DasIndex.Sorting sorting = DasIndex.Sorting.DESCENDING;
            if (sorting == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getColumnSorting"));
            }
            return sorting;
        }
        if (this.getColNames().contains(name)) {
            DasIndex.Sorting sorting = DasIndex.Sorting.ASCENDING;
            if (sorting == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getColumnSorting"));
            }
            return sorting;
        }
        DasIndex.Sorting sorting = DasIndex.Sorting.NONE;
        if (sorting == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicIndex", "getColumnSorting"));
        }
        return sorting;
    }
}

