/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.generic;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMultiDatabaseRoot;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.generic.GenericModDatabase;
import com.intellij.database.model.generic.GenericRoot;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.util.Casing;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface GenericModRoot
extends GenericRoot,
BasicModMultiDatabaseRoot {
    @Override
    @NotNull
    public ModNamingFamily<? extends GenericModDatabase> getDatabases();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<NamingFamily> list = Collections.singletonList(this.getDatabases());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericModRoot", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getDatabases());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/generic/GenericModRoot", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setDefaultCasing(@NotNull Casing var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/generic/GenericModRoot", "importProperties"));
        }
        String defaultCasing = properties.get("DefaultCasing");
        if (defaultCasing != null) {
            this.setDefaultCasing(PropertyConverter.importCasing(defaultCasing));
        }
    }
}

