/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.impl;

import com.intellij.database.model.ClusterType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicCheck;
import com.intellij.database.model.basic.BasicColumn;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicForeignKey;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicMajorObject;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicSequence;
import com.intellij.database.model.basic.BasicSynonym;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.basic.BasicTrigger;
import com.intellij.database.model.basic.BasicTypedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.impl.ModelDescribing$WhenMappings;
import com.intellij.database.model.mssql.MsAliasType;
import com.intellij.database.model.oracle.OraCluster;
import com.intellij.database.model.oracle.OraClusterColumn;
import com.intellij.database.model.oracle.OraTable;
import com.intellij.database.model.postgres.PostgresDefType;
import com.intellij.database.model.postgres.PostgresDefTypeCheck;
import com.intellij.database.model.postgres.PostgresModelFun;
import com.intellij.database.model.postgres.PostgresOperator;
import com.intellij.database.model.postgres.PostgresSequence;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.postgres.PostgresTableColumn;
import com.intellij.database.model.postgres.PostgresTrigger;
import com.intellij.database.model.properties.CascadeRule;
import com.intellij.database.model.properties.PostgresDataTypeSubCategory;
import com.intellij.database.model.properties.PostgresDataTypeSubKind;
import com.intellij.database.model.properties.TableOrganization;
import com.intellij.database.model.properties.TrigEvent;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.Postgres;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000\u00f2\u0001\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u001fH\u0002\u001a\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u0010\u0010#\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020$H\u0002\u001a\u000e\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020'\u001a\u0010\u0010(\u001a\u00020\u00032\u0006\u0010)\u001a\u00020*H\u0002\u001a\u0010\u0010+\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020,H\u0002\u001a\u0010\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/H\u0002\u001a\u0010\u00100\u001a\u00020\u00032\u0006\u00101\u001a\u000202H\u0002\u001a\u0010\u00103\u001a\u00020\u00032\u0006\u0010&\u001a\u000204H\u0002\u001a\u0010\u00105\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u000206H\u0002\u001a\u0010\u00107\u001a\u00020\u00032\u0006\u00108\u001a\u000209H\u0002\u001a\u0010\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020<H\u0002\u001a\u000e\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020?\u001a\u0010\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020BH\u0002\u001a\u000e\u0010C\u001a\u00020\u00032\u0006\u0010&\u001a\u00020D\u001a \u0010E\u001a\u00020F2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u0003H\u0002\u001a\u0010\u0010J\u001a\u00020\u00032\u0006\u00108\u001a\u00020KH\u0002\u001a\u0010\u0010L\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020MH\u0002\u001a \u0010N\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00030PH\u0002\u001a \u0010Q\u001a\u0004\u0018\u00010\u0003*\u0004\u0018\u00010\u00032\u0006\u0010R\u001a\u00020\u00032\u0006\u0010S\u001a\u00020\u0003H\u0002\u001a\u0010\u0010T\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020V0U\u001a\u001a\u0010T\u001a\u00020F*\b\u0012\u0004\u0012\u00020V0U2\u0006\u0010G\u001a\u00020HH\u0002\u001a\n\u0010W\u001a\u00020\u0003*\u00020V\u001a\u0014\u0010W\u001a\u00020F*\u00020V2\u0006\u0010G\u001a\u00020HH\u0002\u001a\n\u0010X\u001a\u00020\u0003*\u00020\t\u001a\n\u0010Y\u001a\u00020\u0003*\u00020\t\u001a\u001a\u0010Z\u001a\u0004\u0018\u00010\u0003*\u0004\u0018\u00010\u00032\b\u0010[\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u0016\u0010\\\u001a\u00020\u0003*\u0004\u0018\u00010\u00032\u0006\u0010[\u001a\u00020\u0003H\u0002\u001a\u0016\u0010]\u001a\f0\u0003\u00a2\u0006\u0002\b^\u00a2\u0006\u0002\b^*\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006_"}, d2={"eoln", "", "indentStep", "", "cascadeRuleIsMeaningful", "", "rule", "Lcom/intellij/database/model/properties/CascadeRule;", "e", "Lcom/intellij/database/model/basic/BasicElement;", "describeArgument", "a", "Lcom/intellij/database/model/basic/BasicArgument;", "describeBasicElement", "describeCheck", "check", "Lcom/intellij/database/model/basic/BasicCheck;", "describeColumn", "column", "Lcom/intellij/database/model/basic/BasicColumn;", "describeForeignKey", "fk", "Lcom/intellij/database/model/basic/BasicForeignKey;", "describeIndex", "index", "Lcom/intellij/database/model/basic/BasicIndex;", "describeIndexingItems", "describeKey", "key", "Lcom/intellij/database/model/basic/BasicKey;", "describeMsAliasType", "Lcom/intellij/database/model/mssql/MsAliasType;", "describeOraCluster", "cluster", "Lcom/intellij/database/model/oracle/OraCluster;", "describeOraClusterColumn", "Lcom/intellij/database/model/oracle/OraClusterColumn;", "describeOraTable", "table", "Lcom/intellij/database/model/oracle/OraTable;", "describePostgresDefType", "dt", "Lcom/intellij/database/model/postgres/PostgresDefType;", "describePostgresDefTypeCheck", "Lcom/intellij/database/model/postgres/PostgresDefTypeCheck;", "describePostgresOperator", "op", "Lcom/intellij/database/model/postgres/PostgresOperator;", "describePostgresSequence", "seq", "Lcom/intellij/database/model/postgres/PostgresSequence;", "describePostgresTable", "Lcom/intellij/database/model/postgres/PostgresTable;", "describePostgresTableColumn", "Lcom/intellij/database/model/postgres/PostgresTableColumn;", "describePostgresTrigger", "trig", "Lcom/intellij/database/model/postgres/PostgresTrigger;", "describeRoutine", "r", "Lcom/intellij/database/model/basic/BasicRoutine;", "describeSequence", "sequence", "Lcom/intellij/database/model/basic/BasicSequence;", "describeSynonym", "synonym", "Lcom/intellij/database/model/basic/BasicSynonym;", "describeTable", "Lcom/intellij/database/model/basic/BasicTable;", "describeTreeRecursively", "", "b", "Ljava/lang/StringBuilder;", "indent", "describeTrigger", "Lcom/intellij/database/model/basic/BasicTrigger;", "describeTypedElement", "Lcom/intellij/database/model/basic/BasicTypedElement;", "presentIndexColumn", "descendants", "", "decorate", "prefix", "suffix", "describeForest", "", "Lcom/intellij/database/model/basic/BasicNode;", "describeTree", "description", "descriptionContent", "notSame", "another", "or", "pluralize", "Lorg/jetbrains/annotations/NotNull;", "database-model-impl"})
@JvmName(name="ModelDescribing")
public final class ModelDescribing {
    private static final String indentStep = "    ";
    private static final char eoln = '\n';

    @NotNull
    public static final String describeForest(@NotNull Iterable<? extends BasicNode> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        StringBuilder b = new StringBuilder();
        ModelDescribing.describeForest($receiver, b);
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    private static final void describeForest(@NotNull Iterable<? extends BasicNode> $receiver, StringBuilder b) {
        Iterable<? extends BasicNode> $receiver$iv = $receiver;
        Iterator<? extends BasicNode> iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            BasicNode element$iv;
            BasicNode it = element$iv = iterator.next();
            ModelDescribing.describeTree(it, b);
        }
    }

    @NotNull
    public static final String describeTree(@NotNull BasicNode $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuilder b = new StringBuilder();
        ModelDescribing.describeTree($receiver, b);
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    private static final void describeTree(@NotNull BasicNode $receiver, StringBuilder b) {
        BasicNode basicNode = $receiver;
        if (basicNode instanceof BasicElement) {
            ModelDescribing.describeTreeRecursively((BasicElement)$receiver, b, "");
        } else if (basicNode instanceof Family) {
            ModelDescribing.describeForest((Iterable)((Object)$receiver), b);
        } else {
            b.append($receiver.toString());
        }
    }

    private static final void describeTreeRecursively(BasicElement e, StringBuilder b, String indent) {
        List<ObjectKind> kinds;
        Collection collection;
        CharSequence charSequence;
        String d = ModelDescribing.description(e);
        b.append(indent).append(d).append(eoln);
        String comment = e.getComment();
        if (comment != null && !((charSequence = (CharSequence)comment).length() == 0)) {
            b.append(indent).append(indentStep).append("--  ").append(comment).append(eoln);
        }
        if (!(collection = (Collection)(kinds = e.getFamilyKinds())).isEmpty()) {
            String indent1 = indent + indentStep;
            String indent2 = indent1 + indentStep;
            for (ObjectKind kind : kinds) {
                Family<? extends BasicElement> children = e.familyOf(kind);
                if (children == null || children.isEmpty()) continue;
                b.append(indent1).append('+').append(' ').append(ModelDescribing.pluralize(kind.code())).append(eoln);
                Iterator iterator = children.iterator();
                while (iterator.hasNext()) {
                    BasicElement child;
                    BasicElement basicElement = child = (BasicElement)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)basicElement, (String)"child");
                    ModelDescribing.describeTreeRecursively(basicElement, b, indent2);
                }
            }
        }
    }

    private static final String pluralize(@NotNull String $receiver) {
        return StringUtil.pluralize((String)$receiver);
    }

    private static final String notSame(@Nullable String $receiver, String another) {
        return Intrinsics.areEqual((Object)$receiver, (Object)another) ? null : $receiver;
    }

    private static final String decorate(@Nullable String $receiver, String prefix, String suffix) {
        return $receiver == null ? null : prefix + $receiver + suffix;
    }

    private static final String or(@Nullable String $receiver, String another) {
        return $receiver != null ? $receiver : another;
    }

    @NotNull
    public static final String description(@NotNull BasicElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.identity(false) + ": " + ModelDescribing.descriptionContent($receiver);
    }

    @NotNull
    public static final String descriptionContent(@NotNull BasicElement $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BasicElement basicElement = $receiver;
        return basicElement instanceof OraCluster ? ModelDescribing.describeOraCluster((OraCluster)$receiver) : (basicElement instanceof OraClusterColumn ? ModelDescribing.describeOraClusterColumn((OraClusterColumn)$receiver) : (basicElement instanceof OraTable ? ModelDescribing.describeOraTable((OraTable)$receiver) : (basicElement instanceof PostgresSequence ? ModelDescribing.describePostgresSequence((PostgresSequence)$receiver) : (basicElement instanceof PostgresTable ? ModelDescribing.describePostgresTable((PostgresTable)$receiver) : (basicElement instanceof PostgresTableColumn ? ModelDescribing.describePostgresTableColumn((PostgresTableColumn)$receiver) : (basicElement instanceof PostgresDefType ? ModelDescribing.describePostgresDefType((PostgresDefType)$receiver) : (basicElement instanceof PostgresOperator ? ModelDescribing.describePostgresOperator((PostgresOperator)$receiver) : (basicElement instanceof PostgresTrigger ? ModelDescribing.describePostgresTrigger((PostgresTrigger)$receiver) : (basicElement instanceof PostgresDefTypeCheck ? ModelDescribing.describePostgresDefTypeCheck((PostgresDefTypeCheck)$receiver) : (basicElement instanceof MsAliasType ? ModelDescribing.describeMsAliasType((MsAliasType)$receiver) : (basicElement instanceof BasicSequence ? ModelDescribing.describeSequence((BasicSequence)$receiver) : (basicElement instanceof BasicTable ? ModelDescribing.describeTable((BasicTable)$receiver) : (basicElement instanceof BasicIndex ? ModelDescribing.describeIndex((BasicIndex)$receiver) : (basicElement instanceof BasicKey ? ModelDescribing.describeKey((BasicKey)$receiver) : (basicElement instanceof BasicForeignKey ? ModelDescribing.describeForeignKey((BasicForeignKey)$receiver) : (basicElement instanceof BasicCheck ? ModelDescribing.describeCheck((BasicCheck)$receiver) : (basicElement instanceof BasicTrigger ? ModelDescribing.describeTrigger((BasicTrigger)$receiver) : (basicElement instanceof BasicRoutine ? ModelDescribing.describeRoutine((BasicRoutine)$receiver) : (basicElement instanceof BasicColumn ? ModelDescribing.describeColumn((BasicColumn)$receiver) : (basicElement instanceof BasicArgument ? ModelDescribing.describeArgument((BasicArgument)$receiver) : (basicElement instanceof BasicTypedElement ? ModelDescribing.describeTypedElement((BasicTypedElement)$receiver) : (basicElement instanceof BasicSynonym ? ModelDescribing.describeSynonym((BasicSynonym)$receiver) : ModelDescribing.describeBasicElement($receiver)))))))))))))))))))))));
    }

    @NotNull
    public static final String describeSequence(@NotNull BasicSequence sequence) {
        Intrinsics.checkParameterIsNotNull((Object)sequence, (String)"sequence");
        StringBuilder stringBuilder = new StringBuilder().append("sequence: ");
        Object object = sequence.getSequenceIdentity();
        if (object == null || (object = ((SequenceIdentity)object).getSpecification()) == null) {
            object = "???";
        }
        return stringBuilder.append(object).toString();
    }

    @NotNull
    public static final String describeTable(@NotNull BasicTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        return table.isTemporary() ? "temporary table" : "table";
    }

    private static final String describeIndex(BasicIndex index) {
        String inner = ModelDescribing.describeIndexingItems(index);
        String condition = index.getCondition();
        String d = (index.isUnique() ? "unique" : "index") + " (" + inner + ")";
        if (condition != null) {
            d = d + " when " + condition;
        }
        return d;
    }

    @NotNull
    public static final String describeIndexingItems(@NotNull BasicIndex index) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)index, (String)"index");
        List<String> names = index.getColNames();
        Set<String> ds = index.getReverseColNames();
        Object object = names;
        if (!object.isEmpty()) {
            object = ", ";
            CharSequence charSequence = null;
            int n = 0;
            CharSequence charSequence2 = null;
            CharSequence charSequence3 = null;
            Function1 function1 = (Function1)new Function1<String, String>(ds){
                final /* synthetic */ Set $ds;

                @NotNull
                public final String invoke(String it) {
                    Set set = this.$ds;
                    Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"ds");
                    return ModelDescribing.access$presentIndexColumn(it, set);
                }
                {
                    this.$ds = set;
                    super(1);
                }
            };
            string = CollectionsKt.joinToString$default((Iterable)names, (CharSequence)object, charSequence3, charSequence2, (int)n, charSequence, (Function1)function1, (int)30, null);
        } else {
            string = "???";
        }
        String representation2 = string;
        return representation2;
    }

    private static final String presentIndexColumn(String column, Set<String> descendants) {
        Object object;
        CharSequence charSequence;
        if (column == null || (charSequence = (CharSequence)column).length() == 0) {
            return "???";
        }
        String s = column;
        if (s.charAt(0) == '\u001b') {
            object = s;
            int n = 1;
            int n2 = s.length();
            StringBuilder stringBuilder = new StringBuilder().append("fun:");
            String string = ((String)object).substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string2 = string;
            s = stringBuilder.append(string2).toString();
        }
        if (descendants.contains(column)) {
            s = s + " desc";
        } else {
            object = descendants;
            if (!object.isEmpty()) {
                s = s + " asc";
            }
        }
        return s;
    }

    private static final String describeKey(BasicKey key) {
        List<String> names = key.getColNames();
        String k = key.isPrimary() ? "PK" : "AK";
        Collection collection = names;
        String inner = !collection.isEmpty() ? CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "???";
        String string = ModelDescribing.decorate(ModelDescribing.notSame(key.getUnderlyingIndexName(), key.getName()), " (underlying index ", ")");
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String underlying = string2;
        return k + " (" + inner + ")" + underlying;
    }

    private static final String describeForeignKey(BasicForeignKey fk) {
        String deferrable;
        List<String> names = fk.getColNames();
        Collection collection = names;
        String inner = !collection.isEmpty() ? CollectionsKt.joinToString$default((Iterable)names, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "???";
        String refTable = ModelDescribing.or(fk.getRefTableName(), "???");
        BasicKey basicKey = fk.getRefKey();
        String string = ModelDescribing.decorate(basicKey != null ? basicKey.getNaturalName() : null, "[.", "]");
        String string2 = string;
        if (string2 == null) {
            string2 = "";
        }
        String refKey = string2;
        List<String> refCols = fk.getRefColNames();
        Collection collection2 = refCols;
        String refInner = !collection2.isEmpty() ? CollectionsKt.joinToString$default((Iterable)refCols, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) : "???";
        CascadeRule cascadeRule = fk.getOnUpdate();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)cascadeRule), (String)"fk.onUpdate");
        String onUpdate = ModelDescribing.cascadeRuleIsMeaningful(cascadeRule, fk) ? " u:" + (Object)((Object)fk.getOnUpdate()) : "";
        CascadeRule cascadeRule2 = fk.getOnDelete();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)cascadeRule2), (String)"fk.onDelete");
        String onDelete = ModelDescribing.cascadeRuleIsMeaningful(cascadeRule2, fk) ? " d:" + (Object)((Object)fk.getOnDelete()) : "";
        String string3 = deferrable = fk.isDeferrable() ? " deferrable" : "";
        String deferred = fk.isInitiallyDeferred() && !fk.isDeferrable() ? " [deferred]" : (!fk.isInitiallyDeferred() && fk.isDeferrable() ? "[immediate]" : "");
        return "foreign key (" + inner + ") -> " + refTable + refKey + " (" + refInner + ")" + onUpdate + onDelete + deferrable + deferred;
    }

    private static final boolean cascadeRuleIsMeaningful(CascadeRule rule, BasicElement e) {
        boolean bl;
        BasicModel basicModel = e.getModel();
        boolean itIsPostgres = Intrinsics.areEqual((Object)(basicModel != null ? basicModel.getRdbms() : null), (Object)Postgres.RDBMS);
        switch (ModelDescribing$WhenMappings.$EnumSwitchMapping$0[rule.ordinal()]) {
            case 1: {
                bl = false;
                break;
            }
            case 2: {
                bl = itIsPostgres;
                break;
            }
            default: {
                bl = true;
            }
        }
        return bl;
    }

    private static final String describeCheck(BasicCheck check) {
        StringBuilder stringBuilder = new StringBuilder().append("check (");
        String string = check.getPredicate();
        if (string == null) {
            string = "???";
        }
        return stringBuilder.append((Object)string).append(")").toString();
    }

    /*
     * WARNING - void declaration
     */
    private static final String describeTrigger(BasicTrigger trig) {
        void $receiver$iv$iv;
        void $receiver$iv;
        String string;
        String string2;
        String string3 = string2 = trig.getKind().name();
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        String k = string4;
        List<String> cols3 = trig.getColNames();
        String string5 = string = String.valueOf((Object)trig.getTurn());
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
        String wn = StringsKt.replace$default((String)string6, (char)'_', (char)' ', (boolean)false, (int)4, null);
        Iterable iterable = trig.getEvents();
        void var6_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            String string7;
            Object object;
            void it;
            TrigEvent trigEvent = (TrigEvent)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            if (Intrinsics.areEqual((Object)it, (Object)((Object)TrigEvent.UPDATE)) && !(object = (Collection)cols3).isEmpty()) {
                string7 = "update of " + CollectionsKt.joinToString$default((Iterable)cols3, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            } else {
                Object object2 = object = it.name();
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string8 = ((String)object2).toLowerCase();
                string7 = string8;
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
            }
            String string9 = string7;
            collection.add(string9);
        }
        String wt = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)" or ", null, null, (int)0, null, null, (int)62, null);
        String cond = trig.getCondition() == null ? "" : "c:" + trig.getCondition();
        return k + " " + wn + " " + wt + " " + cond;
    }

    private static final String describeRoutine(BasicRoutine r) {
        String string;
        switch (ModelDescribing$WhenMappings.$EnumSwitchMapping$1[r.getRoutineKind().ordinal()]) {
            case 1: {
                string = "procedure";
                break;
            }
            case 2: {
                string = "function";
                break;
            }
            default: {
                string = "routine";
            }
        }
        String s = string;
        return s;
    }

    private static final String describeColumn(BasicColumn column) {
        String s = column.getDataType().getSpecification();
        if (column.isComputed()) {
            s = "computed " + s;
        }
        if (column.isNotNull()) {
            s = s + " NN";
        }
        if (column.getSequenceIdentity() != null) {
            StringBuilder stringBuilder = new StringBuilder().append(s);
            StringBuilder stringBuilder2 = new StringBuilder().append(" identity ");
            SequenceIdentity sequenceIdentity = column.getSequenceIdentity();
            if (sequenceIdentity == null) {
                Intrinsics.throwNpe();
            }
            s = stringBuilder.append(stringBuilder2.append(sequenceIdentity).toString()).toString();
        }
        if (column.getDefaultExpression() != null) {
            StringBuilder stringBuilder = new StringBuilder().append(s);
            StringBuilder stringBuilder3 = new StringBuilder().append(" default ");
            String string = column.getDefaultExpression();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            s = stringBuilder.append(stringBuilder3.append(string).toString()).toString();
        }
        String string = s;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s");
        return string;
    }

    private static final String describeArgument(BasicArgument a) {
        String string;
        String string2 = string = a.getArgumentDirection().name();
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String argWord = string3;
        String dataType = a.getDataType().toString();
        String def = a.getDefaultExpression();
        String s = argWord + ' ' + dataType;
        if (def != null) {
            s = s + " default " + def;
        }
        return s;
    }

    private static final String describeTypedElement(BasicTypedElement e) {
        String string = e.getDataType().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.dataType.toString()");
        return string;
    }

    private static final String describeSynonym(BasicSynonym synonym) {
        String string;
        String objectName;
        BasicMajorObject targetObject = synonym.getTargetObject();
        if (targetObject != null) {
            return "synonym -> " + targetObject.getKind().code() + " " + targetObject.getName();
        }
        String schemaName = synonym.getTargetSchemaName() != null && Intrinsics.areEqual((Object)synonym.getTargetSchemaName(), (Object)synonym.getSchemaName()) ^ true ? synonym.getTargetSchemaName() : null;
        String string2 = synonym.getTargetObjectName();
        if (string2 == null) {
            string2 = objectName = "<unnamed-object>";
        }
        if (schemaName != null) {
            string = schemaName + "." + objectName;
        } else {
            String string3 = objectName;
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"objectName");
        }
        String x = string;
        return "synonym -> <unknown> " + x;
    }

    private static final String describeBasicElement(BasicElement e) {
        String string = e.getKind().code();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"e.kind.code()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String describeOraCluster(OraCluster cluster) {
        String columns = CollectionsKt.joinToString$default((Iterable)cluster.getColumns().getNames(), null, null, null, (int)0, null, null, (int)63, null);
        ClusterType clusterType = cluster.getClusterType();
        if (clusterType == null) return "cluster (" + columns + ")";
        switch (ModelDescribing$WhenMappings.$EnumSwitchMapping$2[clusterType.ordinal()]) {
            case 1: {
                return "index cluster (" + columns + ") block size " + cluster.getBlockSize();
            }
            case 2: {
                String exp = cluster.getHashExpression();
                String s = exp == null ? "hash cluster (" + columns + ") hash by column cardinality " + cluster.getHashCardinality() : "hash cluster (" + columns + ") hash by (" + exp + ") cardinality " + cluster.getHashCardinality();
                if (!cluster.isSingleTable()) return s;
                return s + " (single table)";
            }
            default: {
                return "cluster (" + columns + ")";
            }
        }
    }

    private static final String describeOraClusterColumn(OraClusterColumn column) {
        String s = column.getDataType().toString();
        if (column.isSorted()) {
            s = s + " sort";
        }
        String string = s;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"s");
        return string;
    }

    @NotNull
    public static final String describeOraTable(@NotNull OraTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        return Intrinsics.areEqual((Object)((Object)table.getOrganization()), (Object)((Object)TableOrganization.ORA_CLUSTERED_BY_INDEX)) ? "cluster table" : (Intrinsics.areEqual((Object)((Object)table.getOrganization()), (Object)((Object)TableOrganization.ORA_CLUSTERED_BY_HASH)) ? "cluster table" : (table.isTemporary() && table.isTemporaryPreserve() ? "temporary table (preserve rows)" : (table.isTemporary() && !table.isTemporaryPreserve() ? "temporary table" : ModelDescribing.describeTable(table))));
    }

    private static final String describePostgresSequence(PostgresSequence seq) {
        String def = ModelDescribing.describeSequence(seq);
        String category = seq.isBelongsToColumn() ? "private" : "shared";
        return category + ' ' + def;
    }

    private static final String describePostgresTable(PostgresTable table) {
        String d = ModelDescribing.describeTable(table);
        Collection collection = table.getAncestorIds();
        if (!collection.isEmpty()) {
            d = d + " (" + ModelFun.namesAsString((Collection<? extends BasicNamedElement>)PostgresModelFun.getAncestors(table)) + ")";
        }
        if (!(collection = (Collection)table.getSuccessorIds()).isEmpty()) {
            d = d + " {" + ModelFun.namesAsString((Collection<? extends BasicNamedElement>)PostgresModelFun.getSuccessors(table)) + "}";
        }
        return d;
    }

    private static final String describePostgresTableColumn(PostgresTableColumn column) {
        String d = ModelDescribing.describeColumn(column);
        if (column.isInherited()) {
            d = "inherited " + d;
        }
        return d;
    }

    private static final String describePostgresDefType(PostgresDefType dt) {
        Collection collection;
        PostgresDataTypeSubKind sk = dt.getSubKind();
        PostgresDataTypeSubCategory sc = dt.getSubCategory();
        StringBuilder b = new StringBuilder(60);
        b.append(sk.human_readable_name());
        if (Intrinsics.areEqual((Object)((Object)sc), (Object)((Object)PostgresDataTypeSubCategory.NONE)) ^ true && Intrinsics.areEqual((Object)sc.human_readable_name(), (Object)sk.human_readable_name()) ^ true) {
            b.append(' ').append('(').append(sc.human_readable_name()).append(')');
        }
        if (dt.getDefinition() != null) {
            b.append(" of ").append(dt.getDefinition());
        }
        if (!(collection = (Collection)dt.getLabels()).isEmpty()) {
            b.append(" of {").append(CollectionsKt.joinToString$default((Iterable)dt.getLabels(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append("}");
        }
        if (dt.getDefaultExpression() != null) {
            b.append(" default ").append(dt.getDefaultExpression());
        }
        if (dt.isNotNull()) {
            b.append(" NN");
        }
        String string = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"b.toString()");
        return string;
    }

    private static final String describePostgresOperator(PostgresOperator op) {
        StringBuilder b = new StringBuilder(60);
        String string = op.getOperatorKind().name();
        StringBuilder stringBuilder = b;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        String string4 = string3;
        stringBuilder.append(string4).append(" operator (");
        if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true) {
            b.append(op.getLeftType());
        }
        if (Intrinsics.areEqual((Object)op.getLeftType(), (Object)DataType.UNKNOWN) ^ true && Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
            b.append(", ");
        }
        if (Intrinsics.areEqual((Object)op.getRightType(), (Object)DataType.UNKNOWN) ^ true) {
            b.append(op.getRightType());
        }
        b.append(") -> ");
        b.append(op.getResultType());
        if (op.getCallRoutineName() != null) {
            b.append(" [bound to ").append(op.getCallRoutineName()).append(']');
        }
        String string5 = b.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"b.toString()");
        return string5;
    }

    private static final String describePostgresTrigger(PostgresTrigger trig) {
        String d = ModelDescribing.describeTrigger(trig);
        String r = PostgresModelFun.getCallRoutineName(trig);
        if (r != null) {
            d = d + (" -> " + r + "()");
        }
        return d;
    }

    private static final String describePostgresDefTypeCheck(PostgresDefTypeCheck check) {
        return "check " + check.getPredicate();
    }

    private static final String describeMsAliasType(MsAliasType e) {
        return e.getDataType().toString() + (e.isNotNull() ? " NN" : "");
    }

    @NotNull
    public static final /* synthetic */ String access$presentIndexColumn(@Nullable String column, @NotNull Set descendants) {
        return ModelDescribing.presentIndexColumn(column, descendants);
    }
}

