/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mssql;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.mssql.MsModSchema;
import com.intellij.database.model.mssql.MsModSchemaObject;
import com.intellij.database.model.mssql.MsSynonym;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MsModSynonym
extends MsSynonym,
MsModSchemaObject {
    @Override
    @NotNull
    public MsModSchema getSchema();

    @Override
    @NotNull
    default public MsModSchema getDbParent() {
        MsModSchema msModSchema = this.getSchema();
        if (msModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModSynonym", "getDbParent"));
        }
        return msModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends MsModSynonym> getParentFamily();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModSynonym", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModSynonym", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    public void setTargetSchemaName(@Nullable String var1);

    public void setTargetObjectKind(@NotNull ObjectKind var1);

    public void setTargetObjectName(@Nullable String var1);

    public void setInvalid(boolean var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/mssql/MsModSynonym", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String createdTimestamp = properties.get("CreatedTimestamp");
        String modifiedTimestamp = properties.get("ModifiedTimestamp");
        String targetSchemaName = properties.get("TargetSchemaName");
        String targetObjectKind = properties.get("TargetObjectKind");
        String targetObjectName = properties.get("TargetObjectName");
        String invalid = properties.get("Invalid");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (createdTimestamp != null) {
            this.setCreatedTimestamp(PropertyConverter.importDate(createdTimestamp));
        }
        if (modifiedTimestamp != null) {
            this.setModifiedTimestamp(PropertyConverter.importDate(modifiedTimestamp));
        }
        if (targetSchemaName != null) {
            this.setTargetSchemaName(PropertyConverter.importString(targetSchemaName));
        }
        if (targetObjectKind != null) {
            this.setTargetObjectKind(PropertyConverter.importObjectKind(targetObjectKind));
        }
        if (targetObjectName != null) {
            this.setTargetObjectName(PropertyConverter.importString(targetObjectName));
        }
        if (invalid != null) {
            this.setInvalid(PropertyConverter.importBoolean(invalid));
        }
    }
}

