/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.postgres.PostgresModLikeStoredTable;
import com.intellij.database.model.postgres.PostgresModRule;
import com.intellij.database.model.postgres.PostgresModSchema;
import com.intellij.database.model.postgres.PostgresModSourceAware;
import com.intellij.database.model.postgres.PostgresModTrigger;
import com.intellij.database.model.postgres.PostgresModViewColumn;
import com.intellij.database.model.postgres.PostgresView;
import com.intellij.database.model.properties.PostgresCheckOption;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.database.model.properties.SourceError;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresModView
extends PostgresView,
PostgresModLikeStoredTable,
PostgresModSourceAware {
    @Override
    @NotNull
    public PostgresModSchema getSchema();

    @Override
    @NotNull
    default public PostgresModSchema getDbParent() {
        PostgresModSchema postgresModSchema = this.getSchema();
        if (postgresModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModView", "getDbParent"));
        }
        return postgresModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModView> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends PostgresModViewColumn> getColumns();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModRule> getRules();

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends PostgresModTrigger> getTriggers();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getRules(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModView", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append((Iterable)this.getRules()).append((Iterable)this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresModView", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    @Override
    public void setStateNumber(long var1);

    @Override
    public void setErrors(@NotNull List<SourceError> var1);

    @Override
    default public void setErrors(SourceError ... errors) {
        this.setErrors(Arrays.asList(errors));
    }

    @Override
    public void setInvalid(boolean var1);

    public void setCheckOption(@NotNull PostgresCheckOption var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/postgres/PostgresModView", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String system = properties.get("System");
        String stateNumber = properties.get("StateNumber");
        String invalid = properties.get("Invalid");
        String checkOption = properties.get("CheckOption");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (system != null) {
            this.setSystem(PropertyConverter.importBoolean(system));
        }
        if (stateNumber != null) {
            this.setStateNumber(PropertyConverter.importLong(stateNumber));
        }
        if (invalid != null) {
            this.setInvalid(PropertyConverter.importBoolean(invalid));
        }
        if (checkOption != null) {
            this.setCheckOption(PropertyConverter.importPostgresCheckOption(checkOption));
        }
    }
}

