/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.ide.TextCopyProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorNotificationPanel
extends JPanel {
    private static final String CLOSE_COMMAND = "close";
    private final JEditorPane myMessagePane;
    private final Map<String, Runnable> myActions;
    private final CopyProvider myCopyProvider;

    private ErrorNotificationPanel(String htmlErrorMessage, @NotNull Map<String, Runnable> actions) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/database/run/ui/ErrorNotificationPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myActions = actions;
        this.setBorder((Border)JBUI.Borders.empty((int)0, (int)4));
        this.myMessagePane = IdeTooltipManager.initPane((String)htmlErrorMessage, (HintHint)new HintHint().setAwtTooltip(false).setTextBg(this.getBackground()).setBorderColor(this.getBackground()).setBorderInsets((Insets)JBUI.emptyInsets()), null);
        this.myMessagePane.setBorder(null);
        this.myMessagePane.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/ErrorNotificationPanel$1", "hyperlinkActivated"));
                }
                ErrorNotificationPanel.this.performAction(e.getDescription());
            }
        });
        this.add((Component)this.myMessagePane, "Center");
        this.myCopyProvider = new TextCopyProvider(){

            @Nullable
            public Collection<String> getTextLinesToCopy() {
                String text = ErrorNotificationPanel.this.myMessagePane.getSelectedText();
                return StringUtil.isEmpty((String)text) ? null : Collections.singleton(text);
            }
        };
        new DumbAwareAction(CLOSE_COMMAND){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/run/ui/ErrorNotificationPanel$3", "actionPerformed"));
                }
                ErrorNotificationPanel.this.performAction(ErrorNotificationPanel.CLOSE_COMMAND);
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{27}), (JComponent)this);
        DataManager.registerDataProvider((JComponent)this.myMessagePane, (DataProvider)new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
                    return ErrorNotificationPanel.this.myCopyProvider;
                }
                return null;
            }
        });
    }

    private void performAction(String actionName) {
        Runnable action = this.myActions.get(actionName);
        if (action != null) {
            action.run();
        }
    }

    @Override
    @NotNull
    public Color getBackground() {
        Color color = MessageType.ERROR.getPopupBackground();
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/ErrorNotificationPanel", "getBackground"));
        }
        return color;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        JBDimension jBDimension = JBUI.emptySize();
        if (jBDimension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/ErrorNotificationPanel", "getMinimumSize"));
        }
        return jBDimension;
    }

    public JComponent getContent() {
        return this.myMessagePane;
    }

    @NotNull
    public static Builder create(@Nullable String message, @Nullable Throwable error, @NotNull JComponent baseComponent) {
        if (baseComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseComponent", "com/intellij/database/run/ui/ErrorNotificationPanel", "create"));
        }
        Builder builder = new Builder(message, error, baseComponent);
        if (builder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/ErrorNotificationPanel", "create"));
        }
        return builder;
    }

    public static class Builder {
        private final boolean myLongMessage;
        private final Throwable myError;
        private final String myMessage;
        private final JComponent myBaseComponent;
        private final Map<String, Runnable> myActions;
        private final List<Consumer<Disposable>> myShowHideHandlers;
        private final StringBuilder myHtmlBuilder;

        private Builder(@Nullable String message, @Nullable Throwable error, @NotNull JComponent baseComponent) {
            if (baseComponent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseComponent", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "<init>"));
            }
            this.myActions = ContainerUtil.newLinkedHashMap();
            this.myShowHideHandlers = ContainerUtil.newArrayList();
            this.myHtmlBuilder = new StringBuilder();
            this.myError = error;
            this.myMessage = message;
            this.myBaseComponent = baseComponent;
            String errorMessage = message == null ? (error == null ? null : Builder.getNormalizedMessage(error)) : message;
            Font font = IdeTooltipManager.getInstance().getTextFont(true);
            FontMetrics fm = baseComponent.getFontMetrics(font);
            this.myLongMessage = SwingUtilities.computeStringWidth(fm, errorMessage) > baseComponent.getWidth() * 3 / 4;
            this.myHtmlBuilder.append("<html><head><style type=\"text/css\">a:link {text-decoration:none;}</style></head><body>");
            this.myHtmlBuilder.append("<font face=\"verdana\"><table width=\"100%\"><tr valign=\"top\"><td>");
            this.myHtmlBuilder.append(StringUtil.escapeXml((String)errorMessage));
            this.myHtmlBuilder.append("</td>");
        }

        @NotNull
        public Builder addIconLink(String command, String icon, String tooltipText, @NotNull Icon realIcon, @Nullable Runnable action) {
            if (realIcon == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "realIcon", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "addIconLink"));
            }
            String imgURL = "";
            try {
                URL resource = AllIcons.class.getClassLoader().getResource(icon);
                imgURL = resource != null ? resource.toURI().toURL().toExternalForm() : null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.startActionColumn();
            this.myHtmlBuilder.append("<a href=\"").append(command).append("\"><img alt=\"").append(tooltipText).append("\" hspace=\"0\" vspace=\"0\" border=\"0\" width=\"").append(realIcon.getIconWidth()).append("\" height=\"").append(realIcon.getIconHeight()).append("\" src=\"");
            this.myHtmlBuilder.append(imgURL).append("\"></a>");
            this.endActionColumn();
            if (action != null) {
                this.myActions.put(command, action);
            }
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "addIconLink"));
            }
            return builder;
        }

        @NotNull
        public Builder addLink(@NotNull String command, @NotNull String linkHtml, @NotNull Runnable action) {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "addLink"));
            }
            if (linkHtml == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linkHtml", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "addLink"));
            }
            if (action == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "addLink"));
            }
            this.startActionColumn();
            int mnemonicIndex = UIUtil.getDisplayMnemonicIndex((String)command);
            String fixedCommand = mnemonicIndex < 0 ? command : command.substring(0, mnemonicIndex) + command.substring(mnemonicIndex + 1);
            ContainerUtil.addIfNotNull(this.myShowHideHandlers, Builder.createMnemonicActionIfNeeded(fixedCommand, mnemonicIndex, action, this.myBaseComponent));
            this.myHtmlBuilder.append("<a style=\"text-decoration:none;\" href=\"").append(fixedCommand).append("\">").append(linkHtml).append("</a>");
            this.endActionColumn();
            this.myActions.put(fixedCommand, action);
            Builder builder = this;
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "addLink"));
            }
            return builder;
        }

        @NotNull
        public Builder addDetailsButton() {
            String message;
            String string = this.myError == null ? this.myMessage : (message = this.myError.getStackTrace().length > 0 ? ExceptionUtil.getThrowableText((Throwable)this.myError, (String)"com.intellij.") : this.myError.getMessage());
            if (StringUtil.contains((CharSequence)this.myHtmlBuilder, (CharSequence)message)) {
                Builder builder = this;
                if (builder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "addDetailsButton"));
                }
                return builder;
            }
            Builder builder = this.addLink("details", "Details", () -> Messages.showIdeaMessageDialog(null, (String)message, (String)"Query Error", (String[])new String[]{CommonBundle.getOkButtonText()}, (int)0, (Icon)Messages.getErrorIcon(), null));
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "addDetailsButton"));
            }
            return builder;
        }

        @NotNull
        public Builder addCloseButton(Runnable action) {
            Builder builder = this.addIconLink(ErrorNotificationPanel.CLOSE_COMMAND, "/actions/cross.png", "Close (Esc)", AllIcons.Actions.Cross, action);
            if (builder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "addCloseButton"));
            }
            return builder;
        }

        @NotNull
        public ErrorNotificationPanel build() {
            this.myHtmlBuilder.append("</tr></table></font></body>");
            ErrorNotificationPanel result = new ErrorNotificationPanel(this.myHtmlBuilder.toString(), this.myActions);
            this.registerShowHideHandlers(result);
            ErrorNotificationPanel errorNotificationPanel = result;
            if (errorNotificationPanel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "build"));
            }
            return errorNotificationPanel;
        }

        private void startActionColumn() {
            this.myHtmlBuilder.append("<td width=\"1%\" align=\"right\" valign=\"").append(this.myLongMessage ? "top" : "middle").append("\" nowrap>");
        }

        private void endActionColumn() {
            this.myHtmlBuilder.append("</td>");
        }

        @NotNull
        private static String getNormalizedMessage(@NotNull Throwable error) {
            if (error == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "getNormalizedMessage"));
            }
            String sourceMessage = StringUtil.notNullize((String)error.getMessage(), (String)"An unknown problem occurred (see Details)");
            int divPos = sourceMessage.indexOf("\n\tat ");
            if (divPos != -1) {
                sourceMessage = sourceMessage.substring(0, divPos);
            }
            String string = StringUtil.trimLog((String)sourceMessage, (int)1024);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "getNormalizedMessage"));
            }
            return string;
        }

        protected void registerShowHideHandlers(@NotNull JComponent component) {
            if (component == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/database/run/ui/ErrorNotificationPanel$Builder", "registerShowHideHandlers"));
            }
            if (this.myShowHideHandlers.isEmpty()) {
                return;
            }
            new UiNotifyConnector((Component)component, new Activatable(){
                private Disposable showNotified;

                public void showNotify() {
                    this.showNotified = Disposer.newDisposable();
                    for (Consumer handler : myShowHideHandlers) {
                        handler.consume((Object)this.showNotified);
                    }
                }

                public void hideNotify() {
                    if (this.showNotified != null) {
                        Disposer.dispose((Disposable)this.showNotified);
                    }
                    this.showNotified = null;
                }
            });
        }

        @Nullable
        private static Consumer<Disposable> createMnemonicActionIfNeeded(String command, int mnemonicIndex, final Runnable runnable, JComponent component) {
            if (mnemonicIndex < 0) {
                return null;
            }
            return parentDisposable -> {
                DumbAwareAction a = new DumbAwareAction(command){

                    public void actionPerformed(AnActionEvent e) {
                        runnable.run();
                    }
                };
                int modifiers = SystemInfo.isMac && !Registry.is((String)"ide.mac.alt.mnemonic.without.ctrl") ? 10 : 8;
                KeyStroke keyStroke = KeyStroke.getKeyStroke((int)Character.toUpperCase(Character.valueOf(command.charAt(mnemonicIndex)).charValue()), modifiers);
                a.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), component, parentDisposable);
            };
        }
    }
}

