/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ui.grid.editors.BoundaryValueResolver;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.openapi.util.Pair;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import org.jetbrains.annotations.NotNull;

public class DateAndTimeFormatter<T, V extends TemporalAccessor>
implements Formatter {
    private final DateTimeFormatter myFormatter;
    private final String myPattern;
    private final DateAndTimeFormatterDelegate<T, V> myDelegate;
    private final BoundaryValueResolver myBoundaryValuesResolver;

    public DateAndTimeFormatter(@NotNull Pair<String, DateTimeFormatter> pair, @NotNull DateAndTimeFormatterDelegate<T, V> delegate) {
        if (pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter", "<init>"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter", "<init>"));
        }
        this(pair, delegate, BoundaryValueResolver.ALWAYS_NULL);
    }

    public DateAndTimeFormatter(@NotNull Pair<String, DateTimeFormatter> pair, @NotNull DateAndTimeFormatterDelegate<T, V> delegate, @NotNull BoundaryValueResolver resolver) {
        if (pair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter", "<init>"));
        }
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter", "<init>"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter", "<init>"));
        }
        this.myPattern = (String)pair.getFirst();
        this.myFormatter = (DateTimeFormatter)pair.getSecond();
        this.myDelegate = delegate;
        this.myBoundaryValuesResolver = resolver;
    }

    @Override
    public Object parse(@NotNull String value) throws ParseException {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter", "parse"));
        }
        Object boundary = this.myBoundaryValuesResolver.createFromBoundary(value);
        if (boundary != null) {
            return boundary;
        }
        try {
            V temporal = this.parseInternal(value, this.myDelegate.getQueries());
            T result = this.myDelegate.create(temporal, this.myFormatter.format((TemporalAccessor)temporal));
            String boundaryString = this.myBoundaryValuesResolver.getBoundaryString(this.myBoundaryValuesResolver.getValue(result));
            return boundaryString != null ? this.myBoundaryValuesResolver.createFromBoundary(boundaryString) : result;
        }
        catch (DateTimeParseException e) {
            throw new ParseException(value, e.getErrorIndex());
        }
    }

    private V parseInternal(String value, TemporalQuery<V> ... queries) {
        for (TemporalQuery<V> query : queries) {
            try {
                return (V)((TemporalAccessor)this.myFormatter.parse((CharSequence)value, query));
            }
            catch (DateTimeException dateTimeException) {
            }
        }
        throw new DateTimeParseException(value + "can't be parsed", value, 0);
    }

    @Override
    public Object parse(@NotNull String value, @NotNull ParsePosition position) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter", "parse"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter", "parse"));
        }
        try {
            return this.parse(value);
        }
        catch (ParseException e) {
            position.setErrorIndex(e.getErrorOffset());
            return null;
        }
    }

    @Override
    public String format(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter", "format"));
        }
        String boundary = this.myBoundaryValuesResolver.resolve(value);
        if (boundary != null) {
            return boundary;
        }
        V temporalAccessor = this.myDelegate.toTemporalAccessor(value);
        return this.myFormatter.format((TemporalAccessor)temporalAccessor);
    }

    public TemporalAccessor getTemporalAccessor(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/DateAndTimeFormatter", "getTemporalAccessor"));
        }
        return this.myDelegate.toTemporalAccessor(value);
    }

    public String toString() {
        return this.myPattern;
    }
}

