/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.generation;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationGenerator;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.generation.DdlOperations;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DdlGenerator
implements DdlOperation.DdlOperationSupport {
    private final DdlOperations myGenerators;
    private final SchemaExporters myExporters;
    private final DatabaseEditorContext myContext;

    public DdlGenerator(@NotNull DdlOperations generators, @NotNull SchemaExporters exporters, @NotNull DatabaseEditorContext context) {
        if (generators == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generators", "com/intellij/database/schemaEditor/generation/DdlGenerator", "<init>"));
        }
        if (exporters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exporters", "com/intellij/database/schemaEditor/generation/DdlGenerator", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/generation/DdlGenerator", "<init>"));
        }
        this.myGenerators = generators;
        this.myExporters = exporters;
        this.myContext = context;
    }

    @Override
    public boolean isSupported(@NotNull DdlOperation op, @NotNull DeObject das) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGenerator", "isSupported"));
        }
        if (das == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/generation/DdlGenerator", "isSupported"));
        }
        return this.myGenerators.isSupported(op, das);
    }

    @Override
    public boolean isSupportedLight(@NotNull DdlOperation op, @NotNull ObjectKind kind) {
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGenerator", "isSupportedLight"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/schemaEditor/generation/DdlGenerator", "isSupportedLight"));
        }
        return this.myGenerators.isSupportedLight(op, kind);
    }

    @NotNull
    public DdlGraphBuilder addOperation(@NotNull DdlGraphBuilder builder, @NotNull DdlOperation op, @Nullable DeObject das, @Nullable UserDataHolder data) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlGenerator", "addOperation"));
        }
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGenerator", "addOperation"));
        }
        if (das == null) {
            DdlGraphBuilder ddlGraphBuilder = builder;
            if (ddlGraphBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGenerator", "addOperation"));
            }
            return ddlGraphBuilder;
        }
        DdlOperationGenerator generator = this.myGenerators.get(op);
        assert (generator != null);
        generator.addToBuilder(this, builder, das, data);
        DdlGraphBuilder ddlGraphBuilder = builder;
        if (ddlGraphBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGenerator", "addOperation"));
        }
        return ddlGraphBuilder;
    }

    public DdlGraphBuilder removeOperation(@NotNull DdlGraphBuilder builder, @NotNull DdlOperation op, @NotNull DeObject das, @Nullable UserDataHolder data) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlGenerator", "removeOperation"));
        }
        if (op == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "op", "com/intellij/database/schemaEditor/generation/DdlGenerator", "removeOperation"));
        }
        if (das == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/generation/DdlGenerator", "removeOperation"));
        }
        DdlOperationGenerator generator = this.myGenerators.get(op);
        assert (generator != null);
        generator.removeFromBuilder(this, builder, das, data);
        return builder;
    }

    @NotNull
    public DdlOperations.SchemaState buildState(@NotNull DasModel editedModel) {
        if (editedModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editedModel", "com/intellij/database/schemaEditor/generation/DdlGenerator", "buildState"));
        }
        MySchemaState mySchemaState = new MySchemaState(this.myExporters, this.myContext, editedModel);
        if (mySchemaState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGenerator", "buildState"));
        }
        return mySchemaState;
    }

    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DdlGraphBuilder graphBuilder, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        if (graphBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphBuilder", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        DdlBuilder ddlBuilder = this.generate(builder, graphBuilder.buildComponents(), context);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        return ddlBuilder;
    }

    @NotNull
    private DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull Iterable<DdlGraph> graphs, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        if (graphs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphs", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        HashSet visited = ContainerUtil.newHashSet();
        for (DdlGraph graph : graphs) {
            this.generate(builder, graph, context, visited);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        return ddlBuilder;
    }

    @NotNull
    private DdlBuilder generate(final @NotNull DdlBuilder builder, final @NotNull DdlGraph graph, final @NotNull DdlBuildingContext context, final @NotNull Set<DdlOperationKey> visited) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        if (graph.hasCycles() == ThreeState.UNSURE) {
            graph.setHasCycles(ThreeState.fromBoolean((boolean)DdlGraph.hasCycles(graph)));
        }
        if (graph.hasCycles() == ThreeState.YES) {
            throw new UnsupportedOperationException("Could not resolve circular dependencies");
        }
        DdlOperationKey root2 = DdlGenerator.getRoot(graph);
        DdlGraph.visitDfs(graph, root2, new DdlGraph.DfsVisitor<DdlOperationKey>(){

            @Override
            public boolean visit(@NotNull DdlOperationKey key, @NotNull DdlGraph.DfsVisitor.Reason reason) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/schemaEditor/generation/DdlGenerator$1", "visit"));
                }
                if (reason == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reason", "com/intellij/database/schemaEditor/generation/DdlGenerator$1", "visit"));
                }
                if (reason != DdlGraph.DfsVisitor.Reason.LEAVE || visited.contains(key)) {
                    return true;
                }
                visited.add(key);
                DdlOperationGenerator generator = DdlGenerator.this.myGenerators.get(key.operation);
                if (generator == null) {
                    throw new UnsupportedOperationException("No generator found: " + key.operation);
                }
                generator.generate(builder, key.target, graph.getData(key), context);
                return true;
            }
        });
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGenerator", "generate"));
        }
        return ddlBuilder;
    }

    @NotNull
    private static DdlOperationKey getRoot(@NotNull DdlGraph graph) {
        if (graph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/database/schemaEditor/generation/DdlGenerator", "getRoot"));
        }
        DdlOperationKey ddlOperationKey = (DdlOperationKey)ObjectUtils.assertNotNull((Object)DdlGenerator.foldl(graph.getSources().iterator(), new PairFunction<DdlOperationKey, DdlOperationKey, DdlOperationKey>(){
            DepthComparator comparator = new DepthComparator();

            public DdlOperationKey fun(DdlOperationKey t, DdlOperationKey v) {
                return this.comparator.compare(t, v) < 0 ? t : v;
            }
        }));
        if (ddlOperationKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGenerator", "getRoot"));
        }
        return ddlOperationKey;
    }

    private static <T, U> U foldl(U first, @NotNull Iterator<T> it, @NotNull PairFunction<U, T, U> func) {
        if (it == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "com/intellij/database/schemaEditor/generation/DdlGenerator", "foldl"));
        }
        if (func == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "func", "com/intellij/database/schemaEditor/generation/DdlGenerator", "foldl"));
        }
        while (it.hasNext()) {
            first = func.fun(first, it.next());
        }
        return first;
    }

    @Nullable
    private static <T> T foldl(@NotNull Iterator<T> it, @NotNull PairFunction<T, T, T> func) {
        if (it == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "it", "com/intellij/database/schemaEditor/generation/DdlGenerator", "foldl"));
        }
        if (func == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "func", "com/intellij/database/schemaEditor/generation/DdlGenerator", "foldl"));
        }
        if (!it.hasNext()) {
            return null;
        }
        return DdlGenerator.foldl(it.next(), it, func);
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGenerator", "getContext"));
        }
        return databaseEditorContext;
    }

    private static class MySchemaState
    implements DdlOperations.SchemaState {
        private MySchemaExportHelper myExporter;
        private Map<DeObject, DeObject> myAltering;
        private Set<DeObject> myRemoved;

        public MySchemaState(@NotNull SchemaExporters exporters, @NotNull DatabaseEditorContext context, @NotNull DasModel model) {
            if (exporters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exporters", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState", "<init>"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState", "<init>"));
            }
            this.myAltering = ContainerUtil.newHashMap();
            this.myRemoved = ContainerUtil.newHashSet();
            this.myExporter = new MySchemaExportHelper(exporters, context, model);
        }

        @Nullable
        private DeObject toAcceptable(@Nullable DeObject object) {
            if (object == null || this.myRemoved.contains(object)) {
                return null;
            }
            if (this.myAltering.containsKey(object)) {
                DeObject alt = this.myAltering.get(object);
                return alt == null ? object : this.toAcceptable(alt);
            }
            if (object.model == this.myExporter.getModel().getModel()) {
                return object;
            }
            return this.toAcceptable((DeObject)ObjectUtils.tryCast((Object)object.editedObject, DeObject.class));
        }

        @NotNull
        private DeObject ensureAcceptable(@NotNull DeObject object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState", "ensureAcceptable"));
            }
            DeObject deObject = (DeObject)ObjectUtils.assertNotNull((Object)this.toAcceptable(object));
            if (deObject == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState", "ensureAcceptable"));
            }
            return deObject;
        }

        @Override
        @NotNull
        public <De extends DeObject> De get(@NotNull De object, boolean withChildren) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState", "get"));
            }
            DeObject deObject = (DeObject)ObjectUtils.assertNotNull(this.myExporter.export(object, withChildren));
            if (deObject == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState", "get"));
            }
            return (De)deObject;
        }

        @Override
        public void remove(@NotNull DeObject object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState", "remove"));
            }
            for (DeObject deObject : object.getChildren()) {
                this.remove(deObject);
            }
            this.myRemoved.add(this.ensureAcceptable(object));
        }

        @Override
        @NotNull
        public <De extends DeObject> De add(@NotNull De object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState", "add"));
            }
            Object De = this.myExporter.add(object, false);
            if (De == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState", "add"));
            }
            return De;
        }

        @Override
        public <De extends DeObject> void alter(@NotNull De from, @NotNull De to) {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState", "alter"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState", "alter"));
            }
            this.myAltering.put(to, from);
        }

        class MySchemaExportHelper
        extends SchemaExportHelper {
            public MySchemaExportHelper(@NotNull SchemaExporters exporter, @NotNull DatabaseEditorContext context, DasModel model) {
                if (exporter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exporter", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState$MySchemaExportHelper", "<init>"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState$MySchemaExportHelper", "<init>"));
                }
                if (model == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/generation/DdlGenerator$MySchemaState$MySchemaExportHelper", "<init>"));
                }
                super(exporter, context, model);
            }

            @Override
            public <De extends DeObject> De export(@Nullable DasObject object, boolean withChildren) {
                return super.export(MySchemaState.this.toAcceptable((DeObject)object), withChildren);
            }

            public <De extends DeObject> De add(@Nullable DeObject object, boolean withChildren) {
                MySchemaState.this.myAltering.put(object, null);
                return super.export(object, withChildren);
            }
        }
    }

    private static class DepthComparator
    implements Comparator<DdlOperationKey> {
        private final TObjectIntHashMap<DeObject> myDepthCache = new TObjectIntHashMap();

        private DepthComparator() {
        }

        private int getDepth(@Nullable DeObject object) {
            if (object == null) {
                return 0;
            }
            if (this.myDepthCache.contains((Object)object)) {
                return this.myDepthCache.get((Object)object);
            }
            int depth = this.getDepth(object.getParent()) + 1;
            this.myDepthCache.put((Object)object, depth);
            return depth;
        }

        @Override
        public int compare(DdlOperationKey o1, DdlOperationKey o2) {
            return Comparing.compare((int)this.getDepth(o1.target), (int)this.getDepth(o2.target));
        }
    }
}

