/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.generation;

import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGenerator;
import com.intellij.database.schemaEditor.generation.DdlGraphBuilder;
import com.intellij.database.schemaEditor.generation.DdlOperation;
import com.intellij.database.schemaEditor.generation.DdlOperationKey;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DdlOperationGenerator<T extends DeObject> {
    @NotNull
    protected final Logger myLogger;
    @NotNull
    private final DdlOperation myOperation;

    public DdlOperationGenerator(@NotNull DdlOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "<init>"));
        }
        this.myLogger = Logger.getInstance(this.getClass());
        this.myOperation = operation;
    }

    @NotNull
    public DdlOperation getOperation() {
        DdlOperation ddlOperation = this.myOperation;
        if (ddlOperation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "getOperation"));
        }
        return ddlOperation;
    }

    public boolean isSupported(@NotNull DdlOperation.DdlOperationSupport support, @NotNull DeObject obj) {
        if (support == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "support", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "isSupported"));
        }
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "isSupported"));
        }
        return this.isSupportedLight(support, obj.getKind());
    }

    public abstract boolean isSupportedLight(@NotNull DdlOperation.DdlOperationSupport var1, @NotNull ObjectKind var2);

    @NotNull
    public JBIterable<DdlOperationKey> getImplemented(@NotNull T object, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "getImplemented"));
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "getImplemented"));
        }
        return jBIterable;
    }

    @NotNull
    public DdlGenerator addToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull T das, @Nullable UserDataHolder data) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "addToBuilder"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "addToBuilder"));
        }
        if (das == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "addToBuilder"));
        }
        DdlGenerator ddlGenerator = this.addSelfToBuilder(generator, builder, das, data);
        if (ddlGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "addToBuilder"));
        }
        return ddlGenerator;
    }

    @NotNull
    protected DdlGenerator addSelfToBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull T das, @Nullable UserDataHolder data) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "addSelfToBuilder"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "addSelfToBuilder"));
        }
        if (das == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "addSelfToBuilder"));
        }
        DdlOperationKey op = new DdlOperationKey((DeObject)das, this.getOperation());
        if (!builder.isScheduled(op)) {
            builder.addOperation(op, data, (Iterable<DdlOperationKey>)this.getImplemented(das, data)).addDependencies(op, (Iterable<DdlOperationKey>)this.getDependencies(das, data)).addDependencies((Iterable<DdlOperationKey>)this.getDependants(das, data), op);
        }
        DdlGenerator ddlGenerator = generator;
        if (ddlGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "addSelfToBuilder"));
        }
        return ddlGenerator;
    }

    @NotNull
    public DdlGenerator removeFromBuilder(@NotNull DdlGenerator generator, @NotNull DdlGraphBuilder builder, @NotNull T das, @Nullable UserDataHolder data) {
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "removeFromBuilder"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "removeFromBuilder"));
        }
        if (das == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "das", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "removeFromBuilder"));
        }
        DdlOperationKey op = new DdlOperationKey((DeObject)das, this.getOperation());
        builder.removeOperation(op).removeDependencies(op, (Iterable<DdlOperationKey>)this.getDependencies(das, data)).removeDependencies((Iterable<DdlOperationKey>)this.getDependants(das, data), op);
        DdlGenerator ddlGenerator = generator;
        if (ddlGenerator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "removeFromBuilder"));
        }
        return ddlGenerator;
    }

    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull T object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "generate"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "generate"));
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "generate"));
        }
        return ddlBuilder;
    }

    @NotNull
    public JBIterable<DdlOperationKey> getDependencies(@NotNull T object, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "getDependencies"));
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "getDependencies"));
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<DdlOperationKey> getDependants(@NotNull T object, @Nullable UserDataHolder data) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "getDependants"));
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/generation/DdlOperationGenerator", "getDependants"));
        }
        return jBIterable;
    }
}

