/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.operations;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.generation.DdlBuildingContext;
import com.intellij.database.schemaEditor.generation.DdlGraph;
import com.intellij.database.schemaEditor.model.DeRoutine;
import com.intellij.database.schemaEditor.operations.DasDdlOperations;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.lang.Language;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateDropRoutineOperation
extends DasDdlOperations.DdlOperationGeneratorSimple<DeRoutine> {
    private static final Key<Pair<String, Boolean>> ROUTINE_SOURCE = Key.create((String)"ROUTINE_SOURCE");

    public CreateDropRoutineOperation() {
        super(DasDdlOperations.ALTER_ROUTINE, DeRoutine.class, ObjectKind.ROUTINE);
    }

    @Override
    @NotNull
    public DdlBuilder generate(@NotNull DdlBuilder builder, @NotNull DeRoutine object, @Nullable UserDataHolder data, @NotNull DdlBuildingContext context) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "generate"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "generate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "generate"));
        }
        assert (data != null);
        DeRoutine to = (DeRoutine)ObjectUtils.assertNotNull((Object)DdlGraph.ALTER_TO.get(data));
        if (Comparing.equal((String)to.getName(), (String)object.getName())) {
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "generate"));
            }
            return ddlBuilder;
        }
        Pair<String, Boolean> sources = CreateDropRoutineOperation.getSources(object, context);
        if (sources.second == null) {
            builder.comment("Retrieving definition in progress\n");
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "generate"));
            }
            return ddlBuilder;
        }
        if (sources.second == Boolean.FALSE) {
            builder.comment("Failed to retrieve definition\n");
            if (sources.first != null) {
                builder.comment((String)sources.first + "\n");
            }
            DdlBuilder ddlBuilder = builder;
            if (ddlBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "generate"));
            }
            return ddlBuilder;
        }
        String renamed = CreateDropRoutineOperation.renameRoutine((String)sources.first, object.name, to.name, context.getContext());
        if (renamed == null) {
            builder.comment("Failed to rename routine. Do it yourself.");
            builder.plain((String)sources.first);
        } else {
            builder.plain(renamed);
        }
        DbImplUtil.endStatement(builder);
        context.getContext().getDialect().sqlDropProcedure(builder, object);
        DbImplUtil.endStatement(builder);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "generate"));
        }
        return ddlBuilder;
    }

    @Nullable
    private static String renameRoutine(@NotNull String text, @NotNull String oldName, @NotNull String newName, @NotNull DatabaseEditorContext context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "renameRoutine"));
        }
        if (oldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldName", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "renameRoutine"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "renameRoutine"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "renameRoutine"));
        }
        SqlLanguageDialect dialect = DbImplUtil.getSqlDialect(context.getDialect());
        SqlFile file = (SqlFile)ObjectUtils.tryCast((Object)PsiFileFactory.getInstance((Project)context.getProject()).createFileFromText((Language)dialect, (CharSequence)text), SqlFile.class);
        if (file == null) {
            return null;
        }
        SqlDefinition first = (SqlDefinition)((JBTreeTraverser)file.traverser().expandAndSkip(Conditions.not((Condition)DasUtil.byKind((ObjectKind)ObjectKind.ROUTINE)))).filter(SqlDefinition.class).filter(DasUtil.byKind((ObjectKind)ObjectKind.ROUTINE)).filter(DasUtil.byName((String)oldName)).first();
        if (first == null) {
            return null;
        }
        Collection refs = ReferencesSearch.search((PsiElement)first, (SearchScope)new LocalSearchScope((PsiElement)file)).findAll();
        WriteCommandAction.runWriteCommandAction((Project)context.getProject(), null, null, () -> {
            if (newName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "lambda$renameRoutine$0"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "lambda$renameRoutine$0"));
            }
            for (PsiReference ref : refs) {
                SqlReferenceExpression expression = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getElement(), SqlReferenceExpression.class);
                if (expression == null) continue;
                expression.setName(newName);
            }
            first.setName(newName);
            if (context.getDialect().getFamilyId().isHsqldb()) {
                CreateDropRoutineOperation.removeSpecificClause(first);
            }
        }, (PsiFile[])new PsiFile[]{file});
        return first.getText();
    }

    private static void removeSpecificClause(@NotNull SqlDefinition def) {
        if (def == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "def", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "removeSpecificClause"));
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        for (SqlClause clause : api.children((Object)def).filter(SqlClause.class)) {
            if (!clause.getFirstChild().getText().equalsIgnoreCase("specific")) continue;
            clause.delete();
        }
    }

    @NotNull
    private static Pair<String, Boolean> getSources(@NotNull DeRoutine routine2, @NotNull DdlBuildingContext context) {
        if (routine2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "getSources"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "getSources"));
        }
        DatabaseDialectEx dialect = context.getContext().getDialect();
        Pair src = (Pair)ROUTINE_SOURCE.get(routine2.flags);
        if (src != null) {
            Pair pair = src;
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "getSources"));
            }
            return pair;
        }
        if (!dialect.supportsProcedureDefinition()) {
            throw new AssertionError((Object)("Dialect " + dialect.getDisplayName() + " does not support sources"));
        }
        src = Pair.create(null, null);
        ROUTINE_SOURCE.set(routine2.flags, (Object)src);
        Ref ref = Ref.create((Object)src);
        context.process(() -> {
            if (routine2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "lambda$getSources$1"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "lambda$getSources$1"));
            }
            ref.set(CreateDropRoutineOperation.tryLoadProcedure(routine2, context));
        }).doWhenDone(() -> {
            if (routine2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "lambda$getSources$2"));
            }
            ROUTINE_SOURCE.set(routine2.flags, ref.get());
        }).doWhenRejected(() -> {
            if (routine2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "lambda$getSources$3"));
            }
            ROUTINE_SOURCE.set(routine2.flags, null);
        });
        Pair pair = (Pair)ref.get();
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "getSources"));
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Pair<String, Boolean> tryLoadProcedure(@NotNull DeRoutine routine2, @NotNull DdlBuildingContext context) {
        Pair pair;
        ConnectionProvider provider;
        block19: {
            Pair pair2;
            block18: {
                if (routine2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routine", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "tryLoadProcedure"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "tryLoadProcedure"));
                }
                DatabaseDialectEx dialect = context.getContext().getDialect();
                SqlElement elem = DbRenamePsiElementProcessor.getElementOfType(routine2, SqlElement.class);
                if (elem instanceof SqlCreateProcedureStatement) {
                    Pair pair3 = Pair.create((Object)elem.getText(), (Object)Boolean.TRUE);
                    if (pair3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "tryLoadProcedure"));
                    }
                    return pair3;
                }
                DbDataSource source = context.getContext().getDataSource();
                if (source == null) {
                    Pair pair4 = Pair.create((Object)"No database connection", (Object)Boolean.FALSE);
                    if (pair4 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "tryLoadProcedure"));
                    }
                    return pair4;
                }
                provider = ConnectionProvider.forElement((DbElement)source);
                try {
                    if (!provider.acquire()) {
                        Pair pair5 = Pair.create((Object)"No database connection", (Object)Boolean.FALSE);
                        pair2 = pair5;
                        break block18;
                    }
                    String def = dialect.tryToLoadProcedureDefinition(routine2, provider.getConnection());
                    if (StringUtil.isEmpty((String)def)) {
                        Pair<String, DbImplUtil.ConcatenationProps> query = dialect.sqlProcedureDefinition(routine2);
                        def = DbImplUtil.concatStringResults(provider.getConnection(), dialect, (String)query.first, 0, new StringBuilder(), (DbImplUtil.ConcatenationProps)query.second).toString();
                    }
                    if (StringUtil.isNotEmpty((String)def)) {
                        def = StringUtil.convertLineSeparators((String)def);
                    }
                    Pair pair6 = Pair.create((Object)def, (Object)Boolean.TRUE);
                    pair = pair6;
                    break block19;
                }
                catch (Exception e) {
                    Pair pair7 = Pair.create((Object)e.getMessage(), (Object)Boolean.FALSE);
                    Pair pair8 = pair7;
                    if (pair8 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "tryLoadProcedure"));
                    }
                    return pair8;
                }
            }
            if (pair2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "tryLoadProcedure"));
            }
            return pair2;
        }
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/operations/CreateDropRoutineOperation", "tryLoadProcedure"));
        }
        return pair;
        finally {
            provider.release();
        }
    }
}

