/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.scripting;

import com.intellij.database.scripting.NamingService;
import com.intellij.database.scripting.ScriptingUtilsKt;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/database/scripting/AbstractNamingService;", "Lcom/intellij/database/scripting/NamingService;", "()V", "aptNamePattern", "Ljava/util/regex/Pattern;", "getAptNamePattern", "()Ljava/util/regex/Pattern;", "reservedWords", "Ljava/util/NavigableSet;", "", "getReservedWords", "()Ljava/util/NavigableSet;", "enquoteName", "name", "nameToScript", "database-scripting"})
public abstract class AbstractNamingService
implements NamingService {
    @NotNull
    private final NavigableSet<String> reservedWords;

    @NotNull
    public NavigableSet<String> getReservedWords() {
        return this.reservedWords;
    }

    @Override
    @NotNull
    public String nameToScript(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return ScriptingUtilsKt.matches(name, this.getAptNamePattern()) && this.getReservedWords().contains(name) ^ true ? name : this.enquoteName(name);
    }

    @NotNull
    public String enquoteName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        char c = '\"';
        String string = StringsKt.replace$default((String)name, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = String.valueOf(c) + string;
        return stringBuilder.append(string2).append('\"').toString();
    }

    @NotNull
    public abstract Pattern getAptNamePattern();

    public AbstractNamingService() {
        NavigableSet navigableSet = Collections.emptyNavigableSet();
        Intrinsics.checkExpressionValueIsNotNull(navigableSet, (String)"Collections.emptyNavigableSet()");
        this.reservedWords = navigableSet;
    }
}

