/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.TokenPattern;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.JBIterable;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TokenPatternCache {
    private static final Pattern ourSplitter = Pattern.compile("[\\s,]+");
    private final DatabaseSettings mySettings;
    private final ConcurrentFactoryMap<Pair<Boolean, Language>, TokenPattern> myCache1;
    private final ConcurrentFactoryMap<String, TokenPattern> myCache2;
    private final ConcurrentFactoryMap<String, Boolean> myValidityCache;

    @Nullable
    public static TokenPattern getPattern(@NotNull DatabaseSettings settings, boolean injected, @Nullable Language language) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/util/TokenPatternCache", "getPattern"));
        }
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            TokenPattern pattern = settings.patternCache.getPattern((Pair<Boolean, Language>)Pair.create((Object)injected, (Object)l));
            if (pattern == null) continue;
            return pattern;
        }
        return settings.patternCache.getPattern((Pair<Boolean, Language>)Pair.create((Object)injected, (Object)Language.ANY));
    }

    @Nullable
    public static String getPatternError(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/util/TokenPatternCache", "getPatternError"));
        }
        try {
            new TokenPattern(pattern);
            return null;
        }
        catch (PatternSyntaxException e) {
            return e.getMessage();
        }
    }

    public TokenPatternCache(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/util/TokenPatternCache", "<init>"));
        }
        this.myCache1 = new ConcurrentFactoryMap<Pair<Boolean, Language>, TokenPattern>(){

            @Nullable
            protected TokenPattern create(Pair<Boolean, Language> key) {
                return TokenPatternCache.this.createPattern((Pair<Boolean, Language>)key);
            }
        };
        this.myCache2 = new ConcurrentFactoryMap<String, TokenPattern>(){

            @Nullable
            protected TokenPattern create(String key) {
                return TokenPatternCache.compilePattern(key);
            }
        };
        this.myValidityCache = new ConcurrentFactoryMap<String, Boolean>(){

            @Nullable
            protected Boolean create(String key) {
                return TokenPatternCache.getPatternError(key) == null;
            }
        };
        this.mySettings = settings;
    }

    public void clear() {
        this.myCache1.clear();
        this.myCache2.clear();
        this.myValidityCache.clear();
    }

    public TokenPattern getPattern(@NotNull Pair<Boolean, Language> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/util/TokenPatternCache", "getPattern"));
        }
        return (TokenPattern)this.myCache1.get(key);
    }

    @Nullable
    private TokenPattern createPattern(Pair<Boolean, Language> key) {
        JBIterable p;
        DatabaseSettings.UserPatterns userPatterns = this.mySettings.getUserPatterns();
        JBIterable jBIterable = p = PlatformUtils.isDatabaseIDE() ? JBIterable.empty() : JBIterable.from(DatabaseSettings.HARDCODED_PATTERNS);
        if ((Boolean)key.first != false ? userPatterns.inLiterals : userPatterns.inScripts) {
            p = p.append(userPatterns.patterns);
        }
        return this.createPattern((Iterable<DatabaseSettings.ParameterPattern>)p, (Boolean)key.first, (Language)key.second);
    }

    @Nullable
    private TokenPattern createPattern(Iterable<DatabaseSettings.ParameterPattern> patterns, boolean injected, Language language) {
        StringBuilder sb = new StringBuilder();
        for (DatabaseSettings.ParameterPattern p : patterns) {
            if (!(injected ? p.inLiterals : p.inScripts) || StringUtil.isEmptyOrSpaces((String)p.pattern) || this.myValidityCache.get((Object)p.pattern) != Boolean.TRUE) continue;
            int decisionLevel = -1;
            boolean addThisOne = false;
            String adjustedScope = StringUtil.notNullize((String)StringUtil.nullize((String)p.scope, (boolean)true), (String)"*");
            for (String s : ourSplitter.split(adjustedScope)) {
                boolean exclude = s.startsWith("-");
                String id = exclude ? s.substring(1) : s;
                int level = 0;
                Language l = language;
                while (l != null) {
                    if (("*".equals(id) && l == Language.ANY || id.equals(l.getID())) && (decisionLevel < 0 || decisionLevel > level)) {
                        addThisOne = !exclude;
                        decisionLevel = level;
                    }
                    ++level;
                    l = l == Language.ANY ? null : (Language)ObjectUtils.notNull((Object)l.getBaseLanguage(), (Object)Language.ANY);
                }
            }
            if (!addThisOne) continue;
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(p.pattern);
        }
        if (sb.length() == 0) {
            return null;
        }
        return (TokenPattern)this.myCache2.get((Object)sb.toString());
    }

    @Nullable
    private static TokenPattern compilePattern(@NotNull String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/database/util/TokenPatternCache", "compilePattern"));
        }
        try {
            return new TokenPattern(pattern);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
    }
}

