/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.editors.DatabaseEditorBase;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.database.view.models.ObjectEditorModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseEditorBaseEx
extends DatabaseEditorBase {
    private final EventDispatcher<EditorModelBase.Listener> myDispatcher;
    protected final Alarm myAlarm;
    private static final Set<Alarm> ALARMS = ContainerUtil.newHashSet();

    public DatabaseEditorBaseEx(@NotNull DatabaseEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/view/editors/DatabaseEditorBaseEx", "<init>"));
        }
        super(state);
        this.myDispatcher = EventDispatcher.create(EditorModelBase.Listener.class);
        this.myAlarm = new Alarm((Disposable)this);
        ALARMS.add(this.myAlarm);
    }

    @Override
    public void dispose() {
        super.dispose();
        ALARMS.remove(this.myAlarm);
    }

    protected void runLater(@NotNull Runnable r) {
        if (r == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/view/editors/DatabaseEditorBaseEx", "runLater"));
        }
        ModalityState state = ModalityState.defaultModalityState();
        Runnable newRunnable = r;
        if (state == ModalityState.NON_MODAL) {
            newRunnable = () -> {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/view/editors/DatabaseEditorBaseEx", "lambda$runLater$0"));
                }
                ApplicationManager.getApplication().invokeLater(r);
            };
            state = ModalityState.any();
        }
        this.myAlarm.addRequest(newRunnable, 1, state);
    }

    protected void fromModelToUi() {
        this.markInvalid();
        this.runLater(() -> {
            try {
                this.updateFromModel();
            }
            finally {
                this.markValid();
            }
            ((EditorModelBase.Listener)this.myDispatcher.getMulticaster()).changed();
        });
    }

    public void addListener(@NotNull EditorModelBase.Listener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/view/editors/DatabaseEditorBaseEx", "addListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/view/editors/DatabaseEditorBaseEx", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener, parent);
    }

    public static void flushDelayed() {
        HashSet visited = ContainerUtil.newHashSet();
        while (true) {
            Alarm item = null;
            for (Alarm alarm : ALARMS) {
                if (visited.contains(alarm)) continue;
                item = alarm;
                visited.add(item);
                break;
            }
            if (item == null) break;
            item.flush();
        }
    }

    @Nullable
    public DeObject getKeyObject() {
        EditorModelBase model = this.getModel();
        return model instanceof ObjectEditorModel ? (DeObject)((ObjectEditorModel)model).getObject() : null;
    }

    public static boolean isGood(@Nullable DeColumn object) {
        return !EditorModelUtil.isStub(object) && object.isInTable();
    }
}

