/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.util.DbUIUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashSet;
import java.awt.AWTEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FilteringTree<T extends DefaultMutableTreeNode, U> {
    public static final SpeedSearchSupply DUMMY_SEARCH = new SpeedSearchSupply(){

        @Nullable
        public Iterable<TextRange> matchingFragments(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/view/ui/FilteringTree$1", "matchingFragments"));
            }
            return null;
        }

        public void refreshSelection() {
        }

        public boolean isPopupActive() {
            return false;
        }

        public void addChangeListener(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/view/ui/FilteringTree$1", "addChangeListener"));
            }
        }

        public void removeChangeListener(@NotNull PropertyChangeListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/view/ui/FilteringTree$1", "removeChangeListener"));
            }
        }

        public void findAndSelectElement(@NotNull String searchQuery) {
            if (searchQuery == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchQuery", "com/intellij/database/view/ui/FilteringTree$1", "findAndSelectElement"));
            }
        }
    };
    private final Project myProject;
    private final T myRoot;
    private final Tree myTree;

    public FilteringTree(@NotNull Project project, @NotNull Tree tree, @NotNull T root2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/view/ui/FilteringTree", "<init>"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/database/view/ui/FilteringTree", "<init>"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/view/ui/FilteringTree", "<init>"));
        }
        this.myProject = project;
        this.myRoot = root2;
        this.myTree = tree;
        this.myTree.setModel(new SearchTreeModel(this.myRoot, DUMMY_SEARCH, o -> this.getText(o), this::createNode, this::getChildren));
        this.rebuildTree();
    }

    @NotNull
    public SearchTextField installSearchField() {
        SearchTextField field = new SearchTextField(false){

            protected boolean preprocessEventForTextField(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                    FilteringTree.this.myTree.dispatchEvent((AWTEvent)e);
                    return true;
                }
                if (e.getKeyCode() == 27 && this.getText().isEmpty()) {
                    UIUtil.requestFocus((JComponent)FilteringTree.this.myTree);
                    return true;
                }
                return false;
            }
        };
        MySpeedSearch speedSearch = new MySpeedSearch<T>((JComponent)this.myTree, (JTextComponent)field.getTextEditor()){

            @Override
            protected void onSearchFieldUpdated(String pattern) {
                TreePath[] paths = FilteringTree.this.myTree.getSelectionModel().getSelectionPaths();
                FilteringTree.this.getSearchModel().refilter();
                FilteringTree.this.myTree.getSelectionModel().setSelectionPaths(paths);
            }

            @Override
            public void select(@NotNull T node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/view/ui/FilteringTree$3", "select"));
                }
                TreeUtil.selectInTree(node, (boolean)false, (JTree)FilteringTree.this.myTree);
            }

            @Override
            public boolean isMatching(@NotNull T node) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/view/ui/FilteringTree$3", "isMatching"));
                }
                String text = FilteringTree.this.getText(FilteringTree.this.getUserObject((TreeNode)node));
                return text != null && this.matchingFragments(text) != null;
            }

            @Override
            @Nullable
            public T getSelection() {
                return (DefaultMutableTreeNode)ArrayUtil.getFirstElement((Object[])FilteringTree.this.myTree.getSelectedNodes(FilteringTree.this.getNodeClass(), null));
            }

            @Override
            @NotNull
            public Iterator<T> iterate(@Nullable T start, boolean fwd) {
                JBTreeTraverser traverser = (JBTreeTraverser)new JBTreeTraverser(n -> {
                    int count = n.getChildCount();
                    ArrayList children = ContainerUtil.newArrayListWithCapacity((int)count);
                    for (int i2 = 0; i2 < count; ++i2) {
                        DefaultMutableTreeNode c = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)n.getChildAt(fwd ? i2 : count - i2 - 1), FilteringTree.this.getNodeClass());
                        if (c == null) continue;
                        children.add(c);
                    }
                    return children;
                }).expand(Conditions.alwaysTrue());
                if (start == null) {
                    traverser = (JBTreeTraverser)traverser.withRoot(FilteringTree.this.getRoot());
                } else {
                    ArrayList roots = ContainerUtil.newArrayList();
                    TreeNode node = null;
                    Object parent = start;
                    while (parent != null) {
                        int c;
                        int idx = node == null ? -1 : parent.getIndex(node);
                        int n2 = c = fwd ? parent.getChildCount() : idx;
                        for (int i2 = fwd ? idx + 1 : 0; i2 < c; ++i2) {
                            DefaultMutableTreeNode child = (DefaultMutableTreeNode)ObjectUtils.tryCast((Object)parent.getChildAt(fwd ? i2 : idx - i2 - 1), FilteringTree.this.getNodeClass());
                            if (child == null) continue;
                            roots.add(child);
                        }
                        node = (TreeNode)parent;
                        parent = node.getParent();
                    }
                    traverser = (JBTreeTraverser)traverser.withRoots((Iterable)roots);
                }
                Iterator iterator = traverser.preOrderDfsTraversal().iterator();
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$3", "iterate"));
                }
                return iterator;
            }
        };
        this.getSearchModel().setSpeedSearch((SpeedSearchSupply)speedSearch);
        SearchTextField searchTextField = field;
        if (searchTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree", "installSearchField"));
        }
        return searchTextField;
    }

    public void installSimple() {
        TreeSpeedSearch supply = new TreeSpeedSearch(this.myTree, p -> StringUtil.notNullize((String)this.getText(p == null ? null : (U)this.getUserObject((TreeNode)p.getLastPathComponent()))), true){

            protected void onSearchFieldUpdated(String pattern) {
                if (StringUtil.isEmpty((String)pattern)) {
                    this.hidePopup();
                }
                if (StringUtil.isNotEmpty((String)pattern) && !this.isPopupActive()) {
                    DbUIUtil.invokeLater(FilteringTree.this.getSearchModel()::refilter);
                } else {
                    FilteringTree.this.getSearchModel().refilter();
                }
            }
        };
        this.getSearchModel().setSpeedSearch((SpeedSearchSupply)supply);
    }

    protected abstract Class<? extends T> getNodeClass();

    @NotNull
    protected abstract T createNode(@NotNull U var1);

    @NotNull
    protected abstract Iterable<U> getChildren(@NotNull U var1);

    @NotNull
    public Tree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree", "getTree"));
        }
        return tree;
    }

    @NotNull
    public JComponent getComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree", "getComponent"));
        }
        return tree;
    }

    protected void rebuildTree() {
    }

    @Nullable
    protected abstract String getText(@Nullable U var1);

    @NotNull
    public SearchTreeModel<T, U> getSearchModel() {
        SearchTreeModel searchTreeModel = (SearchTreeModel)this.myTree.getModel();
        if (searchTreeModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree", "getSearchModel"));
        }
        return searchTreeModel;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree", "getProject"));
        }
        return project;
    }

    @NotNull
    public T getRoot() {
        T t = this.myRoot;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree", "getRoot"));
        }
        return t;
    }

    public void update() {
        this.rebuildTree();
        this.myTree.revalidate();
        this.myTree.repaint();
    }

    @Nullable
    public final U getUserObject(@Nullable TreeNode node) {
        return (U)(node == null || !this.getNodeClass().isAssignableFrom(node.getClass()) ? null : ((DefaultMutableTreeNode)node).getUserObject());
    }

    private static class MySpeedSearch<Item>
    extends SpeedSearch {
        private boolean myUpdating;
        private final JTextComponent myField;

        public MySpeedSearch(@NotNull JComponent comp, @NotNull JTextComponent field) {
            if (comp == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comp", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "<init>"));
            }
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "<init>"));
            }
            this.myUpdating = false;
            this.myField = field;
            this.myField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    if (!myUpdating) {
                        myUpdating = true;
                        try {
                            this.updatePattern(myField.getText());
                            this.update();
                        }
                        finally {
                            myUpdating = false;
                        }
                    }
                }
            });
            this.setEnabled(true);
            comp.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (this.selectTargetElement(e.getKeyCode())) {
                        e.consume();
                        return;
                    }
                    if ((e.getModifiers() & 8) == 0) {
                        this.process(e);
                    }
                }
            });
            this.installSupplyTo(comp);
        }

        public void update() {
            String filter = this.getFilter();
            if (!this.myUpdating) {
                this.myUpdating = true;
                try {
                    this.myField.setText(filter);
                }
                finally {
                    this.myUpdating = false;
                }
            }
            this.onSearchFieldUpdated(filter);
            this.updateSelection();
        }

        public void noHits() {
            this.myField.setBackground(LightColors.RED);
        }

        public void updateSelection() {
            Item selection = this.getSelection();
            if (selection != null && this.isMatching(selection)) {
                return;
            }
            JBIterator it = JBIterator.from(this.iterate(selection, true, true)).filter(item -> item != selection && this.isMatching(item));
            if (!it.advance()) {
                return;
            }
            this.select(it.current());
        }

        protected void onSearchFieldUpdated(String pattern) {
        }

        public void select(@NotNull Item item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "select"));
            }
        }

        @Nullable
        public Item getSelection() {
            return null;
        }

        public boolean isMatching(@NotNull Item item) {
            if (item == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "isMatching"));
            }
            return false;
        }

        @NotNull
        public Iterator<Item> iterate(@Nullable Item start, boolean fwd) {
            JBIterator jBIterator = new JBIterator<Item>(){

                protected Item nextImpl() {
                    return this.stop();
                }
            };
            if (jBIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "iterate"));
            }
            return jBIterator;
        }

        @NotNull
        public Iterator<Item> iterate(final @Nullable Item start, final boolean fwd, boolean wrap) {
            if (!wrap || start == null) {
                Iterator<Item> iterator = this.iterate(start, fwd);
                if (iterator == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "iterate"));
                }
                return iterator;
            }
            JBIterator jBIterator = new JBIterator<Item>(){
                boolean wrapped = false;
                Iterator<Item> it = this.iterate(start, fwd);

                protected Item nextImpl() {
                    if (this.it.hasNext()) {
                        return this.it.next();
                    }
                    if (this.wrapped) {
                        return this.stop();
                    }
                    this.wrapped = true;
                    this.it = JBIterator.from(this.iterate(null, fwd)).takeWhile(item -> item != start);
                    return this.it.hasNext() ? this.it.next() : this.stop();
                }
            };
            if (jBIterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$MySpeedSearch", "iterate"));
            }
            return jBIterator;
        }

        private boolean selectTargetElement(int keyCode) {
            JBIterator it;
            if (!this.isPopupActive()) {
                return false;
            }
            if (keyCode == 38) {
                it = this.iterate(this.getSelection(), false, UISettings.getInstance().getCycleScrolling());
            } else if (keyCode == 40) {
                it = this.iterate(this.getSelection(), true, UISettings.getInstance().getCycleScrolling());
            } else if (keyCode == 36) {
                it = this.iterate(null, true);
            } else if (keyCode == 35) {
                it = this.iterate(null, false);
            } else {
                return false;
            }
            it = JBIterator.from(it).filter(item -> this.isMatching(item));
            if (it.hasNext()) {
                this.select(it.next());
            }
            return true;
        }
    }

    public static class SearchTreeModel<N extends DefaultMutableTreeNode, U>
    extends DefaultTreeModel {
        private final Function<U, String> myNamer;
        private final Function<U, N> myFactory;
        private final U myRootObject;
        private final Function<U, Iterable<U>> myStructure;
        private SpeedSearchSupply mySpeedSearch;
        private Map<U, N> myNodeCache;
        private final EventDispatcher<Listener<U>> myNodeChanged;

        public SearchTreeModel(@NotNull N root2, @NotNull SpeedSearchSupply speedSearch, @NotNull Function<U, String> namer, @NotNull Function<U, N> nodeFactory, @NotNull Function<U, Iterable<U>> structure) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "<init>"));
            }
            if (speedSearch == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "speedSearch", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "<init>"));
            }
            if (namer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namer", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "<init>"));
            }
            if (nodeFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeFactory", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "<init>"));
            }
            if (structure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "structure", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "<init>"));
            }
            super((TreeNode)root2);
            this.myNodeCache = ContainerUtil.newIdentityHashMap();
            this.myNodeChanged = EventDispatcher.create(Listener.class);
            this.myRootObject = ObjectUtils.assertNotNull(this.getUserObject(root2));
            this.mySpeedSearch = speedSearch;
            this.myNamer = namer;
            this.myFactory = nodeFactory;
            this.myStructure = structure;
            this.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                    Object object = this.getUserObject((DefaultMutableTreeNode)e.getTreePath().getLastPathComponent());
                    if (object != null) {
                        ((Listener)myNodeChanged.getMulticaster()).nodeChanged(object);
                    }
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                }
            });
        }

        public void modifyNode(@NotNull U object, @NotNull Runnable r) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "modifyNode"));
            }
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "modifyNode"));
            }
            ((Listener)this.myNodeChanged.getMulticaster()).beforeNodeChanged(object);
            try {
                r.run();
            }
            finally {
                ((Listener)this.myNodeChanged.getMulticaster()).nodeChanged(object);
            }
        }

        public void setSpeedSearch(@NotNull SpeedSearchSupply supply) {
            if (supply == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supply", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "setSpeedSearch"));
            }
            this.mySpeedSearch = supply;
            this.updateStructure();
        }

        public void addNodeListener(@NotNull Listener<U> listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "addNodeListener"));
            }
            this.myNodeChanged.addListener(listener);
        }

        public void updateStructure() {
            IdentityHashMap newNodes = ContainerUtil.newIdentityHashMap();
            Iterator iterator = ((JBTreeTraverser)new JBTreeTraverser(this.myStructure).withRoot(this.getRootObject())).iterator();
            while (iterator.hasNext()) {
                Object node;
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)this.myNodeCache.get(node = iterator.next());
                newNodes.put(node, treeNode == null ? this.createNode(node) : treeNode);
            }
            ArrayList oldNodes = ContainerUtil.newArrayList();
            for (Map.Entry<U, N> entry : this.myNodeCache.entrySet()) {
                if (newNodes.containsKey(entry.getKey())) continue;
                oldNodes.add(entry.getValue());
            }
            this.myNodeCache = newNodes;
            for (DefaultMutableTreeNode node : oldNodes) {
                if (node.getParent() == null) continue;
                this.removeNodeFromParent(node);
            }
            this.refilter();
        }

        public N getRoot() {
            return (N)((DefaultMutableTreeNode)this.root);
        }

        @NotNull
        public U getRootObject() {
            U u = this.myRootObject;
            if (u == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getRootObject"));
            }
            return u;
        }

        @NotNull
        public N getNode(@NotNull U object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getNode"));
            }
            N node = this.getCachedNode(object);
            if (node == null) {
                node = this.createNode(object);
                this.myNodeCache.put(object, node);
            }
            N n = node;
            if (n == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getNode"));
            }
            return n;
        }

        @Nullable
        public N getCachedNode(@Nullable U object) {
            if (object == null) {
                return null;
            }
            if (object == this.myRootObject) {
                return (N)this.getRoot();
            }
            return (N)((DefaultMutableTreeNode)this.myNodeCache.get(object));
        }

        @NotNull
        protected N createNode(@NotNull U object) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "createNode"));
            }
            assert (!(object instanceof DefaultMutableTreeNode));
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.myFactory.fun(object);
            if (defaultMutableTreeNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "createNode"));
            }
            return (N)defaultMutableTreeNode;
        }

        public void refilter() {
            if (this.mySpeedSearch.isPopupActive()) {
                THashSet acceptCache = ContainerUtil.newIdentityTroveSet();
                this.computeAcceptCache(this.myRootObject, (Set<U>)acceptCache);
                this.filterChildren(this.myRootObject, arg_0 -> SearchTreeModel.lambda$refilter$0((Set)acceptCache, arg_0));
            } else {
                this.filterChildren(this.myRootObject, x -> true);
            }
        }

        private boolean computeAcceptCache(@NotNull U object, @NotNull Set<U> cache) {
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "computeAcceptCache"));
            }
            if (cache == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "computeAcceptCache"));
            }
            boolean isAccepted = false;
            Iterable<U> children = this.getChildren(object);
            for (U child : children) {
                isAccepted |= this.computeAcceptCache(child, cache);
            }
            String name = (String)this.myNamer.fun(object);
            if (isAccepted |= object == this.myRootObject || name != null && this.accept(name)) {
                for (U child : children) {
                    if (this.myNamer.fun(child) != null) continue;
                    cache.add(child);
                }
                cache.add(object);
            }
            return isAccepted;
        }

        @NotNull
        public Iterable<U> getChildren(@Nullable U object) {
            Object object2 = object == null ? JBIterable.empty() : (Iterable)this.myStructure.fun(object);
            if (object2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getChildren"));
            }
            return object2;
        }

        @NotNull
        public Function<U, Iterable<U>> getStructure() {
            Function<U, Iterable<U>> function = this.myStructure;
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getStructure"));
            }
            return function;
        }

        @Nullable
        private static <N extends DefaultMutableTreeNode> N getChildSafe(@NotNull N node, int i2) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getChildSafe"));
            }
            return node.getChildCount() <= i2 ? null : (N)SearchTreeModel.getChild(node, i2);
        }

        private static <N extends DefaultMutableTreeNode> N getChild(@NotNull N node, int i2) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "getChild"));
            }
            return (N)((DefaultMutableTreeNode)node.getChildAt(i2));
        }

        private void filterChildren(@Nullable U object, @NotNull Condition<U> filter) {
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "filterChildren"));
            }
            if (object == null) {
                return;
            }
            N node = this.getNode(object);
            this.filterDirectChildren(node, filter);
            int c = ((DefaultMutableTreeNode)node).getChildCount();
            for (int i2 = 0; i2 < c; ++i2) {
                this.filterChildren(this.getUserObject(SearchTreeModel.getChild(node, i2)), filter);
            }
        }

        private void filterDirectChildren(@NotNull N node, @NotNull Condition<U> filter) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "filterDirectChildren"));
            }
            if (filter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/database/view/ui/FilteringTree$SearchTreeModel", "filterDirectChildren"));
            }
            int k = 0;
            N cur = SearchTreeModel.getChildSafe(node, 0);
            for (U child : this.getChildren(this.getUserObject(node))) {
                boolean isCur;
                boolean accepted = filter.value(child);
                boolean bl = isCur = cur != null && this.getUserObject(cur) == child;
                if (accepted) {
                    if (!isCur) {
                        N childNode = this.getNode(child);
                        if (((DefaultMutableTreeNode)childNode).getParent() != null) {
                            this.removeNodeFromParent((MutableTreeNode)childNode);
                        }
                        this.insertNodeInto((MutableTreeNode)childNode, (MutableTreeNode)node, k);
                    } else {
                        cur = SearchTreeModel.getChildSafe(node, k + 1);
                    }
                    ++k;
                    continue;
                }
                if (!isCur) continue;
                this.removeNodeFromParent((MutableTreeNode)cur);
                cur = SearchTreeModel.getChildSafe(node, k);
            }
            if (((DefaultMutableTreeNode)node).getChildCount() > k) {
                for (int i2 = ((DefaultMutableTreeNode)node).getChildCount() - 1; i2 >= k; --i2) {
                    this.removeNodeFromParent((MutableTreeNode)SearchTreeModel.getChild(node, i2));
                }
            }
        }

        protected boolean accept(@Nullable String name) {
            if (name == null) {
                return true;
            }
            return this.mySpeedSearch.matchingFragments(name) != null;
        }

        @Override
        public boolean isLeaf(Object node) {
            return this.getRoot() != node && super.isLeaf(node);
        }

        @Nullable
        public final U getUserObject(@Nullable N node) {
            return (U)(node == null ? null : ((DefaultMutableTreeNode)node).getUserObject());
        }

        private static /* synthetic */ boolean lambda$refilter$0(Set acceptCache, Object x) {
            return acceptCache.contains(x);
        }

        public static interface Listener<U>
        extends EventListener {
            public void beforeNodeChanged(U var1);

            public void nodeChanged(U var1);
        }
    }
}

