/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIdentifiedElement;
import com.intellij.database.model.families.ModIdentifyingFamily;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TLongHashSet;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.util.Version;

public abstract class IntrospectionUtil {
    public static void removeDroppedChildren(TLongHashSet existentIds, ModIdentifyingFamily<? extends BasicModIdentifiedElement> ... families) {
        ArrayList<BasicModIdentifiedElement> objectsToRemove = new ArrayList<BasicModIdentifiedElement>();
        for (ModIdentifyingFamily<? extends BasicModIdentifiedElement> family : families) {
            for (BasicModIdentifiedElement basicModIdentifiedElement : family) {
                long id = basicModIdentifiedElement.getObjectId();
                if (existentIds.contains(id)) continue;
                objectsToRemove.add(basicModIdentifiedElement);
            }
        }
        for (int i2 = objectsToRemove.size() - 1; i2 >= 0; --i2) {
            BasicModElement objectToRemove = (BasicModElement)objectsToRemove.get(i2);
            objectToRemove.drop();
        }
    }

    @Contract(value="null,_ -> false", pure=true)
    public static <K> boolean containsKey(@Nullable MultiMap<K, ?> map, @NotNull K key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/dbm/common/IntrospectionUtil", "containsKey"));
        }
        return map != null && map.containsKey(key);
    }

    public static void setMajorVersionParameters(Version version, int min, Map<String, ? super Boolean> parameters) {
        int verMajor = version.get(0);
        for (int v = min; v <= verMajor; ++v) {
            parameters.put("V" + v, Boolean.TRUE);
        }
    }

    public static void setOracleFastSlowModeParameters(boolean fast, @NotNull Map<String, Object> parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/dbm/common/IntrospectionUtil", "setOracleFastSlowModeParameters"));
        }
        parameters.put(fast ? "FAST" : "SLOW", Boolean.TRUE);
        parameters.put("CAT", fast ? "sys.dba" : "sys.all");
    }
}

