/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dataSource.AbstractDataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceNameComponent;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbUtil;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.database.SqlDataSourceImpl;
import com.intellij.sql.database.SqlDbManager;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDataSourceConfigurable
extends AbstractDataSourceConfigurable<SqlDbManager, SqlDataSourceImpl> {
    private JPanel myRootPanel;
    private JPanel myNamePanel;
    private JPanel myDdlListPanel;
    private ComboBox myParentCombo;
    private DataSourceNameComponent myNameComponent;
    private JList myDdlList;
    private final boolean myOnCreate;
    private final SqlDataSourceImpl myTempDataSource;

    protected SqlDataSourceConfigurable(SqlDbManager manager, Project project, SqlDataSourceImpl dataSource, boolean onCreate) {
        super(manager, dataSource, project);
        this.$$$setupUI$$$();
        this.myTempDataSource = dataSource.copy();
        this.myOnCreate = onCreate;
    }

    @NotNull
    private CollectionListModel<String> getUrlListModel() {
        CollectionListModel collectionListModel = (CollectionListModel)this.myDdlList.getModel();
        if (collectionListModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceConfigurable", "getUrlListModel"));
        }
        return collectionListModel;
    }

    @Override
    @NotNull
    public SqlDataSourceImpl getTempDataSource() {
        this.saveData(this.myTempDataSource);
        SqlDataSourceImpl sqlDataSourceImpl = this.myTempDataSource;
        if (sqlDataSourceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/database/SqlDataSourceConfigurable", "getTempDataSource"));
        }
        return sqlDataSourceImpl;
    }

    private void doChooseFiles() {
        VirtualFile[] roots = ProjectRootManager.getInstance((Project)this.myProject).getContentRoots();
        if (roots.length == 0) {
            Messages.showWarningDialog((Project)this.myProject, (String)"You have no directories, attached to your project", (String)"Nothing to Choose From");
            return;
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, true, false, false, false, true){

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                return super.isFileVisible(file, showHiddenFiles) && file.isDirectory() || file.getFileType() == SqlFileType.INSTANCE;
            }
        };
        descriptor.setRoots(roots);
        descriptor.withTreeRootVisible(true);
        descriptor.setTitle(SqlMessages.message("dialog.title.choose.ddl.files", new Object[0]));
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor, (Project)this.myProject, (VirtualFile)((VirtualFile)ContainerUtil.getFirstItem(((SqlDataSourceImpl)this.myDataSource).getFiles())), files -> {
            CollectionListModel<String> model = this.getUrlListModel();
            LinkedHashSet set = ContainerUtil.newLinkedHashSet((Iterable)model.toList());
            for (VirtualFile f : files) {
                if (f.isDirectory()) {
                    VfsUtilCore.processFilesRecursively((VirtualFile)f, file -> {
                        if (file.getFileType() == SqlFileType.INSTANCE) {
                            set.add(file.getUrl());
                        }
                        return true;
                    });
                    continue;
                }
                set.add(f.getUrl());
            }
            SqlDataSourceConfigurable.setItemsImpl(set, model);
        });
    }

    private static void setItemsImpl(Iterable<String> items, @NotNull CollectionListModel<String> model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/sql/database/SqlDataSourceConfigurable", "setItemsImpl"));
        }
        int len = model.getSize();
        int i2 = 0;
        for (String s : items) {
            if (i2 < len) {
                model.setElementAt((Object)s, i2++);
                continue;
            }
            model.add((Object)s);
        }
        while (i2 < len) {
            model.removeRow(i2++);
        }
    }

    public static boolean checkGenericDialectUsage(final Project project, Collection<String> urls) {
        VirtualFileManager fileManager = VirtualFileManager.getInstance();
        SqlDialectMappings mappings = SqlDialectMappings.getInstance(project);
        final Ref selectFile = Ref.create(null);
        final ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(urls.size());
        for (String url : urls) {
            VirtualFile file = fileManager.findFileByUrl(url);
            if (file == null) continue;
            files.add(file);
            if (!selectFile.isNull() || mappings.getMapping(file) != DbSqlUtil.getGenericDialect()) continue;
            selectFile.set((Object)file);
        }
        if (!selectFile.isNull()) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (project.isDisposed()) {
                        return;
                    }
                    final SqlDialectsConfigurable configurable = new SqlDialectsConfigurable(project);
                    SingleConfigurableEditor editor = new SingleConfigurableEditor(project, (Configurable)configurable){

                        protected ValidationInfo doValidate() {
                            for (VirtualFile file : files) {
                                SqlLanguageDialect dialect = (SqlLanguageDialect)configurable.getNewMapping(file);
                                if (dialect != DbSqlUtil.getGenericDialect()) continue;
                                return new ValidationInfo(SqlMessages.message("generic.sql.dialect.usage.error.message", VfsUtilCore.urlToPath((String)file.getPresentableUrl()), StringUtil.escapeXml((String)DbSqlUtil.getGenericDialect().getDisplayName())));
                            }
                            return super.doValidate();
                        }

                        protected boolean postponeValidation() {
                            return false;
                        }
                    };
                    configurable.selectFile((VirtualFile)selectFile.get());
                    editor.show();
                }
            });
        }
        return true;
    }

    @Nls
    public String getDisplayName() {
        return this.getNameValue();
    }

    private String getNameValue() {
        return this.myNameComponent.getNameValue();
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.tools.datasource.properties";
    }

    @Nullable
    public JComponent createComponent() {
        this.myNameComponent = new DataSourceNameComponent(this, this.myController);
        this.myNamePanel.add((Component)this.myNameComponent.getComponent(), "Center");
        this.myNameComponent.getComponent().setBorder(null);
        this.myDdlList = new JBList((ListModel)new CollectionListModel((Object[])new String[0]));
        this.myDdlList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/sql/database/SqlDataSourceConfigurable$3", "customizeCellRenderer"));
                }
                String url = (String)value;
                VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
                if (file != null) {
                    this.append(file.getPath(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    this.setIcon(file.isDirectory() ? PlatformIcons.FOLDER_ICON : VirtualFilePresentation.getIcon((VirtualFile)file));
                } else {
                    this.append(VfsUtilCore.urlToPath((String)url), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    this.setIcon(null);
                }
            }
        });
        this.myDdlListPanel.add((Component)ToolbarDecorator.createDecorator((JList)this.myDdlList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SqlDataSourceConfigurable.this.doChooseFiles();
            }
        }).createPanel(), "Center");
        this.myRootPanel.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        return this.myRootPanel;
    }

    public void saveData(@NotNull SqlDataSourceImpl dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/sql/database/SqlDataSourceConfigurable", "saveData"));
        }
        ListModel model = this.myDdlList.getModel();
        ArrayList urls = ContainerUtil.newArrayList();
        int len = model.getSize();
        for (int i2 = 0; i2 < len; ++i2) {
            urls.add((String)model.getElementAt(i2));
        }
        dataSource.setName(this.getNameValue());
        dataSource.setParent((DatabaseSystem)this.myParentCombo.getSelectedItem());
        dataSource.setUrls(urls);
    }

    public void apply() throws ConfigurationException {
        SqlDataSourceImpl tempDataSource = this.getTempDataSource();
        SqlDataSourceConfigurable.checkGenericDialectUsage(this.myProject, tempDataSource.getUrls());
        this.saveData((SqlDataSourceImpl)this.myDataSource);
        if (this.isNewDataSource()) {
            ((SqlDbManager)this.myManager).processAddOrRemove((SqlDataSourceImpl)this.myDataSource, true);
        }
        this.reinitDataSourceCombo();
    }

    @Override
    protected void reset(@NotNull SqlDataSourceImpl o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/database/SqlDataSourceConfigurable", "reset"));
        }
        this.myNameComponent.setNameValue(o.getName());
        this.reinitDataSourceCombo();
        DbDataSource parentDataSource = o.getParentDataSource();
        DbDataSource parent = parentDataSource == null ? null : DbPsiFacade.getInstance((Project)this.myProject).findDataSource(parentDataSource.getUniqueId());
        this.myParentCombo.setSelectedItem((Object)parent);
        SqlDataSourceConfigurable.setItemsImpl(o.getUrls(), this.getUrlListModel());
    }

    protected void reinitDataSourceCombo() {
        JBIterable dataSources = JBIterable.from((Iterable)DbPsiFacade.getInstance((Project)this.myProject).getDataSources()).filter(Conditions.compose((Function)DbUtil.TO_DELEGATE, (Condition)Conditions.notEqualTo((Object)this.myDataSource)));
        if (!this.myOnCreate) {
            DatabaseDialectEx dialect = ((SqlDataSourceImpl)this.myDataSource).getDatabaseDialect();
            dataSources = dataSources.filter(dataSource -> DbImplUtil.getDatabaseDialect((DbElement)dataSource) == dialect);
        }
        DbUIUtil.configureDataSourceComboBox((JComboBox)this.myParentCombo, (Iterable<DbDataSource>)dataSources, true);
    }

    @Override
    public boolean isModified() {
        if (this.isNewDataSource()) {
            return true;
        }
        SqlDataSourceImpl tempDataSource = this.getTempDataSource();
        if (!StringUtil.equals((CharSequence)tempDataSource.getName(), (CharSequence)((SqlDataSourceImpl)this.myDataSource).getName())) {
            return true;
        }
        return !tempDataSource.equalConfiguration((SqlDataSourceImpl)this.myDataSource);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ComboBox comboBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myNamePanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Extend:");
        jPanel3.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myParentCombo = comboBox = new ComboBox();
        jPanel3.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 0, 3, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myDdlListPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 7, 7, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(ResourceBundle.getBundle("messages/SqlBundle").getString("title.border.ddl.files"));
        jPanel.add((Component)titledSeparator, "North");
        jBLabel.setLabelFor((Component)comboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

