/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessorBase;
import com.intellij.sql.psi.SqlDdlStatement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import org.jetbrains.annotations.NotNull;

public class SqlTreeChangePreprocessor
extends PsiTreeChangePreprocessorBase {
    public SqlTreeChangePreprocessor(@NotNull PsiManager psiManager) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/sql/psi/SqlTreeChangePreprocessor", "<init>"));
        }
        super(psiManager);
    }

    protected boolean acceptsEvent(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/sql/psi/SqlTreeChangePreprocessor", "acceptsEvent"));
        }
        return event.getFile() instanceof SqlFile;
    }

    protected boolean isOutOfCodeBlock(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/SqlTreeChangePreprocessor", "isOutOfCodeBlock"));
        }
        for (PsiElement p : SqlImplUtil.sqlParents(element)) {
            if (p instanceof SqlBlockStatementImpl) {
                return false;
            }
            if (p instanceof SqlDdlStatement) {
                return true;
            }
            if (p instanceof SqlSelectStatement) {
                return SqlTreeChangePreprocessor.hasDdlInside(p);
            }
            if (!(p instanceof SqlStatement)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasDdlInside(PsiElement p) {
        return SqlImplUtil.sqlTraverser(p).traverse().find(o -> o instanceof SqlStubbedDefinitionImpl) != null;
    }
}

