/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlSelectIntoClause;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSelectIntoNewTableClauseImpl
extends SqlStubbedDefinitionImpl<SqlTableStub>
implements SqlSelectIntoClause,
SqlTableDefinition {
    public SqlSelectIntoNewTableClauseImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/sql/psi/impl/SqlSelectIntoNewTableClauseImpl", "<init>"));
        }
        super(node);
    }

    public SqlSelectIntoNewTableClauseImpl(SqlTableStub stub) {
        super(stub, SqlCompositeElementTypes.SQL_SELECT_INTO_NEW_TABLE_CLAUSE);
    }

    @Override
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        return SqlCompositeElementTypes.SQL_TABLE_REFERENCE;
    }

    @Nullable
    private SqlReferenceList getReferenceList() {
        SqlExpression expression = this.getExpression();
        if (expression == null) {
            return null;
        }
        SqlSelectIntoNewTableClauseImpl intoClause = (SqlSelectIntoNewTableClauseImpl)PsiTreeUtil.getChildOfType((PsiElement)expression, SqlSelectIntoNewTableClauseImpl.class);
        if (intoClause == null) {
            return null;
        }
        return (SqlReferenceList)PsiTreeUtil.getChildOfType((PsiElement)intoClause, SqlReferenceList.class);
    }

    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)super.getNameElement();
    }

    @Override
    public void accept(SqlVisitor visitor) {
        visitor.visitSqlSelectIntoClause((SqlSelectIntoClause)this);
    }

    public DatabaseSystem getDataSource() {
        return null;
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlSelectIntoNewTableClauseImpl", "getKind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public <C> JBIterable<C> getDbChildren(@NotNull Class<C> clazz, @NotNull ObjectKind kind) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/sql/psi/impl/SqlSelectIntoNewTableClauseImpl", "getDbChildren"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/sql/psi/impl/SqlSelectIntoNewTableClauseImpl", "getDbChildren"));
        }
        JBIterable result = JBIterable.empty();
        if (kind == ObjectKind.COLUMN || kind == ObjectKind.NONE) {
            result = result.append(this.getColumns());
        }
        JBIterable jBIterable = result.filter(clazz);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlSelectIntoNewTableClauseImpl", "getDbChildren"));
        }
        return jBIterable;
    }

    @NotNull
    public List<PsiColumn> getColumns() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcColumns(), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT}));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlSelectIntoNewTableClauseImpl", "getColumns"));
        }
        return list;
    }

    @NotNull
    private List<PsiColumn> calcColumns() {
        SqlTableType type;
        SqlExpression expression = this.getExpression();
        SqlTableType sqlTableType = type = expression == null ? null : (SqlTableType)ObjectUtils.tryCast((Object)expression.getSqlType(), SqlTableType.class);
        if (type == null) {
            List<PsiColumn> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlSelectIntoNewTableClauseImpl", "calcColumns"));
            }
            return list;
        }
        SqlReferenceList list = this.getReferenceList();
        if (list != null) {
            type = type.alias(this.getName(), (PsiElement)this, list.getReferenceList());
        }
        List<PsiColumn> list2 = SqlImplUtil.createColumnInfos((DasTable)this, type);
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlSelectIntoNewTableClauseImpl", "calcColumns"));
        }
        return list2;
    }

    @Nullable
    public SqlExpression getExpression() {
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            return stub.getExpression();
        }
        return (SqlExpression)ObjectUtils.tryCast((Object)this.getParent(), SqlQueryExpression.class);
    }

    @Override
    public Icon getIcon() {
        return DatabaseIcons.Table;
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isTemporary() {
        return this.findChildByType((IElementType)SqlCommonKeywords.SQL_TEMPORARY) != null;
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c) {
        Set set = DasUtil.NO_ATTRS;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/psi/impl/SqlSelectIntoNewTableClauseImpl", "getColumnAttrs"));
        }
        return set;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/sql/psi/impl/SqlSelectIntoNewTableClauseImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/sql/psi/impl/SqlSelectIntoNewTableClauseImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/sql/psi/impl/SqlSelectIntoNewTableClauseImpl", "processDeclarations"));
        }
        if (PsiTreeUtil.isContextAncestor((PsiElement)this.getContext(), (PsiElement)place, (boolean)false)) {
            return true;
        }
        if (!processor.execute((PsiElement)this, state)) {
            return false;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }
}

