/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl.support;

import com.intellij.codeInsight.highlighting.PairedBraceMatcherAdapter;
import com.intellij.lang.BracePair;
import com.intellij.lang.Language;
import com.intellij.lang.PairedBraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlPairedBraceMatcher
extends PairedBraceMatcherAdapter {
    public static final BracePair[] PAIRS = new BracePair[]{new BracePair((IElementType)SqlTokens.SQL_LEFT_PAREN, (IElementType)SqlTokens.SQL_RIGHT_PAREN, true), new BracePair((IElementType)SqlTokens.SQL_LEFT_BRACE, (IElementType)SqlTokens.SQL_RIGHT_BRACE, false), new BracePair((IElementType)SqlTokens.SQL_LEFT_BRACKET, (IElementType)SqlTokens.SQL_RIGHT_BRACKET, false), new BracePair((IElementType)SqlTokens.SQL_LEFT_ANGLES, (IElementType)SqlTokens.SQL_RIGHT_ANGLES, false), new BracePair((IElementType)SqlTokens.SQL_CUSTOM_LQUOTE, (IElementType)SqlTokens.SQL_CUSTOM_RQUOTE, false), new BracePair((IElementType)SqlTokens.SQL_CUSTOM_PARAM_LQUOTE, (IElementType)SqlTokens.SQL_CUSTOM_PARAM_RQUOTE, false), new BracePair((IElementType)SqlCommonKeywords.SQL_BEGIN, (IElementType)SqlCommonKeywords.SQL_END, true), new BracePair((IElementType)SqlCommonKeywords.SQL_IF, (IElementType)SqlCommonKeywords.SQL_END, true), new BracePair((IElementType)SqlCommonKeywords.SQL_CASE, (IElementType)SqlCommonKeywords.SQL_END, true), new BracePair((IElementType)SqlCommonKeywords.SQL_REPEAT, (IElementType)SqlCommonKeywords.SQL_END, true), new BracePair((IElementType)SqlCommonKeywords.SQL_LOOP, (IElementType)SqlCommonKeywords.SQL_END, true)};

    public SqlPairedBraceMatcher() {
        super((PairedBraceMatcher)new MyPairedBraceMatcher(), (Language)SqlLanguage.INSTANCE);
    }

    public boolean isLBraceToken(HighlighterIterator iterator, CharSequence fileText, FileType fileType) {
        BracePair pair = this.findPair(true, iterator, fileText, fileType);
        if (pair == null) {
            return false;
        }
        if (pair.getRightBraceType() != SqlCommonKeywords.SQL_END) {
            return true;
        }
        boolean result = true;
        int count = 0;
        while (true) {
            iterator.retreat();
            ++count;
            if (iterator.atEnd()) break;
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == TokenType.WHITE_SPACE || SqlTokens.COMMENT_TOKENS.contains(tokenType)) continue;
            if (tokenType != SqlCommonKeywords.SQL_END) break;
            result = false;
        }
        while (count-- > 0) {
            iterator.advance();
        }
        return result;
    }

    private static class MyPairedBraceMatcher
    implements PairedBraceMatcher {
        private MyPairedBraceMatcher() {
        }

        public BracePair[] getPairs() {
            return PAIRS;
        }

        public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType type) {
            if (lbraceType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lbraceType", "com/intellij/sql/psi/impl/support/SqlPairedBraceMatcher$MyPairedBraceMatcher", "isPairedBracesAllowedBeforeType"));
            }
            return TokenType.WHITE_SPACE == type || SqlTokens.COMMENT_TOKENS.contains(type) || type == SqlTokens.SQL_SEMICOLON || type == SqlTokens.SQL_COMMA || type == SqlTokens.SQL_RIGHT_PAREN || type == SqlTokens.SQL_RIGHT_BRACKET || type == SqlTokens.SQL_RIGHT_BRACE || null == type;
        }

        public int getCodeConstructStart(PsiFile file, int openingBraceOffset) {
            return openingBraceOffset;
        }
    }
}

