/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

public final class BitMatrix {
    private long[] words = new long[1024];

    public void set(int y, int x, boolean bit) {
        long w;
        int index = BitMatrix.index(y, x);
        int a = index / 64;
        int b = index % 64;
        if (a >= this.words.length) {
            if (!bit) {
                return;
            }
            this.expand(a + 1);
            w = 0L;
        } else {
            w = this.words[a];
        }
        this.words[a] = w |= 1L << b;
    }

    public boolean get(int y, int x) {
        int index = BitMatrix.index(y, x);
        int a = index / 64;
        int b = index % 64;
        if (a >= this.words.length) {
            return false;
        }
        long w = this.words[a];
        return (w >> b & 1L) != 0L;
    }

    private void expand(int capacity) {
        int m = this.words.length;
        int n = m << 1;
        if (n < capacity) {
            n = capacity + 255 & 0x7FFFFF00;
        }
        long[] newArray = new long[n];
        System.arraycopy(this.words, 0, newArray, 0, m);
        this.words = newArray;
    }

    static int index(int y, int x) {
        return x <= y ? y * y + y + x : x * x + y;
    }
}

