/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.plugins.intelliLang.inject.JSLanguageInjectionSupport;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInjectWithCommentIntentionAction
extends JavaScriptIntention {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.inject.with.comment.intention.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "JSInjectWithCommentIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "JSInjectWithCommentIntentionAction", "getText"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "JSInjectWithCommentIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "JSInjectWithCommentIntentionAction", "isAvailable"));
        }
        PsiLanguageInjectionHost injectionHost = JSInjectWithCommentIntentionAction.getInjectionHost(element);
        if (!super.isAvailable(project, editor, element) || injectionHost == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiFile injectedPsi = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)element.getContainingFile(), (int)offset);
        if (injectedPsi != null) {
            boolean canAddComment;
            Language injectedLanguage = injectedPsi.getLanguage();
            JSLanguageInjectionSupport injectionSupport = JSLanguageInjectionSupport.getInstance();
            boolean isTempInjection = injectionSupport.findCommentInjection((PsiElement)injectionHost, new Ref()) == null;
            boolean bl = canAddComment = injectionSupport.getAddCommentAction(injectionHost, injectedLanguage.getID()) != null;
            if (isTempInjection && canAddComment) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiLanguageInjectionHost getInjectionHost(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "JSInjectWithCommentIntentionAction", "getInjectionHost"));
        }
        PsiElement stringLiteral = element.getParent();
        return stringLiteral instanceof PsiLanguageInjectionHost ? (PsiLanguageInjectionHost)stringLiteral : null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "JSInjectWithCommentIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "JSInjectWithCommentIntentionAction", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiLanguageInjectionHost injectionHost = JSInjectWithCommentIntentionAction.getInjectionHost(element);
        PsiFile injectedPsi = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)element.getContainingFile(), (int)offset);
        JSLanguageInjectionSupport support = JSLanguageInjectionSupport.getInstance();
        if (injectionHost == null || injectedPsi == null) {
            return;
        }
        BaseActionRunnable addCommentAction = support.getAddCommentAction(injectionHost, injectedPsi.getLanguage().getID());
        if (addCommentAction == null) {
            return;
        }
        addCommentAction.execute();
    }
}

