/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.javascript.jest.JestUtil;
import com.intellij.lang.javascript.EmbeddedJsonSchemaFileProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaProviderFactory;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestSchemaProviderFactory
implements JsonSchemaProviderFactory {
    private final List<JsonSchemaFileProvider> myProviders = Collections.singletonList(JestSchemaProviderFactory.createProvider());

    public List<JsonSchemaFileProvider> getProviders(@Nullable Project project) {
        return this.myProviders;
    }

    @NotNull
    private static JsonSchemaFileProvider createProvider() {
        EmbeddedJsonSchemaFileProvider embeddedJsonSchemaFileProvider = new EmbeddedJsonSchemaFileProvider("jest-config-schema.json", JestSchemaProviderFactory.class, "", new String[0]){

            @Override
            public boolean isAvailable(@NotNull Project project, @NotNull VirtualFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/jest/JestSchemaProviderFactory$1", "isAvailable"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/jest/JestSchemaProviderFactory$1", "isAvailable"));
                }
                return JestUtil.isJestConfigFile(file.getNameSequence());
            }
        };
        if (embeddedJsonSchemaFileProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/jest/JestSchemaProviderFactory", "createProvider"));
        }
        return embeddedJsonSchemaFileProvider;
    }
}

