/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsLocalInterpreterUtil {
    private static final String NODE_INTERPRETER_BASE_NAME = SystemInfo.isWindows ? "node.exe" : "node";
    private static final FileFilter NODE_FILTER = pathname -> {
        String path;
        if (SystemInfo.isWindows && (path = pathname.getAbsolutePath()).contains("Microsoft HPC Pack")) {
            return false;
        }
        return !SystemInfo.isUnix || !"/usr/sbin/node".equals(path = pathname.getAbsolutePath());
    };

    private NodeJsLocalInterpreterUtil() {
    }

    @Nullable
    public static File findInterpreterInPath() {
        File interpreter = PathEnvironmentVariableUtil.findInPath((String)NODE_INTERPRETER_BASE_NAME, (FileFilter)NODE_FILTER);
        if (interpreter != null) {
            return interpreter;
        }
        ArrayList interpreters = ContainerUtil.newArrayList();
        NodeJsLocalInterpreterUtil.addInterpretersFromNvm(interpreters);
        NodeJsLocalInterpreterUtil.addInterpretersFromHomeBrew(interpreters);
        if (interpreters.size() == 1) {
            return (File)ContainerUtil.getFirstItem((List)interpreters);
        }
        return null;
    }

    @NotNull
    public static List<File> detectAllLocalInterpreters() {
        List fromPath = PathEnvironmentVariableUtil.findAllExeFilesInPath((String)NODE_INTERPRETER_BASE_NAME, (FileFilter)NODE_FILTER);
        ArrayList interpreters = ContainerUtil.newArrayList((Iterable)fromPath);
        NodeJsLocalInterpreterUtil.addInterpretersFromNvm(interpreters);
        NodeJsLocalInterpreterUtil.addInterpretersFromHomeBrew(interpreters);
        NodeJsLocalInterpreterUtil.addInterpretersFromNodist(interpreters);
        NodeJsLocalInterpreterUtil.addInterpretersFromN(interpreters);
        ArrayList arrayList = interpreters;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "detectAllLocalInterpreters"));
        }
        return arrayList;
    }

    private static void addInterpretersFromNodist(@NotNull List<File> interpreters) {
        File versionsDir;
        String nodistPrefix;
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "addInterpretersFromNodist"));
        }
        if (SystemInfo.isWindows && !StringUtil.isEmpty((String)(nodistPrefix = EnvironmentUtil.getValue((String)"NODIST_PREFIX"))) && (versionsDir = new File(nodistPrefix, "v")).isAbsolute() && versionsDir.isDirectory()) {
            NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, versionsDir, false);
        }
    }

    private static void addInterpretersFromNvm(@NotNull List<File> interpreters) {
        File nvmDir;
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "addInterpretersFromNvm"));
        }
        String nvmDirPath = EnvironmentUtil.getValue((String)"NVM_DIR");
        if (StringUtil.isEmpty((String)nvmDirPath)) {
            if (SystemInfo.isUnix) {
                nvmDirPath = SystemProperties.getUserHome() + "/.nvm";
            } else {
                return;
            }
        }
        if (!(nvmDir = new File(nvmDirPath)).isAbsolute()) {
            return;
        }
        NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, nvmDir, true);
        File versionsDir = new File(nvmDir, "versions");
        if (versionsDir.isDirectory()) {
            NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, new File(versionsDir, "node"), true);
            NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, new File(versionsDir, "io.js"), true);
        }
    }

    private static void addInterpretersFromHomeBrew(@NotNull List<File> interpreters) {
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "addInterpretersFromHomeBrew"));
        }
        NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, new File("/usr/local/Cellar/node"), true);
    }

    private static void addInterpretersFromVersionsDir(@NotNull List<File> interpreters, @NotNull File versionsDir, boolean interpreterInsideBinDir) {
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "addInterpretersFromVersionsDir"));
        }
        if (versionsDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionsDir", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "addInterpretersFromVersionsDir"));
        }
        if (!versionsDir.isDirectory()) {
            return;
        }
        File[] dirs = versionsDir.listFiles();
        if (dirs == null) {
            return;
        }
        for (File dir : dirs) {
            String relativePath;
            File interpreter;
            SemVer semVer = NodeJsLocalInterpreterUtil.parseSemVer(dir.getName());
            if (semVer == null || !(interpreter = new File(dir, relativePath = interpreterInsideBinDir ? "bin" + File.separator + NODE_INTERPRETER_BASE_NAME : NODE_INTERPRETER_BASE_NAME)).isFile() || !interpreter.canExecute()) continue;
            interpreters.add(interpreter);
        }
    }

    private static void addInterpretersFromN(@NotNull List<File> interpreters) {
        File nPrefixDir;
        if (interpreters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interpreters", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "addInterpretersFromN"));
        }
        String nPrefix = EnvironmentUtil.getValue((String)"N_PREFIX");
        if (StringUtil.isEmpty((String)nPrefix)) {
            if (SystemInfo.isUnix) {
                nPrefix = SystemProperties.getUserHome() + "/n";
            } else {
                return;
            }
        }
        if (!(nPrefixDir = new File(nPrefix)).isAbsolute() || !nPrefixDir.isDirectory()) {
            return;
        }
        File currentNode = new File(nPrefixDir, "bin" + File.separator + NODE_INTERPRETER_BASE_NAME);
        if (currentNode.isFile() && currentNode.canExecute()) {
            interpreters.add(currentNode);
        }
        NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, new File(nPrefixDir, "n/versions/node"), true);
        NodeJsLocalInterpreterUtil.addInterpretersFromVersionsDir(interpreters, new File(nPrefixDir, "n/versions/io"), true);
    }

    @Nullable
    private static SemVer parseSemVer(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterUtil", "parseSemVer"));
        }
        return SemVer.parseFromText((String)StringUtil.trimStart((String)name, (String)"v"));
    }
}

