/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackage {
    private final String mySystemDependentPath;
    private final File myDir;

    public NodePackage(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/javascript/nodejs/util/NodePackage", "<init>"));
        }
        path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (char)'/');
        this.mySystemDependentPath = FileUtil.toSystemDependentName((String)path);
        this.myDir = new File(this.mySystemDependentPath);
    }

    @NotNull
    public String getSystemIndependentPath() {
        String string = FileUtil.toSystemIndependentName((String)this.mySystemDependentPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "getSystemIndependentPath"));
        }
        return string;
    }

    @NotNull
    public String getSystemDependentPath() {
        String string = this.mySystemDependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "getSystemDependentPath"));
        }
        return string;
    }

    @NotNull
    public String getName() {
        String string = PathUtil.getFileName((String)this.mySystemDependentPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "getName"));
        }
        return string;
    }

    @Nullable
    public SemVer getVersion() {
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(new File(this.myDir, "package.json"));
        return file != null ? PackageJsonData.getOrCreate(file).getVersion() : null;
    }

    @NotNull
    public String getPresentablePath() {
        String userHome = StringUtil.trimEnd((String)FileUtil.toSystemDependentName((String)SystemProperties.getUserHome()), (char)File.separatorChar);
        if (StringUtil.isEmptyOrSpaces((String)userHome)) {
            String string = this.mySystemDependentPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "getPresentablePath"));
            }
            return string;
        }
        if (this.mySystemDependentPath.startsWith(userHome + File.separatorChar)) {
            String string = "~" + this.mySystemDependentPath.substring(userHome.length());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "getPresentablePath"));
            }
            return string;
        }
        String string = this.mySystemDependentPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "getPresentablePath"));
        }
        return string;
    }

    public boolean isValid() {
        return !StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath) && this.myDir.isAbsolute() && this.myDir.isDirectory();
    }

    @Nullable
    public String getErrorMessage(@NotNull String packageName) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "getErrorMessage"));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return "Unspecified " + packageName + " package";
        }
        if (!this.myDir.isAbsolute() || !this.myDir.isDirectory()) {
            return "Invalid " + packageName + " package: no such directory";
        }
        return null;
    }

    public void validateForRunConfiguration(@NotNull String packageName) throws RuntimeConfigurationError {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "validateForRunConfiguration"));
        }
        String message = this.getErrorMessage(packageName);
        if (message != null) {
            throw new RuntimeConfigurationError(message);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePackage aPackage = (NodePackage)o;
        return this.mySystemDependentPath.equals(aPackage.mySystemDependentPath);
    }

    public int hashCode() {
        return this.mySystemDependentPath.hashCode();
    }

    @Nullable
    public static NodePackage findDefaultPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackage", "findDefaultPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "findDefaultPackage"));
        }
        List<NodePackage> packages = NodePackage.collectAvailableNodePackages(project, packageName, interpreter, false);
        return (NodePackage)ContainerUtil.getFirstItem(packages);
    }

    @NotNull
    public static NodePackage findPreferredPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackage", "findPreferredPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "findPreferredPackage"));
        }
        NodePackage nodePackage = NodePackage.findPreferredPackage(project, packageName, interpreter, false);
        if (nodePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "findPreferredPackage"));
        }
        return nodePackage;
    }

    @NotNull
    public static NodePackage findPreferredPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter, boolean includeSecondLevelPackages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackage", "findPreferredPackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "findPreferredPackage"));
        }
        NodePackage nodePackage = (NodePackage)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackage", "lambda$findPreferredPackage$0"));
            }
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "lambda$findPreferredPackage$0"));
            }
            List<NodePackage> packages = NodePackage.collectAvailableNodePackages(project, packageName, interpreter, includeSecondLevelPackages);
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            NodePackage localPackage = null;
            for (NodePackage pkg : packages) {
                VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(pkg.getSystemIndependentPath());
                if (dir == null || fileIndex.getContentRootForFile(dir, false) == null) continue;
                if (localPackage != null) {
                    return new NodePackage("");
                }
                localPackage = pkg;
            }
            if (localPackage != null) {
                return localPackage;
            }
            if (packages.size() == 1) {
                return (NodePackage)ContainerUtil.getFirstItem(packages);
            }
            return new NodePackage("");
        });
        if (nodePackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "findPreferredPackage"));
        }
        return nodePackage;
    }

    @NotNull
    public static List<NodePackage> collectAvailableNodePackages(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter, boolean includeSecondLevelPackages) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackage", "collectAvailableNodePackages"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/util/NodePackage", "collectAvailableNodePackages"));
        }
        ArrayList modules = ContainerUtil.newArrayList();
        NodeModuleSearchUtil.findModulesByNameInContentRoots(modules, packageName, project, includeSecondLevelPackages, interpreter, true);
        Collection packageJsonFiles = (Collection)ReadAction.compute(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/nodejs/util/NodePackage", "lambda$collectAvailableNodePackages$1"));
            }
            return FilenameIndex.getVirtualFilesByName((Project)project, (String)"package.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        });
        for (Object packageJson : packageJsonFiles) {
            VirtualFile nodeModulesDir;
            PackageJsonData data = PackageJsonData.getOrCreate((VirtualFile)packageJson);
            if (!data.getAllDependencies().contains(packageName) || (nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson((VirtualFile)packageJson)) == null) continue;
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules, nodeModulesDir, ModuleType.NODE_MODULES_DIR, packageName);
        }
        LinkedHashSet packages = ContainerUtil.newLinkedHashSet();
        for (CompletionModuleInfo module : modules) {
            VirtualFile dir = module.getVirtualFile();
            if (dir == null || !dir.isDirectory()) continue;
            packages.add(new NodePackage(dir.getPath()));
        }
        if ("yarn".equals(packageName)) {
            if (SystemInfo.isWindows) {
                NodePackage.tryAdd(packages, new File("C:\\Program Files (x86)\\Yarn"));
                NodePackage.tryAdd(packages, new File("C:\\Program Files\\Yarn"));
            } else {
                NodePackage.tryAdd(packages, new File("/opt/local/libexec/yarn"));
                File cellarYarnDir = NodePackage.findCellarYarnDir();
                if (cellarYarnDir != null) {
                    File[] versions;
                    for (File version : versions = (File[])ObjectUtils.notNull((Object)cellarYarnDir.listFiles(), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
                        if (NodePackage.tryAdd(packages, new File(version, "libexec"))) continue;
                        NodePackage.tryAdd(packages, new File(version, "libexec/lib/node_modules/yarn"));
                    }
                }
            }
        }
        ArrayList<NodePackage> arrayList = new ArrayList<NodePackage>(packages);
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/util/NodePackage", "collectAvailableNodePackages"));
        }
        return arrayList;
    }

    private static boolean tryAdd(@NotNull Set<NodePackage> packages, @NotNull File packageDir) {
        File packageJson;
        if (packages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packages", "com/intellij/javascript/nodejs/util/NodePackage", "tryAdd"));
        }
        if (packageDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageDir", "com/intellij/javascript/nodejs/util/NodePackage", "tryAdd"));
        }
        if (packageDir.isDirectory() && (packageJson = new File(packageDir, "package.json")).isFile()) {
            packages.add(new NodePackage(packageDir.getAbsolutePath()));
            return true;
        }
        return false;
    }

    public String toString() {
        return this.mySystemDependentPath;
    }

    private static File findCellarYarnDir() {
        File yarn;
        File root;
        File bin;
        File yarnExe = PathEnvironmentVariableUtil.findInPath((String)"yarn");
        if (yarnExe != null && (bin = yarnExe.getParentFile()) != null && bin.getName().equals("bin") && (root = bin.getParentFile()) != null && (yarn = new File(root, "Cellar/yarn")).isDirectory()) {
            return yarn;
        }
        File yarn2 = new File(SystemProperties.getUserHome(), ".linuxbrew/Cellar/yarn");
        if (yarn2.isDirectory()) {
            return yarn2;
        }
        yarn2 = new File("/usr/local/Cellar/yarn");
        if (yarn2.isDirectory()) {
            return yarn2;
        }
        return null;
    }
}

