/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.QualifiedItemProcessor;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.VariantsProcessor;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ImportExportSpecifierCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "addCompletions"));
        }
        PsiElement parent = parameters.getPosition().getParent();
        assert (parent instanceof ES6ImportExportSpecifier);
        ResultSink sink = ES6ImportExportSpecifierCompletionProvider.createResultSink((ES6ImportExportSpecifier)parent);
        List<JSType> types = ES6PsiUtil.processSpecifier((ES6ImportExportSpecifier)parent, sink);
        VariantsProcessor processor = new VariantsProcessor(parent.getContainingFile(), parent, true, result);
        ES6PsiUtil.addInnerAliases(types, processor);
        JSReferenceCompletionContributor.processCompeteMatchedElements(processor);
        result.addAllElements(ContainerUtil.concat((Iterable[])new Iterable[]{ES6ImportExportSpecifierCompletionProvider.buildResult(sink.getResults()), processor.getFinalResults()}));
    }

    @NotNull
    public static ResultSink createResultSink(@NotNull ES6ImportExportSpecifier specifier) {
        if (specifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "specifier", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "createResultSink"));
        }
        ResultSink resultSink = new ResultSink((PsiElement)specifier){

            @Override
            public boolean accepts(PsiElement element) {
                PsiElement module;
                if (element instanceof TypeScriptModule && ((TypeScriptModule)element).isAugmentation()) {
                    return false;
                }
                if (ES6PsiUtil.isElementCanBeExported(element) && DialectDetector.isTypeScript(element) && (module = TypeScriptPsiUtil.findExternalModule(element)) instanceof TypeScriptModule && ((TypeScriptModule)module).isAugmentation()) {
                    return false;
                }
                return super.accepts(element);
            }

            @Override
            public String getName() {
                return null;
            }
        };
        if (resultSink == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "createResultSink"));
        }
        return resultSink;
    }

    @NotNull
    public static List<LookupElement> buildResult(@Nullable List<PsiElement> elements) {
        if (elements == null) {
            List<LookupElement> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "buildResult"));
            }
            return list;
        }
        ArrayList<LookupElement> result = new ArrayList<LookupElement>(elements.size());
        for (PsiElement element : elements) {
            PsiElement resolve;
            if (element instanceof ES6ImportExportSpecifier && (resolve = ((ES6ImportExportSpecifier)element).resolve()) != null) {
                element = resolve;
            }
            if (!(element instanceof PsiNamedElement)) continue;
            LookupElementBuilder builder = JSLookupUtilImpl.createLookupElement(element);
            result.add((LookupElement)builder);
        }
        ArrayList<LookupElement> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "buildResult"));
        }
        return arrayList;
    }

    @NotNull
    public static QualifiedItemProcessor<?> createCompletionProcessor(PsiFile context) {
        QualifiedItemProcessor<? extends ResultSink> processor = JSDialectSpecificHandlersFactory.forElement((PsiElement)context).createCompletionItemProcessor(new CompletionResultSink((PsiElement)context), context);
        processor.setTypeContext(true);
        processor.setSkipImplicitDeclarations(true);
        QualifiedItemProcessor<? extends ResultSink> qualifiedItemProcessor = processor;
        if (qualifiedItemProcessor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/ecmascript6/completion/ES6ImportExportSpecifierCompletionProvider", "createCompletionProcessor"));
        }
        return qualifiedItemProcessor;
    }
}

