/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSCompositeElementType;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.nashorn.NashornJSElementTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.e4x.impl.JSE4XFilterQueryArgumentListImpl;
import com.intellij.lang.javascript.psi.e4x.impl.JSE4XNamespaceReferenceImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptAsExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptNewExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptNotNullExpressionImpl;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptTypeAssertionImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSConditionalCompileVariableReferenceImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSGenericSignatureImpl;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSSuperExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSArgumentListImpl;
import com.intellij.lang.javascript.psi.impl.JSArrayComprehensionImpl;
import com.intellij.lang.javascript.psi.impl.JSArrayLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSBinaryExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSBreakStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSCatchBlockImpl;
import com.intellij.lang.javascript.psi.impl.JSCommaExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSConditionalExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSContinueStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSDoWhileStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSEmbeddedContentImpl;
import com.intellij.lang.javascript.psi.impl.JSEmptyStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSExpressionStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSForInStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSForStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSGeneratorExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSIfStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSIndexedPropertyAccessExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSLabeledStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSLetExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSLetStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSLocalVariableImpl;
import com.intellij.lang.javascript.psi.impl.JSParenthesizedExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPostfixExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSPrefixExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSSpreadExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSSwitchStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSThisExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSThrowStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSTryStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSWhileStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSWithStatementImpl;
import com.intellij.lang.javascript.psi.impl.JSYieldExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSEmbeddedContentStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSEmbeddedContentStubImpl;
import com.intellij.lang.javascript.types.JSBlockStatementElementType;
import com.intellij.lang.javascript.types.JSCaseClauseElementType;
import com.intellij.lang.javascript.types.JSEmbeddedContentElementType;
import com.intellij.lang.javascript.types.JSNewExpressionElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.tree.CustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.util.CharTable;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public interface JSElementTypes
extends JSStubElementTypes {
    public static final IElementType EMBEDDED_CONTENT = new JSEmbeddedContentElementType(null, "");
    public static final IElementType JSX_EMBEDDED_CONTENT = new JSEmbeddedContentElementType(JavaScriptSupportLoader.JSX_HARMONY, "JSX_");
    public static final IElementType TS_EMBEDDED_CONTENT = new JSEmbeddedContentElementType(JavaScriptSupportLoader.TYPESCRIPT, "TS_");
    public static final IElementType ES6_EMBEDDED_CONTENT = new JSEmbeddedContentElementType(JavaScriptSupportLoader.ECMA_SCRIPT_6, "ES6_");
    public static final IElementType XML_TEXT = new JSCompositeElementType("XML_TEXT");
    public static final IElementType XML_ATTRIBUTE = new JSCompositeElementType("XML_ATTRIBUTE");
    public static final IElementType XML_ATTRIBUTE_VALUE = new JSCompositeElementType("XML_ATTRIBUTE_VALUE");
    public static final IElementType EMBEDDED_EXPRESSION = new JSStubElementType<JSEmbeddedContentStub, JSEmbeddedContent>("EMBEDDED_EXPRESSION"){

        @NotNull
        public PsiElement construct(ASTNode node) {
            JSEmbeddedContentImpl jSEmbeddedContentImpl = new JSEmbeddedContentImpl(node);
            if (jSEmbeddedContentImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSElementTypes$1", "construct"));
            }
            return jSEmbeddedContentImpl;
        }

        @NotNull
        public JSEmbeddedContentStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
            if (dataStream == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/lang/javascript/JSElementTypes$1", "deserialize"));
            }
            JSEmbeddedContentStubImpl jSEmbeddedContentStubImpl = new JSEmbeddedContentStubImpl(dataStream, parentStub, (IStubElementType)this);
            if (jSEmbeddedContentStubImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSElementTypes$1", "deserialize"));
            }
            return jSEmbeddedContentStubImpl;
        }

        @NotNull
        public JSEmbeddedContentStub createStub(@NotNull JSEmbeddedContent psi, StubElement parentStub) {
            if (psi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/lang/javascript/JSElementTypes$1", "createStub"));
            }
            JSEmbeddedContentStubImpl jSEmbeddedContentStubImpl = new JSEmbeddedContentStubImpl(psi, parentStub, (IStubElementType)this);
            if (jSEmbeddedContentStubImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSElementTypes$1", "createStub"));
            }
            return jSEmbeddedContentStubImpl;
        }
    };
    public static final IElementType ARGUMENT_LIST = new JSCompositeElementType("ARGUMENT_LIST"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSArgumentListImpl(node);
        }
    };
    public static final IElementType E4X_FILTER_QUERY_ARGUMENT_LIST = new JSCompositeElementType("E4X_FILTER_QUERY_ARGUMENT_LIST"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSE4XFilterQueryArgumentListImpl(node);
        }
    };
    public static final IElementType E4X_NAMESPACE_REFERENCE = new JSCompositeElementType("E4X_NAMESPACE_REFERENCE"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSE4XNamespaceReferenceImpl(node);
        }
    };
    public static final IElementType SUPER_EXPRESSION = new JSCompositeElementType("SUPER_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSSuperExpressionImpl(node);
        }
    };
    public static final IElementType GENERIC_SIGNATURE = new JSCompositeElementType("GENERIC_SIGNATURE"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSGenericSignatureImpl(node);
        }
    };
    public static final IElementType CONDITIONAL_COMPILE_VARIABLE_REFERENCE = new JSCompositeElementType("CONDITIONAL_COMPILE_VARIABLE_REFERENCE"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSConditionalCompileVariableReferenceImpl(node);
        }
    };
    public static final JSBlockStatementElementType BLOCK_STATEMENT = new JSBlockStatementElementType();
    public static final IElementType LABELED_STATEMENT = new JSCompositeElementType("LABELED_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSLabeledStatementImpl(node);
        }
    };
    public static final IElementType EXPRESSION_STATEMENT = new JSCompositeElementType("EXPRESSION_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSExpressionStatementImpl(node);
        }
    };
    public static final IElementType LET_STATEMENT = new JSCompositeElementType("LET_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSLetStatementImpl(node);
        }
    };
    public static final IElementType EMPTY_STATEMENT = new JSCompositeElementType("EMPTY_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSEmptyStatementImpl(node);
        }
    };
    public static final IElementType IF_STATEMENT = new JSCompositeElementType("IF_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSIfStatementImpl(node);
        }
    };
    public static final IElementType CONTINUE_STATEMENT = new JSCompositeElementType("CONTINUE_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSContinueStatementImpl(node);
        }
    };
    public static final IElementType BREAK_STATEMENT = new JSCompositeElementType("BREAK_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSBreakStatementImpl(node);
        }
    };
    public static final IElementType WITH_STATEMENT = new JSCompositeElementType("WITH_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSWithStatementImpl(node);
        }
    };
    public static final IElementType THROW_STATEMENT = new JSCompositeElementType("THROW_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSThrowStatementImpl(node);
        }
    };
    public static final IElementType TRY_STATEMENT = new JSCompositeElementType("TRY_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSTryStatementImpl(node);
        }
    };
    public static final IElementType CATCH_BLOCK = new JSCompositeElementType("CATCH_BLOCK"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSCatchBlockImpl(node);
        }
    };
    public static final IElementType CASE_CLAUSE = new JSCaseClauseElementType();
    public static final IElementType SWITCH_STATEMENT = new JSCompositeElementType("SWITCH_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSSwitchStatementImpl(node);
        }
    };
    public static final IElementType FOR_STATEMENT = new JSCompositeElementType("FOR_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSForStatementImpl(node);
        }
    };
    public static final IElementType FOR_IN_STATEMENT = new JSCompositeElementType("FOR_IN_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSForInStatementImpl(node);
        }
    };
    public static final IElementType WHILE_STATEMENT = new JSCompositeElementType("WHILE_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSWhileStatementImpl(node);
        }
    };
    public static final IElementType DOWHILE_STATEMENT = new JSCompositeElementType("DO_WHILE_STATEMENT"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSDoWhileStatementImpl(node);
        }
    };
    public static final IElementType MIXIN_STATEMENT = new JSCompositeElementType("MIXIN_STATEMENT");
    public static final IElementType THIS_EXPRESSION = new JSCompositeElementType("THIS_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSThisExpressionImpl(node);
        }
    };
    public static final IElementType REFERENCE_EXPRESSION = new JSCompositeElementType("REFERENCE_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSReferenceExpressionImpl(node);
        }
    };
    public static final IElementType LOCAL_VARIABLE = new JSCompositeElementType("LOCAL_VARIABLE"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSLocalVariableImpl(node);
        }
    };
    public static final IElementType GWT_REFERENCE_EXPRESSION = new JSCompositeElementType("GWT_REFERENCE_EXPRESSION");
    public static final IElementType XML_LITERAL_EXPRESSION = new JSCompositeElementType("XML_LITERAL_EXPRESSION");
    public static final IElementType LITERAL_AS_ATTRIBUTE_VALUE = new CustomParsingType("LITERAL_AS_ATTRIBUTE_VALUE", (Language)JavascriptLanguage.INSTANCE){

        @NotNull
        public ASTNode parse(@NotNull CharSequence text, @NotNull CharTable table) {
            int bodyEnd;
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/javascript/JSElementTypes$27", "parse"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/lang/javascript/JSElementTypes$27", "parse"));
            }
            CompositeElement value = ASTFactory.composite((IElementType)XmlElementType.XML_ATTRIBUTE_VALUE);
            int length = text.length();
            int bodyStart = length > 0 && this.isQuote(text.charAt(0)) ? 1 : 0;
            int n = bodyEnd = length > 1 && this.isQuote(text.charAt(length - 1)) ? length - 2 : length - 1;
            if (bodyStart == 1) {
                value.rawAddChildrenWithoutNotifications((TreeElement)ASTFactory.leaf((IElementType)JSTokenTypes.XML_ATTR_VALUE_START, (CharSequence)table.intern(text, 0, 1)));
            }
            if (bodyEnd - bodyStart >= 0) {
                value.rawAddChildrenWithoutNotifications((TreeElement)ASTFactory.leaf((IElementType)JSTokenTypes.XML_ATTR_VALUE, (CharSequence)table.intern(text, bodyStart, bodyEnd + 1)));
            }
            if (bodyEnd < length - 1) {
                value.rawAddChildrenWithoutNotifications((TreeElement)ASTFactory.leaf((IElementType)JSTokenTypes.XML_ATTR_VALUE_END, (CharSequence)table.intern(text, length - 1, length)));
            }
            CompositeElement compositeElement = value;
            if (compositeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSElementTypes$27", "parse"));
            }
            return compositeElement;
        }

        private boolean isQuote(char c) {
            return c == '\'' || c == '\"';
        }
    };
    public static final IElementType PARENTHESIZED_EXPRESSION = new JSCompositeElementType("PARENTHESIZED_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSParenthesizedExpressionImpl(node);
        }
    };
    public static final IElementType ARRAY_LITERAL_EXPRESSION = new JSCompositeElementType("ARRAY_LITERAL_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSArrayLiteralExpressionImpl(node);
        }
    };
    public static final IElementType YIELD_EXPRESSION = new JSCompositeElementType("YIELD_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSYieldExpressionImpl(node);
        }
    };
    public static final IElementType CONDITIONAL_EXPRESSION = new JSCompositeElementType("CONDITIONAL_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSConditionalExpressionImpl(node);
        }
    };
    public static final IElementType ARRAY_COMPREHENSION = new JSCompositeElementType("ARRAY_COMPREHENSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSArrayComprehensionImpl(node);
        }
    };
    public static final IElementType BINARY_EXPRESSION = new JSCompositeElementType("BINARY_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSBinaryExpressionImpl(node);
        }
    };
    public static final IElementType PREFIX_EXPRESSION = new JSCompositeElementType("PREFIX_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSPrefixExpressionImpl(node);
        }
    };
    public static final IElementType POSTFIX_EXPRESSION = new JSCompositeElementType("POSTFIX_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSPostfixExpressionImpl(node);
        }
    };
    public static final IElementType COMMA_EXPRESSION = new JSCompositeElementType("COMMA_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSCommaExpressionImpl(node);
        }
    };
    public static final IElementType TYPESCRIPT_NEW_EXPRESSION = new JSNewExpressionElementType(){

        public JSElement construct(ASTNode node) {
            return new TypeScriptNewExpressionImpl(node);
        }

        @NotNull
        public String getExternalId() {
            String string = "TS:" + super.getExternalId();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/JSElementTypes$37", "getExternalId"));
            }
            return string;
        }

        @Override
        public boolean shouldCreateStub(ASTNode node) {
            return false;
        }
    };
    public static final TokenSet NEW_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{NEW_EXPRESSION, TYPESCRIPT_NEW_EXPRESSION});
    public static final IElementType INDEXED_PROPERTY_ACCESS_EXPRESSION = new JSCompositeElementType("INDEXED_PROPERTY_ACCESS_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSIndexedPropertyAccessExpressionImpl(node);
        }
    };
    public static final IElementType LET_EXPRESSION = new JSCompositeElementType("LET_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSLetExpressionImpl(node);
        }
    };
    public static final IElementType SPREAD_EXPRESSION = new JSCompositeElementType("SPREAD_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSSpreadExpressionImpl(node);
        }
    };
    public static final IElementType GENERATOR_EXPRESSION = new JSCompositeElementType("GENERATOR_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new JSGeneratorExpressionImpl(node);
        }
    };
    public static final IElementType TYPE_ASSERTION = new JSCompositeElementType("TYPE_ASSERTION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new TypeScriptTypeAssertionImpl(node);
        }
    };
    public static final IElementType TYPE_AS_EXPRESSION = new JSCompositeElementType("TYPESCRIPT_AS_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new TypeScriptAsExpressionImpl(node);
        }
    };
    public static final IElementType NOT_NULL_EXPRESSION = new JSCompositeElementType("TYPESCRIPT_NOT_NULL_EXPRESSION"){

        @Override
        public JSElement construct(ASTNode node) {
            return new TypeScriptNotNullExpressionImpl(node);
        }
    };
    public static final TokenSet TYPESCRIPT_OR_ES6_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{TypeScriptElementTypes.TYPESCRIPT_TYPES, TokenSet.create((IElementType[])new IElementType[]{FlowJSElementTypes.BOOLEAN_LITERAL_TYPE, FlowJSElementTypes.MAYBE_TYPE, FlowJSElementTypes.NUMBER_LITERAL_TYPE})});
    public static final TokenSet DESTRUCTURING_CONTAINERS = TokenSet.create((IElementType[])new IElementType[]{DESTRUCTURING_OBJECT, DESTRUCTURING_ARRAY, DESTRUCTURING_ELEMENT, DESTRUCTURING_PARAMETER});
    public static final TokenSet BODY_VARIABLES = TokenSet.create((IElementType[])new IElementType[]{VARIABLE, LOCAL_VARIABLE, TypeScriptElementTypes.TYPESCRIPT_VARIABLE, ActionScriptElementTypes.VARIABLE, ES6ElementTypes.FIELD, TypeScriptElementTypes.TYPESCRIPT_FIELD});
    public static final TokenSet ES6_CLASS_FIELDS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.FIELD, TypeScriptElementTypes.TYPESCRIPT_FIELD});
    public static final TokenSet FUNCTION_DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{FUNCTION_DECLARATION, TYPESCRIPT_FUNCTION, ActionScriptElementTypes.FUNCTION_DECLARATION});
    public static final TokenSet FUNCTION_EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{FUNCTION_EXPRESSION, TYPESCRIPT_FUNCTION_EXPRESSION, ActionScriptElementTypes.FUNCTION_EXPRESSION});
    public static final TokenSet FUNCTION_PROPERTIES = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.FUNCTION_PROPERTY, TYPESCRIPT_FUNCTION_PROPERTY});
    public static final TokenSet EXPRESSIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{DESTRUCTURING_ELEMENT, DESTRUCTURING_PARAMETER, THIS_EXPRESSION, REFERENCE_EXPRESSION, LITERAL_EXPRESSION, PARENTHESIZED_EXPRESSION, ARRAY_LITERAL_EXPRESSION, OBJECT_LITERAL_EXPRESSION, ASSIGNMENT_EXPRESSION, CONDITIONAL_EXPRESSION, BINARY_EXPRESSION, PREFIX_EXPRESSION, POSTFIX_EXPRESSION, COMMA_EXPRESSION, INDEXED_PROPERTY_ACCESS_EXPRESSION, CALL_EXPRESSION, DEFINITION_EXPRESSION, XML_LITERAL_EXPRESSION, SUPER_EXPRESSION, LET_EXPRESSION, ARRAY_COMPREHENSION, STRING_TEMPLATE_EXPRESSION, GENERATOR_EXPRESSION, TYPE_ASSERTION, YIELD_EXPRESSION, ES6ElementTypes.CLASS_EXPRESSION, ES6ElementTypes.META_PROPERTY, ES6ElementTypes.DO_EXPRESSION, TYPE_AS_EXPRESSION, NOT_NULL_EXPRESSION, NashornJSElementTypes.EXEC_STRING, NashornJSElementTypes.HEREDOC, JSStubElementTypes.TYPESCRIPT_CLASS_EXPRESSION, FlowJSElementTypes.TYPE_CAST, ES6ElementTypes.BIND_EXPRESSION, SPREAD_EXPRESSION, ES6ElementTypes.IMPORT_CALL, ES6ElementTypes.TAGGED_TEMPLATE_EXPRESSION}), FUNCTION_EXPRESSIONS, NEW_EXPRESSIONS});
    public static final TokenSet PARAMETER_LISTS = TokenSet.create((IElementType[])new IElementType[]{PARAMETER_LIST, TypeScriptElementTypes.TYPESCRIPT_PARAMETER_LIST});
    public static final TokenSet EXTENDS_LISTS = TokenSet.create((IElementType[])new IElementType[]{DEFAULT_EXTENDS_LIST, ES6_EXTENDS_LIST});
    public static final TokenSet EXTENDS_IMPLEMENTS_LISTS = TokenSet.create((IElementType[])new IElementType[]{DEFAULT_EXTENDS_LIST, ES6_EXTENDS_LIST, IMPLEMENTS_LIST});
    public static final TokenSet VAR_STATEMENTS = TokenSet.create((IElementType[])new IElementType[]{VAR_STATEMENT, ES6ElementTypes.FIELD_STATEMENT});
}

